/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AbstractMethodCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;

public class NewDefiningMethodProposal
extends AbstractMethodCorrectionProposal {
    private final IMethodBinding fMethod;
    private final String[] fParamNames;

    public NewDefiningMethodProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, ITypeBinding binding, IMethodBinding method, String[] paramNames, int relevance) {
        super(label, targetCU, invocationNode, binding, relevance, null);
        this.fMethod = method;
        this.fParamNames = paramNames;
        ImageDescriptor desc = JavaElementImageProvider.getMethodImageDescriptor(binding.isInterface() || binding.isAnnotation(), method.getModifiers());
        this.setImage(JavaPlugin.getImageDescriptorRegistry().get(desc));
    }

    @Override
    protected boolean isConstructor() {
        return this.fMethod.isConstructor();
    }

    @Override
    protected void addNewParameters(ASTRewrite rewrite, List<String> takenNames, List<SingleVariableDeclaration> params) throws CoreException {
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getParameterTypes();
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[][] paramNames = StubUtility.suggestArgumentNamesWithProposals(project, this.fParamNames);
        int i = 0;
        while (i < bindings.length) {
            ITypeBinding curr = bindings[i];
            String[] proposedNames = paramNames[i];
            SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
            newParam.setType(importRewrite.addImport(curr, ast));
            newParam.setName(ast.newSimpleName(proposedNames[0]));
            params.add(newParam);
            String groupId = "arg_name_" + i;
            this.addLinkedPosition(rewrite.track((ASTNode)newParam.getName()), false, groupId);
            int k = 0;
            while (k < proposedNames.length) {
                this.addLinkedPositionProposal(groupId, proposedNames[k], null);
                ++k;
            }
            ++i;
        }
    }

    @Override
    protected SimpleName getNewName(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        SimpleName nameNode = ast.newSimpleName(this.fMethod.getName());
        return nameNode;
    }

    private int evaluateModifiers() {
        if (this.getSenderBinding().isInterface()) {
            return 0;
        }
        int modifiers = this.fMethod.getModifiers();
        if (Modifier.isPrivate((int)modifiers)) {
            modifiers |= 4;
        }
        return modifiers & 0xC05;
    }

    @Override
    protected void addNewModifiers(ASTRewrite rewrite, ASTNode targetTypeDecl, List<IExtendedModifier> modifiers) {
        modifiers.addAll(rewrite.getAST().newModifiers(this.evaluateModifiers()));
    }

    @Override
    protected Type getNewMethodType(ASTRewrite rewrite) throws CoreException {
        return this.getImportRewrite().addImport(this.fMethod.getReturnType(), rewrite.getAST());
    }

    @Override
    protected void addNewExceptions(ASTRewrite rewrite, List<Type> exceptions) throws CoreException {
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getExceptionTypes();
        int i = 0;
        while (i < bindings.length) {
            Type newType = importRewrite.addImport(bindings[i], ast);
            exceptions.add(newType);
            this.addLinkedPosition(rewrite.track((ASTNode)newType), false, "exc_type_" + i);
            ++i;
        }
    }

    @Override
    protected void addNewTypeParameters(ASTRewrite rewrite, List<String> takenNames, List<TypeParameter> params) throws CoreException {
    }
}

