/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json.impl.schema;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.json.impl.schema.JSONSchemaNode;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonArray;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.schema.IJSONSchemaNode;
import org.eclipse.json.schema.IJSONSchemaProperty;
import org.eclipse.json.schema.JSONSchemaType;

public class JSONSchemaProperty
extends JSONSchemaNode
implements IJSONSchemaProperty {
    private static final String QUOTE = "\"";
    private final String name;
    private final String description;
    private JSONSchemaType[] type;
    private String defaultValue;
    private List<String> enumList;

    public JSONSchemaProperty(String name, JsonObject jsonObject, IJSONSchemaNode parent) {
        super(jsonObject, parent);
        this.name = name;
        this.description = jsonObject.getString("description", null);
        this.type = this.getType(jsonObject.get("type"));
        JsonValue value = jsonObject.get("default");
        if (value != null) {
            this.defaultValue = this.removeQuote(value);
        }
        if ((value = jsonObject.get("enum")) instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            List<JsonValue> items = array.values();
            for (JsonValue v : items) {
                String str;
                if (v == null) continue;
                if ((this.type == null || this.type.length == 0) && (str = v.toString()).startsWith(QUOTE) && str.endsWith(QUOTE)) {
                    this.type = new JSONSchemaType[]{JSONSchemaType.String};
                }
                this.addEnum(this.removeQuote(v));
            }
        }
    }

    private String removeQuote(JsonValue value) {
        String str = value.toString();
        if (str.startsWith(QUOTE)) {
            str = str.substring(1);
        }
        if (str.endsWith(QUOTE)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private JSONSchemaType[] getType(JsonValue value) {
        if (value == null) {
            return JSONSchemaType.EMPTY_TYPES;
        }
        JSONSchemaType t = null;
        ArrayList<JSONSchemaType> types = new ArrayList<JSONSchemaType>();
        if (value.isString()) {
            t = JSONSchemaType.getType(value.asString());
            if (t != null) {
                types.add(t);
            }
        } else if (value.isArray()) {
            JsonArray array = (JsonArray)value;
            for (JsonValue item : array) {
                t = JSONSchemaType.getType(item.asString());
                if (t == null) continue;
                types.add(t);
            }
        }
        return types.toArray(JSONSchemaType.EMPTY_TYPES);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public JSONSchemaType[] getType() {
        return this.type;
    }

    @Override
    public JSONSchemaType getFirstType() {
        if (this.type == null) {
            return null;
        }
        if (this.type.length == 0) {
            return null;
        }
        return this.type[0];
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<String> getEnumList() {
        return this.enumList;
    }

    public void addEnum(String item) {
        if (this.enumList == null) {
            this.enumList = new LinkedList<String>();
        }
        this.enumList.add(item);
    }
}

