/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.model;

import java.util.Date;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.TestResultNode;

public class ALMChange {
    protected static final int MAX_DATA_STRING_LENGTH = 200;
    private String m_timestamp;
    private String m_nodeType;
    private String m_nodeNameAndParams;
    private String m_dashboardURL;
    private String m_summaryId;
    private Long m_nodeNumber;
    private TestResultNode m_node;
    private ITestResultSummaryPO m_summary;

    public ALMChange(TestResultNode resultNode, String dashboardURL, ITestResultSummaryPO summary, Long nodeCount) {
        this.setDashboardURL(dashboardURL);
        this.setNode(resultNode);
        this.setSummary(summary);
        this.setSummaryId(summary.getId().toString());
        this.setNodeNumber(nodeCount);
        Date executionTime = resultNode.getTimeStamp();
        if (executionTime != null) {
            this.setTimestamp(executionTime.toString());
        } else {
            this.setTimestamp(Messages.NotAvailable);
        }
        this.setNodeType(resultNode.getTypeOfNode());
    }

    public String getDashboardURL() {
        return String.valueOf(this.m_dashboardURL) + "?" + "summaryId" + "=" + this.getSummaryId() + "&" + "resultNode" + "=" + String.valueOf(this.getNodeNumber());
    }

    public String getTimestamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.m_timestamp = timestamp;
    }

    public String getNodeType() {
        return this.m_nodeType;
    }

    public TestResultNode getNode() {
        return this.m_node;
    }

    public void setNode(TestResultNode node) {
        this.m_node = node;
    }

    public void setNodeType(String nodeType) {
        this.m_nodeType = nodeType;
    }

    public String getNodeNameAndParams() {
        return this.m_nodeNameAndParams;
    }

    public void setNodeNameAndParams(String nodeNameAndParams) {
        this.m_nodeNameAndParams = nodeNameAndParams;
    }

    public void setDashboardURL(String dashboardURL) {
        this.m_dashboardURL = dashboardURL;
    }

    public String getSummaryId() {
        return this.m_summaryId;
    }

    public void setSummaryId(String summaryId) {
        this.m_summaryId = summaryId;
    }

    private void setSummary(ITestResultSummaryPO summary) {
        this.m_summary = summary;
    }

    public ITestResultSummaryPO getSummary() {
        return this.m_summary;
    }

    public Long getNodeNumber() {
        return this.m_nodeNumber;
    }

    public void setNodeNumber(Long nodeNumber) {
        this.m_nodeNumber = nodeNumber;
    }
}

