/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.persistence.PersistenceException;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jubula.client.archive.ImportExportUtil;
import org.eclipse.jubula.client.archive.JsonExporter;
import org.eclipse.jubula.client.archive.JsonImporter;
import org.eclipse.jubula.client.archive.JsonVersion;
import org.eclipse.jubula.client.archive.dto.ExportInfoDTO;
import org.eclipse.jubula.client.archive.dto.ProjectDTO;
import org.eclipse.jubula.client.archive.dto.TestresultSummaryDTO;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStorage {
    public static final String PJT = "pjt";
    public static final String RST = "rst";
    public static final String NFO = "nfo";
    private static final String TMP_EXCHANGE_FOLDER_NAME = "JubArchiveTemp";
    private static Logger log = LoggerFactory.getLogger(JsonStorage.class);

    public static ProjectDTO save(IProjectPO proj, String fileName, boolean includeTestResultSummaries, IProgressMonitor monitor, IProgressConsole console) throws PMException, ProjectDeletedException {
        monitor.beginTask(Messages.GatheringProjectData, JsonStorage.getWorkToSave(proj, includeTestResultSummaries));
        monitor.subTask(Messages.ImportJsonStoragePreparing);
        Validate.notNull((Object)proj);
        try {
            if (fileName == null) {
                JsonExporter exporter = new JsonExporter(proj, monitor);
                return exporter.getProjectDTO();
            }
            JsonStorage.writeToFile(proj, monitor, fileName, includeTestResultSummaries);
        }
        catch (FileNotFoundException e) {
            log.info(String.valueOf(Messages.File) + " " + Messages.NotFound);
            console.writeStatus((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.NotFound));
            throw new PMSaveException(String.valueOf(Messages.File) + " " + fileName + Messages.NotFound + ":" + " " + e.toString(), MessageIDs.E_FILE_IO);
        }
        catch (IOException e) {
            if (!monitor.isCanceled()) {
                log.warn(Messages.GeneralIoExeption);
                console.writeStatus((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.GeneralIoExeption));
                throw new PMSaveException(String.valueOf(Messages.GeneralIoExeption) + e.toString(), MessageIDs.E_FILE_IO);
            }
        }
        catch (PersistenceException e) {
            log.warn(String.valueOf(Messages.CouldNotInitializeProxy) + ".");
            console.writeStatus((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.CouldNotInitializeProxy));
            throw new PMSaveException(e.getMessage(), MessageIDs.E_DATABASE_GENERAL);
        }
        catch (OperationCanceledException operationCanceledException) {
            log.info(Messages.ExportOperationCanceled);
            console.writeStatus((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.ExportOperationCanceled));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeToFile(IProjectPO proj, IProgressMonitor monitor, String fileName, boolean includeTestResultSummaries) throws ProjectDeletedException, PMException, IOException {
        ArrayList<String> fileList;
        String dir;
        block24: {
            dir = String.valueOf(Files.createTempDirectory(TMP_EXCHANGE_FOLDER_NAME, new FileAttribute[0]).toString()) + File.separatorChar;
            String infoFileName = String.valueOf(dir) + NFO;
            String projectFileName = String.valueOf(dir) + PJT;
            String testResultFileName = String.valueOf(dir) + RST;
            fileList = new ArrayList<String>();
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            ExportInfoDTO exportDTO = new ExportInfoDTO();
            exportDTO.setQualifier(ImportExportUtil.DATE_FORMATTER.format(new Date()));
            exportDTO.setEncoding(StandardCharsets.UTF_8.name());
            exportDTO.setVersion(JsonVersion.CURRENTLY_JSON_VERSION);
            try {
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try {
                        FileWriterWithEncoding infoWriter = new FileWriterWithEncoding(infoFileName, StandardCharsets.UTF_8);
                        try {
                            block23: {
                                FileWriterWithEncoding projectWriter = new FileWriterWithEncoding(projectFileName, StandardCharsets.UTF_8);
                                try {
                                    try (FileWriterWithEncoding resultWriter = new FileWriterWithEncoding(testResultFileName, StandardCharsets.UTF_8);){
                                        mapper.writeValue((Writer)infoWriter, (Object)exportDTO);
                                        fileList.add(infoFileName);
                                        JsonExporter exporter = new JsonExporter(proj, monitor);
                                        ProjectDTO projectDTO = exporter.getProjectDTO();
                                        mapper.writeValue((Writer)projectWriter, (Object)projectDTO);
                                        fileList.add(projectFileName);
                                        if (includeTestResultSummaries) {
                                            exporter.writeTestResultSummariesToFile(resultWriter);
                                            fileList.add(testResultFileName);
                                        }
                                        monitor.subTask(Messages.ImportJsonStorageCompress);
                                        JsonStorage.zipIt(fileName, fileList);
                                    }
                                    if (projectWriter == null) break block23;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (projectWriter == null) throw throwable;
                                    projectWriter.close();
                                    throw throwable;
                                }
                                projectWriter.close();
                            }
                            if (infoWriter == null) break block24;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (infoWriter == null) throw throwable;
                            infoWriter.close();
                            throw throwable;
                        }
                        infoWriter.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        }
                        if (throwable == throwable4) throw throwable;
                        throwable.addSuppressed(throwable4);
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    fileList.add(fileName);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                fileList.add(dir);
                JsonStorage.deleteFiles(fileList);
                throw throwable;
            }
        }
        fileList.add(dir);
        JsonStorage.deleteFiles(fileList);
    }

    private static void deleteFiles(List<String> files) {
        for (String fileSrt : files) {
            try {
                Files.deleteIfExists(new File(fileSrt).toPath());
            }
            catch (IOException iOException) {
                log.warn(String.valueOf(Messages.CantDeleteFile) + fileSrt);
            }
        }
    }

    public static int getWorkToSave(IProjectPO project, boolean includeTestResultSummaries) {
        return JsonExporter.getPredictedWork(project, includeTestResultSummaries);
    }

    public static int getWorkToSave(List<IProjectPO> projectsToSave) {
        int totalWork = 0;
        for (IProjectPO project : projectsToSave) {
            totalWork += JsonStorage.getWorkToSave(project, false);
        }
        return totalWork;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProjectPO readProject(URL url, ParamNameBPDecorator paramNameMapper, IWritableComponentNameCache compNameCache, boolean assignNewGuid, IProgressMonitor monitor, IProgressConsole io) throws JBVersionException, PMReadException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportFileBPReading, (int)2);
        IProjectPO projectPO = null;
        monitor.subTask(Messages.ImportJsonStoragePreparing);
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try {
                InputStream urlInputStream = url.openStream();
                try {
                    JsonImporter importer;
                    HashMap<String, Object> allDTOs;
                    block19: {
                        block18: {
                            ProjectDTO projectDTO;
                            ZipInputStream zipInputStream = new ZipInputStream(urlInputStream, StandardCharsets.UTF_8);
                            ObjectMapper mapper = new ObjectMapper();
                            mapper.disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE});
                            HashMap<String, Class> fileTypeMapping = new HashMap<String, Class>();
                            fileTypeMapping.put(NFO, ExportInfoDTO.class);
                            fileTypeMapping.put(PJT, ProjectDTO.class);
                            TypeReference<ArrayList<TestresultSummaryDTO>> tr = new TypeReference<ArrayList<TestresultSummaryDTO>>(){};
                            allDTOs = new HashMap<String, Object>();
                            int i = 0;
                            while (true) {
                                String entryName;
                                if (i >= 3) {
                                    ExportInfoDTO exportDTO = (ExportInfoDTO)allDTOs.get(NFO);
                                    this.checkMinimumRequiredJSONVersion(exportDTO);
                                    projectDTO = (ProjectDTO)allDTOs.get(PJT);
                                    if (!this.projectExists(projectDTO)) break;
                                    this.existProjectHandling(io, projectDTO);
                                }
                                ZipEntry entry = zipInputStream.getNextEntry();
                                Class entryTypeMapping = (Class)fileTypeMapping.get(entryName = entry.getName());
                                allDTOs.put(entryName, entryTypeMapping != null ? mapper.readValue((InputStream)zipInputStream, entryTypeMapping) : mapper.readValue((InputStream)zipInputStream, (TypeReference)tr));
                                ++i;
                            }
                            projectPO = JsonStorage.load(projectDTO, (IProgressMonitor)subMonitor.newChild(1), io, assignNewGuid, (IParamNameMapper)paramNameMapper, compNameCache, false);
                            importer = new JsonImporter(monitor, io, false);
                            break block19;
                            finally {
                                if (zipInputStream == null) break block18;
                                zipInputStream.close();
                            }
                        }
                        if (urlInputStream != null) {
                            urlInputStream.close();
                        }
                        return null;
                    }
                    List summaryDTOs = (List)allDTOs.get(RST);
                    importer.initTestResultSummaries((IProgressMonitor)subMonitor.newChild(1), summaryDTOs, projectPO);
                    if (urlInputStream == null) return projectPO;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (urlInputStream == null) throw throwable;
                    urlInputStream.close();
                    throw throwable;
                }
                urlInputStream.close();
                return projectPO;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            if (monitor.isCanceled()) return projectPO;
            log.info(Messages.GeneralIoExeption);
            throw new PMReadException(Messages.InvalidImportFile, MessageIDs.E_IO_EXCEPTION);
        }
    }

    public static IProjectPO load(ProjectDTO dto, IProgressMonitor monitor, IProgressConsole io, boolean assignNewGuid, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, boolean skipTrackingInformation) throws JBVersionException, InterruptedException, PMReadException {
        IProjectPO projectPO = null;
        try {
            JsonImporter importer = new JsonImporter(monitor, io, skipTrackingInformation);
            projectPO = importer.createProject(dto, assignNewGuid, paramNameMapper, compNameCache);
        }
        catch (InvalidDataException e) {
            throw new PMReadException(Messages.InvalidImportFile, e.getErrorId());
        }
        return projectPO;
    }

    private void existProjectHandling(IProgressConsole io, ProjectDTO projectDTO) {
        String msg = String.valueOf(NLS.bind((String)Messages.ErrorMessageIMPORT_PROJECT_FAILED, (Object[])new String[]{ProjectNameBP.getInstance().getName(projectDTO.getUuid(), false)})) + "\n" + NLS.bind((String)Messages.ErrorMessageIMPORT_PROJECT_FAILED_EXISTING, (Object[])new String[]{projectDTO.getName(), projectDTO.getProjectVersion().toString()});
        io.writeStatus((IStatus)new Status(2, "org.eclipse.jubula.client.core", msg));
    }

    private void checkMinimumRequiredJSONVersion(ExportInfoDTO dto) throws JBVersionException {
        if (dto.getVersion() == null || !JsonVersion.isCompatible(dto.getVersion())) {
            ArrayList<String> errorMsgs = new ArrayList<String>();
            errorMsgs.add(Messages.JubImporterProjectJUBTooOld);
            throw new JBVersionException(Messages.JubImporterProjectJUBTooOld, MessageIDs.E_LOAD_PROJECT_XML_VERSION_ERROR, errorMsgs);
        }
    }

    private static void zipIt(String zipFile, ArrayList<String> fileList) throws IOException {
        byte[] buffer = new byte[1024];
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (String file : fileList) {
            int len;
            String fileName = file.substring(file.lastIndexOf(File.separator) + 1);
            ZipEntry ze = new ZipEntry(fileName);
            zos.putNextEntry(ze);
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            in.close();
        }
        zos.closeEntry();
        zos.close();
    }

    private boolean projectExists(ProjectDTO dto) {
        return ProjectPM.doesProjectVersionExist((String)dto.getUuid(), (Integer)dto.getMajorProjectVersion(), (Integer)dto.getMinorProjectVersion(), (Integer)dto.getMicroProjectVersion(), (String)dto.getProjectVersionQualifier());
    }
}

