/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ControlledCache;

public class ComponentNameReuseBP
implements DataEventDispatcher.IDataChangedListener {
    private static ComponentNameReuseBP instance = null;
    private ControlledCache<String, Boolean> m_compNameGuidToIsReusedMap = new ControlledCache(new ControlledCache.ControlTypes[]{ControlledCache.ControlTypes.PROJECT_LOADED});

    private ComponentNameReuseBP() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, false);
    }

    public boolean isCompNameReused(String compNameGuid) {
        if (this.m_compNameGuidToIsReusedMap.get((Object)compNameGuid) != null) {
            return (Boolean)this.m_compNameGuidToIsReusedMap.get((Object)compNameGuid);
        }
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null) {
            List specsToSearch = currentProject.getSpecObjCont().getSpecObjList();
            Set autsToSearch = currentProject.getAutMainList();
            boolean isReused = ComponentNamesBP.getInstance().isCompNameReused((Collection)specsToSearch, (Collection)TestSuiteBP.getListOfTestSuites((IProjectPO)currentProject), (Collection)autsToSearch, compNameGuid);
            this.m_compNameGuidToIsReusedMap.add((Object)compNameGuid, (Object)isReused);
            return isReused;
        }
        return false;
    }

    public Set<String> getUsedCompNames(Set<String> searchedCompNameGuids) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        HashSet<String> usedComponents = new HashSet<String>();
        if (currentProject != null) {
            List specsToSearch = currentProject.getSpecObjCont().getSpecObjList();
            Set autsToSearch = currentProject.getAutMainList();
            boolean isAllSearchedCompNameCached = true;
            for (String compNameGuid : searchedCompNameGuids) {
                if (this.m_compNameGuidToIsReusedMap.get((Object)compNameGuid) != null) {
                    if (((Boolean)this.m_compNameGuidToIsReusedMap.get((Object)compNameGuid)).booleanValue()) {
                        usedComponents.add(compNameGuid);
                        continue;
                    }
                } else {
                    isAllSearchedCompNameCached = false;
                }
                if (ComponentNamesBP.getInstance().findAssocsOfReuse((Collection)autsToSearch, compNameGuid).isEmpty()) continue;
                usedComponents.add(compNameGuid);
            }
            if (isAllSearchedCompNameCached) {
                for (String compNameGuid : this.m_compNameGuidToIsReusedMap.getKeySet()) {
                    if (!((Boolean)this.m_compNameGuidToIsReusedMap.get((Object)compNameGuid)).booleanValue()) continue;
                    usedComponents.add(compNameGuid);
                }
                return usedComponents;
            }
            usedComponents.addAll(ComponentNamesBP.getInstance().getReusedCompNames((Collection)specsToSearch, (Collection)TestSuiteBP.getListOfTestSuites((IProjectPO)currentProject), searchedCompNameGuids));
            for (String searchedCompNameGuid : searchedCompNameGuids) {
                this.m_compNameGuidToIsReusedMap.add((Object)searchedCompNameGuid, (Object)usedComponents.contains(searchedCompNameGuid));
            }
        }
        return usedComponents;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            if (e.getPo() instanceof IComponentNamePO) {
                IComponentNamePO compName = (IComponentNamePO)e.getPo();
                switch (e.getDataState()) {
                    case ReuseChanged: {
                        this.m_compNameGuidToIsReusedMap.remove((Object)compName.getGuid());
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    public static ComponentNameReuseBP getInstance() {
        if (instance == null) {
            instance = new ComponentNameReuseBP();
        }
        return instance;
    }
}

