/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.List;
import javax.persistence.PersistenceException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTreeItemHandlerTCEditor
extends AbstractDeleteTreeItemHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractJBEditor) {
            final AbstractJBEditor tce = (AbstractJBEditor)activePart;
            tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    IStructuredSelection structuredSelection = DeleteTreeItemHandlerTCEditor.this.getSelection();
                    if (DeleteTreeItemHandlerTCEditor.this.confirmDelete(structuredSelection)) {
                        DeleteTreeItemHandlerTCEditor.deleteNodesFromEditor(structuredSelection.toList(), tce);
                    }
                }
            });
        }
        return null;
    }

    public static void deleteNodesFromEditor(List<? extends INodePO> nodes, AbstractJBEditor editor) {
        editor.getEditorHelper().getClipboard().clearContents();
        for (INodePO iNodePO : nodes) {
            try {
                iNodePO.getParentNode().removeNode(iNodePO);
                if (iNodePO.getId() != null) {
                    editor.getEditorHelper().getEditSupport().getSession().remove((Object)iNodePO);
                }
                editor.getEditorHelper().setDirty(true);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)iNodePO, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
            }
            catch (PersistenceException e) {
                try {
                    PersistenceManager.handleDBExceptionForEditor((IPersistentObject)iNodePO, (PersistenceException)e, (EditSupport)editor.getEditorHelper().getEditSupport());
                }
                catch (PMException pme) {
                    PMExceptionHandler.handlePMExceptionForMasterSession(pme);
                }
            }
        }
    }
}

