/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public abstract class BaseMultiBrowserComposite
extends Composite {
    public static final GridData BUTTON_LAYOUT = new GridData();
    private List m_itemList;
    private Button m_addElementButton;
    private Button m_editElementButton;
    private Button m_removeElementButton;

    static {
        BaseMultiBrowserComposite.BUTTON_LAYOUT.horizontalAlignment = 4;
        BaseMultiBrowserComposite.BUTTON_LAYOUT.grabExcessHorizontalSpace = true;
    }

    public BaseMultiBrowserComposite(Composite parent, String attrId, String configurationValue) {
        super(parent, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.heightHint = 1;
        this.setLayoutData(layoutData);
        this.m_itemList = new List(parent, 2818);
        this.m_itemList.setData("MONITORING_KEY", (Object)attrId);
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_itemList), (int)2) + 10;
        LayoutUtil.addToolTipAndMaxWidth((GridData)textGridData, (Control)this.m_itemList);
        this.m_itemList.setLayoutData((Object)textGridData);
        this.initList(configurationValue);
        this.m_itemList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseMultiBrowserComposite.this.checkActionButtons();
                BaseMultiBrowserComposite.this.m_itemList.setFocus();
            }
        });
        Composite dirctoryActionComposite = UIComponentHelper.createLayoutComposite((Composite)parent, (int)3);
        this.initActionButtons(dirctoryActionComposite);
        this.checkActionButtons();
    }

    public List getItemList() {
        return this.m_itemList;
    }

    protected void initActionButtons(Composite dirctoryActionComposite) {
        this.m_addElementButton = new Button(dirctoryActionComposite, 8);
        this.m_editElementButton = new Button(dirctoryActionComposite, 8);
        this.m_removeElementButton = new Button(dirctoryActionComposite, 8);
        this.m_addElementButton.setText(Messages.AUTConfigComponentElement);
        this.m_addElementButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_addElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BaseMultiBrowserComposite.this.handleSelection(false);
                BaseMultiBrowserComposite.this.checkActionButtons();
            }
        });
        this.m_editElementButton.setText(Messages.AUTConfigComponentEdit);
        this.m_editElementButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_editElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseMultiBrowserComposite.this.handleSelection(true);
                BaseMultiBrowserComposite.this.checkActionButtons();
            }
        });
        this.m_removeElementButton.setText(Messages.AUTConfigComponentRemove);
        this.m_removeElementButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_removeElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseMultiBrowserComposite.this.handleItemRemove();
                BaseMultiBrowserComposite.this.checkActionButtons();
            }
        });
    }

    protected void handleItemRemove() {
        int selectionIndex = this.m_itemList.getSelectionIndex();
        this.m_itemList.remove(this.m_itemList.getSelection()[0]);
        if (this.m_itemList.getItemCount() >= selectionIndex) {
            this.m_itemList.select(selectionIndex - 1);
        }
        if (this.m_itemList.getItemCount() == 1) {
            this.m_itemList.select(0);
        }
        if (this.m_itemList.getSelectionCount() == 0) {
            this.m_itemList.select(0);
        }
        this.updateStoredValues();
    }

    void initList(String configurationValue) {
        this.getItemList().removeAll();
        if (!StringUtils.isEmpty((String)configurationValue)) {
            String[] items = configurationValue.split(";");
            int i = 0;
            while (i < items.length) {
                this.getItemList().add(items[i]);
                ++i;
            }
        }
    }

    protected int getItemsLength() {
        String directories = "";
        int i = 0;
        while (i < this.getItemList().getItemCount()) {
            directories = directories.concat(String.valueOf(this.getItemList().getItem(i)) + ";");
            ++i;
        }
        return directories.length();
    }

    protected String getItemPathes() {
        String itemList = "";
        int i = 0;
        while (i < this.getItemList().getItemCount()) {
            itemList = itemList.concat(String.valueOf(this.getItemList().getItem(i)) + ";");
            ++i;
        }
        if (!"".equals(itemList)) {
            itemList = itemList.substring(0, itemList.length() - 1);
        }
        return itemList;
    }

    abstract void handleSelection(boolean var1);

    abstract void updateStoredValues();

    protected void checkActionButtons() {
        if (this.m_itemList.getItemCount() == 0) {
            this.m_removeElementButton.setEnabled(false);
            this.m_editElementButton.setEnabled(false);
            return;
        }
        if (this.m_itemList.getSelectionCount() > 0) {
            this.m_removeElementButton.setEnabled(true);
            this.m_editElementButton.setEnabled(true);
        } else {
            this.m_removeElementButton.setEnabled(false);
            this.m_editElementButton.setEnabled(false);
        }
    }
}

