/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.internal.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.jubula.tools.internal.version.IVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionState {
    public static final String SEPARATOR = "/";
    public static final int STATE_INDEX = 0;
    public static final int VERSION_INDEX = 1;
    public static final int UNKNOWN = -1;
    public static final int SERVER_OK = 0;
    public static final int SERVER_BUSY = 1;
    public static final int VERSION_ERROR = 2;
    public static final String CLIENT_TYPE_REQUEST = "ClientTypeRequest";
    public static final String CLIENT_TYPE_SINGLE = "ClientType.Exclusive";
    public static final String CLIENT_TYPE_AUT = "ClientType.Aut";
    public static final String CLIENT_TYPE_AUTRUN = "ClientType.autrun";
    public static final String CLIENT_TYPE_COMMAND_SHUTDOWN = "ClientType.Command.ShutDown";
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionState.class);

    private ConnectionState() {
    }

    public static int parseState(String message) {
        StringTokenizer tok = new StringTokenizer(message, SEPARATOR);
        try {
            if (tok.hasMoreTokens()) {
                String stateStr = tok.nextToken();
                return Integer.parseInt(stateStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return -1;
    }

    public static int parseVersion(String message) {
        StringTokenizer tok = new StringTokenizer(message, SEPARATOR);
        if (tok.countTokens() < 2) {
            return -1;
        }
        String versionStr = "";
        int i = 0;
        while (i < 2) {
            if (tok.hasMoreTokens()) {
                versionStr = tok.nextToken();
            }
            ++i;
        }
        try {
            return Integer.parseInt(versionStr);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static boolean respondToTypeRequest(long waitForServer, BufferedReader inputReader, InputStream inputStream, PrintStream outputStream, String response) throws JBVersionException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("waiting for server's 'client type request' with timeout: " + String.valueOf(waitForServer));
        }
        long waitTime = 0L;
        boolean success = false;
        while (!success && waitTime <= waitForServer) {
            if (inputStream.available() > 0) {
                String line = inputReader.readLine();
                success = true;
                int version = Integer.parseInt(String.valueOf(IVersion.JB_PROTOCOL_MAJOR_VERSION));
                if (ConnectionState.parseVersion(line) != version) {
                    throw new JBVersionException("Version error between Client and Server!", MessageIDs.E_VERSION_ERROR);
                }
                if (line != null) {
                    line = line.substring(0, line.indexOf(SEPARATOR));
                }
                if (CLIENT_TYPE_REQUEST.equals(line)) {
                    LOG.debug("sending response: " + response);
                    outputStream.println(response);
                    outputStream.flush();
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                StringBuffer errBuf = new StringBuffer();
                errBuf.append("Received invalid request from server. Expected '").append(CLIENT_TYPE_REQUEST).append("' but received '").append(line).append("'.");
                LOG.warn(errBuf.toString());
                continue;
            }
            waitTime += TimeUtil.delay((long)500L);
        }
        if (!success) {
            LOG.error("Did not receive expected request from server.");
        }
        return success;
    }
}

