/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.util;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static AutServerLogger log = new AutServerLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static Object[] getParameterValues(String args, @Nullable String argsSplit, Class<?>[] parameterClasses) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String[] argValues = !StringUtils.isEmpty((String)argsSplit) ? args.split(argsSplit) : new String[]{args};
        if (argValues.length != parameterClasses.length) {
            throw new StepExecutionException("Invalid number of parameters", EventFactory.createActionError((String)"TestErrorEvent.InvalidInput"));
        }
        Object[] argObjects = new Object[argValues.length];
        int i = 0;
        while (i < argValues.length) {
            argObjects[i] = ConstructorUtils.invokeExactConstructor(parameterClasses[i], (Object)argValues[i]);
            ++i;
        }
        return argObjects;
    }

    public static Class<?>[] getParameterClasses(String signatureList, ClassLoader classLoader) throws ClassNotFoundException {
        String[] sign = signatureList.split(",");
        Class[] parameterClasses = new Class[sign.length];
        int i = 0;
        while (i < sign.length) {
            parameterClasses[i] = Class.forName(sign[i], true, classLoader);
            ++i;
        }
        return parameterClasses;
    }

    public static Object invokeMethod(String fqcn, String name, @Nullable String signature, @Nullable String args, @Nullable String argsSplit, ClassLoader uiClassLoader) throws Throwable, StepVerifyFailedException {
        Class<?> clazz = Class.forName(fqcn, true, uiClassLoader);
        Class[] parameterClasses = new Class[]{};
        Object[] argObjects = new Object[]{};
        if (!StringUtils.isEmpty((String)signature) && !StringUtils.isEmpty((String)args)) {
            parameterClasses = ReflectionUtil.getParameterClasses(signature, uiClassLoader);
            argObjects = ReflectionUtil.getParameterValues(args, argsSplit, parameterClasses);
        }
        return MethodUtils.invokeStaticMethod(clazz, (String)name, (Object[])argObjects, (Class[])parameterClasses);
    }

    public static Object invokeMethod(String fqcn, String name, ClassLoader uiClassloader) throws Throwable, StepVerifyFailedException {
        Class<?> clazz = Class.forName(fqcn, true, uiClassloader);
        return MethodUtils.invokeStaticMethod(clazz, (String)name, null, null);
    }

    public static void handleException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalStateException) {
                throw new StepExecutionException(e.toString(), EventFactory.createVerifyFailed((String)"", (String)cause.toString()));
            }
            throw new StepExecutionException(cause.toString(), EventFactory.createActionError((String)"TestErrorEvent.ExecutionError", (Object[])new String[]{cause.toString()}));
        }
        if (e instanceof NullPointerException) {
            log.warn("Nullpointer occured trying to invoke a method", e);
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ExecutionError", (Object[])new String[]{"Invoke method failed. The method might not be static"}));
        }
        throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ExecutionError", (Object[])new String[]{e.toString()}));
    }
}

