/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.exec;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.exec.launcher.CommandLauncher;
import org.apache.commons.exec.launcher.Java13CommandLauncher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.Nullable;

public class CommandExecutor {
    public static final long NO_TIMEOUT = -1L;

    private CommandExecutor() {
    }

    public static Result exec(@Nullable String workingDir, String executable, @Nullable String rawArguments, @Nullable Character splitCharacter, long timeout, @Nullable String encoding, @Nullable Boolean newEnvironment) throws ExecuteException, IOException, InterruptedException, TimeoutException, IllegalCharsetNameException, UnsupportedCharsetException {
        String outputEncoding = encoding;
        if (outputEncoding == null) {
            outputEncoding = Charset.defaultCharset().name();
        } else {
            boolean supported = Charset.isSupported(encoding);
            if (!supported) {
                throw new UnsupportedCharsetException(encoding);
            }
        }
        CommandLine cmdLine = new CommandLine(executable);
        Object arguments = splitCharacter != null ? StringUtils.split((String)rawArguments, (char)splitCharacter.charValue()) : (StringUtils.isNotEmpty((String)rawArguments) ? new String[]{rawArguments} : null);
        if (arguments != null) {
            String[] stringArray = arguments;
            int n = ((String[])arguments).length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                cmdLine.addArgument(argument, true);
                ++n2;
            }
        }
        ExtendedDefaultExecutor executor = new ExtendedDefaultExecutor();
        executor.setWorkingDirectory(new File(StringUtils.isNotBlank((String)workingDir) ? workingDir : "."));
        ByteArrayOutputStream combinedStream = new ByteArrayOutputStream();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TeeOutputStream outStreamTee = new TeeOutputStream((OutputStream)outStream, (OutputStream)combinedStream);
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        TeeOutputStream errStreamTee = new TeeOutputStream((OutputStream)errStream, (OutputStream)combinedStream);
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)outStreamTee, (OutputStream)errStreamTee);
        executor.setStreamHandler((ExecuteStreamHandler)pumpStreamHandler);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(timeout);
        executor.setWatchdog(watchdog);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        Result r = new Result(encoding, outStream, errStream, combinedStream);
        HashMap environment = EnvironmentUtils.getProcEnvironment();
        if (newEnvironment != null && newEnvironment.booleanValue()) {
            environment = new HashMap(0);
        }
        CommandExecutor.removeJavaOptions(environment);
        executor.execute(cmdLine, environment, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor();
        if (watchdog.killedProcess()) {
            throw new TimeoutException(r.getCombinedOutput());
        }
        int exitValue = resultHandler.getExitValue();
        if (-559038737 == exitValue) {
            throw new IOException();
        }
        r.setReturnValue(exitValue);
        return r;
    }

    private static void removeJavaOptions(Map environment) {
        String javaOptions = (String)environment.get("_JAVA_OPTIONS");
        if (StringUtils.isNotBlank((String)javaOptions) && StringUtils.contains((String)javaOptions, (String)"-javaagent")) {
            environment.remove("_JAVA_OPTIONS");
        }
    }

    private static class ExtendedDefaultExecutor
    extends DefaultExecutor {
        private static final String CURRENT_VM_WORKING_DIR_ABS_PATH = FilenameUtils.getFullPathNoEndSeparator((String)(String.valueOf(new File(System.getProperty("user.dir")).getAbsolutePath()) + File.separator));
        private CommandLauncher m_windowsCommandLauncher = new WindowsCommandLauncher();

        private ExtendedDefaultExecutor() {
        }

        protected Process launch(CommandLine command, Map env, File dir) throws IOException {
            FilenameUtils.getFullPathNoEndSeparator((String)dir.getAbsolutePath());
            String executable = command.getExecutable();
            File commandFile = new File(dir.getCanonicalFile(), executable);
            commandFile.exists();
            if (OS.isFamilyWindows()) {
                return this.m_windowsCommandLauncher.exec(command, env, dir);
            }
            return super.launch(command, env, dir);
        }
    }

    public static class Result {
        private Integer m_returnValue = null;
        private String m_encoding;
        private ByteArrayOutputStream m_outStream;
        private ByteArrayOutputStream m_errStream;
        private ByteArrayOutputStream m_combinedStream;

        public Result(String encoding, ByteArrayOutputStream outStream, ByteArrayOutputStream errStream, ByteArrayOutputStream combinedStream) {
            this.setEncoding(encoding);
            this.setOutStream(outStream);
            this.setErrStream(errStream);
            this.setCombinedStream(combinedStream);
        }

        public Integer getReturnValue() {
            return this.m_returnValue;
        }

        public void setReturnValue(Integer returnValue) {
            this.m_returnValue = returnValue;
        }

        public String getSysOut() throws UnsupportedEncodingException {
            return this.getOutStream().toString(this.getEncoding());
        }

        public String getCombinedOutput() throws UnsupportedEncodingException {
            return this.getCombinedStream().toString(this.getEncoding());
        }

        public String getSysErr() throws UnsupportedEncodingException {
            return this.getErrStream().toString(this.getEncoding());
        }

        public String getEncoding() {
            return this.m_encoding;
        }

        private void setEncoding(String encoding) {
            this.m_encoding = encoding;
        }

        public ByteArrayOutputStream getOutStream() {
            return this.m_outStream;
        }

        private void setOutStream(ByteArrayOutputStream outStream) {
            this.m_outStream = outStream;
        }

        public ByteArrayOutputStream getErrStream() {
            return this.m_errStream;
        }

        private void setErrStream(ByteArrayOutputStream errStream) {
            this.m_errStream = errStream;
        }

        public ByteArrayOutputStream getCombinedStream() {
            return this.m_combinedStream;
        }

        private void setCombinedStream(ByteArrayOutputStream combinedStream) {
            this.m_combinedStream = combinedStream;
        }
    }

    private static class WindowsCommandLauncher
    extends Java13CommandLauncher {
        private WindowsCommandLauncher() {
        }

        public Process exec(CommandLine cmd, Map environment, File workingDir) throws IOException {
            if (workingDir == null) {
                return this.exec(cmd, environment);
            }
            CommandLine windowsCommand = new CommandLine("cmd");
            windowsCommand.addArgument("/c");
            windowsCommand.addArguments(cmd.toStrings());
            return super.exec(windowsCommand, environment, workingDir);
        }
    }
}

