/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.model.view.impl.ViewFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportLayoutDataCommand
extends Command {
    private static final Logger logger = Logger.getLogger(ImportLayoutDataCommand.class);
    private WEEditor weeditor;
    private HashMap layoutData;
    private boolean onlyNew;
    private String src_viewID;
    private String dest_viewID;
    private Set<Scope> selectedScopes;

    public ImportLayoutDataCommand(WEEditor weeditor, Set<Scope> selectedScopes, String src_viewID, String dest_viewID, boolean onlyNew) {
        this.src_viewID = src_viewID;
        this.dest_viewID = dest_viewID;
        this.onlyNew = onlyNew;
        this.selectedScopes = selectedScopes;
        this.weeditor = weeditor;
    }

    private void layoutScope(Scope scope) {
        HashSet<Scope> contents = new HashSet<Scope>();
        contents.add(scope);
        contents.addAll((Collection<Scope>)scope.eContents());
        contents.addAll(EMFHelper.getAllContainedReferences(this.weeditor, contents));
        contents.addAll(EMFHelper.getAllContainedReferenceEdges(this.weeditor, contents));
        contents.remove(scope);
        for (EObject eObject : contents) {
            if (!(eObject instanceof GraphicalElement) || !Views.getInstance().displayObject(eObject)) continue;
            LayoutData targetLayoutData = LayoutDataManager.getLayoutDataForView(this.weeditor, (GraphicalElement)eObject, this.dest_viewID);
            LayoutData sourceLayoutData = LayoutDataManager.getLayoutDataForView(this.weeditor, (GraphicalElement)eObject, this.src_viewID);
            if (!sourceLayoutData.isInitialized() || this.onlyNew && targetLayoutData.isInitialized()) continue;
            LayoutData source = ViewFactoryImpl.eINSTANCE.createLayoutData();
            LayoutDataManager.transferLayoutDataValues(sourceLayoutData, source);
            this.layoutData.put(source, targetLayoutData);
        }
    }

    public void execute() {
        this.layoutData = new HashMap();
        for (Scope scope : this.selectedScopes) {
            this.layoutScope(scope);
        }
        this.redo();
    }

    public void redo() {
        for (Object src : this.layoutData.keySet()) {
            LayoutData source = (LayoutData)src;
            LayoutData target = (LayoutData)this.layoutData.get(src);
            LayoutData temp = ViewFactoryImpl.eINSTANCE.createLayoutData();
            LayoutDataManager.transferLayoutDataValues(source, temp);
            LayoutDataManager.transferLayoutDataValues(target, source);
            LayoutDataManager.transferLayoutDataValues(temp, target);
        }
    }

    public void undo() {
        this.redo();
    }

    public void dispose() {
        this.layoutData.clear();
        this.layoutData = null;
        this.selectedScopes.clear();
        this.selectedScopes = null;
        super.dispose();
    }
}

