/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.messages.ImageSearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.docker.core.IRepositoryTag;
import org.eclipse.linuxtools.internal.docker.core.DockerImageSearchResult;
import org.eclipse.linuxtools.internal.docker.core.ImageSearchResultV1;
import org.eclipse.linuxtools.internal.docker.core.ImageSearchResultV2;
import org.eclipse.linuxtools.internal.docker.core.RepositoryTag;
import org.eclipse.linuxtools.internal.docker.core.RepositoryTagV2;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;

public abstract class AbstractRegistry
implements IRegistry {
    public static final String[] DOCKERHUB_REGISTRY_ALIASES = new String[]{"registry.hub.docker.com", "index.docker.io"};
    public static final String DOCKERHUB_REGISTRY = "https://index.docker.io";
    private String cachedHTTPServerAddress;
    private Boolean isV2 = null;

    @Override
    public abstract String getServerAddress();

    public abstract String getServerHost();

    public abstract boolean isDockerHubRegistry();

    public abstract boolean isAuthProvided();

    private String getHTTPServerAddress() {
        if (this.cachedHTTPServerAddress != null) {
            return this.cachedHTTPServerAddress;
        }
        if (this.getServerAddress().startsWith("http")) {
            return this.getServerAddress();
        }
        String[] versions = new String[]{"v1", "v2"};
        String[] schemes = new String[]{"http://", "https://"};
        ClientConfig DEFAULT_CONFIG = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class});
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        String[] stringArray = schemes;
        int n = schemes.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            String[] stringArray2 = versions;
            int n3 = versions.length;
            int n4 = 0;
            while (n4 < n3) {
                String ver = stringArray2[n4];
                String url = String.valueOf(scheme) + this.getServerAddress();
                WebTarget queryServer = client.target(url).path(ver);
                try {
                    Response resp = (Response)queryServer.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET").get();
                    int code = resp.getStatus();
                    if (code >= 200 && code < 300) {
                        this.cachedHTTPServerAddress = url;
                        return url;
                    }
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                ++n4;
            }
            ++n2;
        }
        return "http://" + this.getServerAddress();
    }

    @Override
    public List<IDockerImageSearchResult> getImages(String term) throws DockerException {
        ClientConfig DEFAULT_CONFIG = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class});
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        ArrayList<IDockerImageSearchResult> result = new ArrayList<IDockerImageSearchResult>();
        if (this.isVersion2()) {
            GenericType<ImageSearchResultV2> IMAGE_SEARCH_RESULT_LIST = new GenericType<ImageSearchResultV2>(){};
            ImageSearchResultV2 cisr = null;
            WebTarget queryImagesResource = client.target(this.getHTTPServerAddress()).path("v2").path("_catalog");
            try {
                cisr = (ImageSearchResultV2)queryImagesResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)IMAGE_SEARCH_RESULT_LIST).get();
            }
            catch (InterruptedException | ExecutionException e2) {
                throw new DockerException(e2);
            }
            List tmp = cisr.getRepositories().stream().filter(e -> e.getName().contains(term)).collect(Collectors.toList());
            result.addAll(tmp.stream().map(r -> new DockerImageSearchResult(r.getDescription(), r.isOfficial(), r.isAutomated(), r.getName(), r.getStarCount())).collect(Collectors.toList()));
        } else {
            ImageSearchResultV1 pisr = null;
            GenericType<ImageSearchResultV1> IMAGE_SEARCH_RESULT_LIST = new GenericType<ImageSearchResultV1>(){};
            int page = 0;
            try {
                while (pisr == null || pisr.getPage() < pisr.getTotalPages()) {
                    WebTarget queryImagesResource = client.target(this.getHTTPServerAddress()).path("v1").path("search").queryParam("q", new Object[]{term}).queryParam("page", new Object[]{++page});
                    pisr = (ImageSearchResultV1)queryImagesResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)IMAGE_SEARCH_RESULT_LIST).get();
                    List<ImageSearchResult> tmp = pisr.getResult();
                    result.addAll(tmp.stream().map(r -> new DockerImageSearchResult(r.getDescription(), r.isOfficial(), r.isAutomated(), r.getName(), r.getStarCount())).collect(Collectors.toList()));
                }
            }
            catch (InterruptedException | ExecutionException e3) {
                throw new DockerException(e3);
            }
        }
        return result;
    }

    @Override
    public List<IRepositoryTag> getTags(String repository) throws DockerException {
        ClientConfig DEFAULT_CONFIG = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class});
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        ArrayList<IRepositoryTag> result = new ArrayList<IRepositoryTag>();
        if (this.isVersion2()) {
            WebTarget queryTagsResource = client.target(this.getHTTPServerAddress()).path("v2").path(repository).path("tags").path("list");
            GenericType<RepositoryTagV2> REPOSITORY_TAGS_RESULT_LIST = new GenericType<RepositoryTagV2>(){};
            try {
                RepositoryTagV2 crts = (RepositoryTagV2)queryTagsResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)REPOSITORY_TAGS_RESULT_LIST).get();
                result.addAll(crts.getTags());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new DockerException(e);
            }
        }
        if (this.isDockerHubRegistry()) {
            WebTarget queryTagsResource = client.target(this.getHTTPServerAddress()).path("v1").path("repositories").path(repository).path("tags");
            GenericType<List<RepositoryTag>> REPOSITORY_TAGS_RESULT_LIST = new GenericType<List<RepositoryTag>>(){};
            try {
                result.addAll((Collection)queryTagsResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)REPOSITORY_TAGS_RESULT_LIST).get());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            WebTarget queryTagsResource = client.target(this.getHTTPServerAddress()).path("v1").path("repositories").path(repository).path("tags");
            GenericType<Map<String, String>> REPOSITORY_TAGS_RESULT_LIST = new GenericType<Map<String, String>>(){};
            Map ret = new HashMap();
            try {
                ret = (Map)queryTagsResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)REPOSITORY_TAGS_RESULT_LIST).get();
                for (Map.Entry e : ret.entrySet()) {
                    RepositoryTag tag = new RepositoryTag();
                    tag.setName((String)e.getKey());
                    tag.setLayer((String)e.getValue());
                    result.add(tag);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new DockerException(e);
            }
        }
        return result;
    }

    @Override
    public boolean isVersion2() {
        if (this.isV2 != null) {
            return this.isV2;
        }
        ClientConfig DEFAULT_CONFIG = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class});
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        WebTarget pingApiv2Resource = client.target(this.getHTTPServerAddress()).path("v2");
        try {
            Response response = (Response)pingApiv2Resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get().get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                this.isV2 = true;
                return true;
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        this.isV2 = false;
        return false;
    }
}

