/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;

public class DockerImage
implements IDockerImage,
IAdaptable {
    public static final String LATEST_TAG = "latest";
    private static final String REGISTRY_HOST = "[a-zA-Z0-9]+([\\._-][a-zA-Z0-9]+)*";
    private static final String REGISTRY_PORT = "[0-9]+";
    private static final String REPOSITORY = "[a-z0-9]+([\\._-][a-z0-9]+)*";
    private static final String NAME = "[a-z0-9]+([\\._-][a-z0-9]+)*";
    private static final String TAG = "[a-zA-Z0-9]+([\\._-][a-zA-Z0-9]+)*";
    public static final Pattern imageNamePattern = Pattern.compile("([a-zA-Z0-9]+([\\._-][a-zA-Z0-9]+)*\\:[0-9]+/)?((?<repository>[a-z0-9]+([\\._-][a-z0-9]+)*(/[a-z0-9]+([\\._-][a-z0-9]+)*)?)/)?(?<name>[a-z0-9]+([\\._-][a-z0-9]+)*)(\\:(?<tag>[a-zA-Z0-9]+([\\._-][a-zA-Z0-9]+)*))?");
    private static final ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private final DockerConnection parent;
    private final String created;
    private final String createdDate;
    private final String id;
    private final String shortId;
    private final String parentId;
    private final List<String> repoTags;
    private final String repo;
    private final List<String> tags;
    private final Long size;
    private final Long virtualSize;
    private final boolean intermediateImage;
    private final boolean danglingImage;

    public DockerImage(DockerConnection parent, @Deprecated List<String> repoTags, String repo, List<String> tags, String id, String parentId, String created, Long size, Long virtualSize, boolean intermediateImage, boolean danglingImage) {
        this.parent = parent;
        this.repoTags = repoTags;
        this.repo = repo;
        this.tags = tags;
        this.id = id;
        this.shortId = DockerImage.getShortId(id);
        this.parentId = parentId;
        this.created = created;
        this.createdDate = created != null ? formatter.get().format(new Date(Long.valueOf(created) * 1000L)) : null;
        this.size = size;
        this.virtualSize = virtualSize;
        this.intermediateImage = intermediateImage;
        this.danglingImage = danglingImage;
    }

    private static String getShortId(String id) {
        if (id.startsWith("sha256:")) {
            return DockerImage.getShortId(id.substring("sha256:".length()));
        }
        if (id.length() > 12) {
            return id.substring(0, 12);
        }
        return id;
    }

    public static Map<String, List<String>> extractTagsByRepo(List<String> repoTags) {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        for (String string : repoTags) {
            String repo;
            int indexOfColonChar = string.lastIndexOf(58);
            String string2 = repo = indexOfColonChar > -1 ? string.substring(0, indexOfColonChar) : string;
            if (!results.containsKey(repo)) {
                results.put(repo, new ArrayList());
            }
            if (indexOfColonChar <= -1) continue;
            ((List)results.get(repo)).add(string.substring(indexOfColonChar + 1));
        }
        for (Map.Entry entry : results.entrySet()) {
            Collections.sort((List)entry.getValue());
        }
        return results;
    }

    public static List<String> extractTags(List<String> repoTags) {
        if (repoTags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (String repoTag : repoTags) {
            int indexOfColonChar = repoTag.lastIndexOf(58);
            if (indexOfColonChar == -1) continue;
            String tag = repoTag.substring(indexOfColonChar + 1);
            tags.add(tag);
        }
        return tags;
    }

    public static String extractRepo(String repoTag) {
        if (repoTag == null) {
            return null;
        }
        int indexOfColonChar = repoTag.lastIndexOf(58);
        if (indexOfColonChar == -1) {
            return repoTag;
        }
        return repoTag.substring(0, indexOfColonChar);
    }

    public static String extractTag(String repoTag) {
        if (repoTag == null) {
            return null;
        }
        int indexOfColonChar = repoTag.lastIndexOf(58);
        if (indexOfColonChar == -1) {
            return null;
        }
        return repoTag.substring(indexOfColonChar + 1);
    }

    public static Stream<IDockerImage> duplicateImageByRepo(IDockerImage image) {
        return DockerImage.extractTagsByRepo(image.repoTags()).entrySet().stream().map(entry -> new DockerImage((DockerConnection)image.getConnection(), image.repoTags(), (String)entry.getKey(), (List)entry.getValue(), image.id(), image.parentId(), image.created(), image.size(), image.virtualSize(), image.isIntermediateImage(), image.isDangling()));
    }

    @Override
    public DockerConnection getConnection() {
        return this.parent;
    }

    @Override
    public List<String> repoTags() {
        return this.repoTags;
    }

    @Override
    public String repo() {
        return this.repo;
    }

    @Override
    public List<String> tags() {
        return this.tags;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String shortId() {
        return this.shortId;
    }

    @Override
    public String parentId() {
        return this.parentId;
    }

    @Override
    public String created() {
        return this.created;
    }

    @Override
    public String createdDate() {
        return this.createdDate;
    }

    @Override
    public Long size() {
        return this.size;
    }

    @Override
    public Long virtualSize() {
        return this.virtualSize;
    }

    @Override
    public boolean isDangling() {
        return this.danglingImage;
    }

    @Override
    public boolean isIntermediateImage() {
        return this.intermediateImage;
    }

    public String toString() {
        return "Image: id=" + this.id() + "\n  parentId=" + this.parentId() + "\n  created=" + this.created() + "\n  repo=" + this.repo() + "\n  tags=" + this.tags() + "\n  size=" + this.size() + "\n  virtualSize=" + this.virtualSize();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerImage other = (DockerImage)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.repo == null ? other.repo != null : !this.repo.equals(other.repo));
    }

    public static String setDefaultTagIfMissing(String imageName) {
        if (DockerImage.extractTag(imageName) == null) {
            return String.valueOf(imageName) + ':' + LATEST_TAG;
        }
        return imageName;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IDockerConnection.class)) {
            return (T)this.parent;
        }
        return null;
    }
}

