/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.internal.docker.core.ProcessUtils;
import org.eclipse.linuxtools.internal.docker.core.SystemUtils;

public class DockerMachine {
    public static boolean checkPathToDockerMachine(String dockerMachineInstallDir) {
        return ProcessUtils.checkPathToCommand(dockerMachineInstallDir, DockerMachine.getDockerMachineExecutableName());
    }

    public static String[] getNames(String pathToDockerMachine) throws DockerException {
        return ProcessUtils.processBuilder(pathToDockerMachine, DockerMachine.getDockerMachineExecutableName(), "ls", "-q").start();
    }

    public static String getHost(String name, String dockerMachineInstallDir, String vmDriverInstallDir) throws DockerException {
        String[] res = ProcessUtils.processBuilder(dockerMachineInstallDir, DockerMachine.getDockerMachineExecutableName(), "url", name).extraPath(vmDriverInstallDir).start();
        return res.length == 1 ? res[0] : null;
    }

    public static String getCertPath(String name, String pathToDockerMachine, String vmDriverInstallDir) throws DockerException {
        String[] envVariables;
        String[] stringArray = envVariables = ProcessUtils.processBuilder(pathToDockerMachine, DockerMachine.getDockerMachineExecutableName(), "env", name).extraPath(vmDriverInstallDir).start();
        int n = envVariables.length;
        int n2 = 0;
        while (n2 < n) {
            String envVariable = stringArray[n2];
            if (envVariable.contains("DOCKER_CERT_PATH")) {
                return envVariable.split("=")[1].replace("\"", "");
            }
            ++n2;
        }
        return null;
    }

    private static String getDockerMachineExecutableName() {
        if (SystemUtils.isWindows()) {
            return "docker-machine.exe";
        }
        return "docker-machine";
    }
}

