/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.internal.docker.core.ProcessMessages;

public class ProcessLauncher {
    public static final String COMMAND_LINE = "org.eclipse.linuxtools.docker.compose.commandLine";

    public boolean checkPathToCommand(String path, String cmdName) {
        return Stream.of(path.split(File.pathSeparator)).map(pathFragment -> new File((String)pathFragment, cmdName)).anyMatch(fullPath -> fullPath.exists());
    }

    public FluentProcessBuilder processBuilder(String baseCmdDir, String cmdName, String[] args) throws DockerException {
        return new FluentProcessBuilder(baseCmdDir, cmdName, args);
    }

    public static class FluentProcessBuilder {
        private final ProcessBuilder processBuilder;

        private FluentProcessBuilder(String baseCmdDir, String cmdName, String[] args) throws DockerException {
            boolean commandExists = new ProcessLauncher().checkPathToCommand(baseCmdDir, cmdName);
            if (!commandExists) {
                throw new DockerException(ProcessMessages.getFormattedString("Command_Not_Found", baseCmdDir, cmdName));
            }
            String[] command = new String[args.length + 1];
            command[0] = Paths.get(baseCmdDir, cmdName).toString();
            System.arraycopy(args, 0, command, 1, args.length);
            this.processBuilder = new ProcessBuilder(command);
        }

        public FluentProcessBuilder extraPath(String ... extraPaths) {
            Map<String, String> environment = this.processBuilder.environment();
            StringBuilder path = new StringBuilder();
            String[] stringArray = extraPaths;
            int n = extraPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String extraPath = stringArray[n2];
                path.append(File.pathSeparator).append(extraPath);
                ++n2;
            }
            String newEnvPath = String.valueOf(environment.get("PATH")) + path.toString();
            environment.put("PATH", newEnvPath);
            return this;
        }

        public FluentProcessBuilder workingDir(String workingDir) {
            this.processBuilder.directory(new File(workingDir));
            return this;
        }

        public FluentProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
            this.processBuilder.redirectErrorStream(redirectErrorStream);
            return this;
        }

        public String getCommand() {
            return this.processBuilder.command().stream().collect(Collectors.joining(" "));
        }

        public Process start() throws DockerException {
            try {
                return this.processBuilder.start();
            }
            catch (IOException e) {
                throw new DockerException(ProcessMessages.getFormattedString("Process_Start_Exception", this.processBuilder.command().stream().collect(Collectors.joining(" ")), e.getMessage()), e);
            }
        }
    }
}

