/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.BaseConnectionSettings;

public class TCPConnectionSettings
extends BaseConnectionSettings {
    private final String host;
    private final String pathToCertificates;

    public TCPConnectionSettings(String host, String pathToCertificates) {
        this.host = new HostBuilder(host).enableTLS(pathToCertificates);
        this.pathToCertificates = pathToCertificates;
    }

    @Override
    public IDockerConnectionSettings.BindingType getType() {
        return IDockerConnectionSettings.BindingType.TCP_CONNECTION;
    }

    @Override
    public Object[] getProperties() {
        return new Object[]{new Object[]{"Type", this.getType().toString()}, new Object[]{"Host", this.getHost()}, new Object[]{"Certificates", this.getPathToCertificates()}};
    }

    public String getHost() {
        return this.host;
    }

    public boolean hasHost() {
        return this.host != null && !this.host.isEmpty();
    }

    public boolean isTlsVerify() {
        return this.pathToCertificates != null;
    }

    public String getPathToCertificates() {
        return this.pathToCertificates;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.pathToCertificates == null ? 0 : this.pathToCertificates.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCPConnectionSettings other = (TCPConnectionSettings)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return !(this.pathToCertificates == null ? other.pathToCertificates != null : !this.pathToCertificates.equals(other.pathToCertificates));
    }

    private static class HostBuilder {
        private static String HTTP_SCHEME = "http://";
        private static String TCP_SCHEME = "tcp://";
        private static String HTTPS_SCHEME = "https://";
        private final String host;

        public HostBuilder(String host) {
            this.host = host == null || host.isEmpty() ? "" : (!host.matches("\\w+://.*") ? String.valueOf(HTTP_SCHEME) + host : host.replace(TCP_SCHEME, HTTP_SCHEME));
        }

        public String enableTLS(String pathToCertificates) {
            if (pathToCertificates == null || pathToCertificates.isEmpty()) {
                return this.host;
            }
            return this.host.replace(HTTP_SCHEME, HTTPS_SCHEME);
        }
    }
}

