/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.ui.launch;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerExit;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.ui.launch.IContainerLaunchListener;
import org.eclipse.linuxtools.docker.ui.launch.Messages;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerPortBinding;
import org.eclipse.linuxtools.internal.docker.ui.consoles.ConsoleOutputStream;
import org.eclipse.linuxtools.internal.docker.ui.consoles.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ContainerLauncher {
    private static final String ERROR_CREATING_CONTAINER = "ContainerCreateError.msg";
    private static final String ERROR_LAUNCHING_CONTAINER = "ContainerLaunchError.msg";
    private static final String ERROR_NO_CONNECTIONS = "ContainerNoConnections.msg";
    private static final String ERROR_NO_CONNECTION_WITH_URI = "ContainerNoConnectionWithURI.msg";
    private static RunConsole console;

    public void launch(String id, IContainerLaunchListener listener, String connectionUri, String image, String command, String commandDir, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Map<String, String> envMap, List<String> ports, boolean keep, boolean stdinSupport) {
        this.launch(id, listener, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, ports, keep, stdinSupport, false);
    }

    public void launch(String id, IContainerLaunchListener listener, String connectionUri, String image, String command, String commandDir, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Map<String, String> envMap, List<String> ports, boolean keep, boolean stdinSupport, boolean privilegedMode) {
        this.launch(id, listener, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, ports, keep, stdinSupport, privilegedMode, null);
    }

    public void launch(String id, IContainerLaunchListener listener, String connectionUri, String image, String command, String commandDir, String workingDir, List<String> additionalDirs, Map<String, String> origEnv, Map<String, String> envMap, List<String> ports, boolean keep, boolean stdinSupport, boolean privilegedMode, Map<String, String> labels) {
        String LAUNCH_TITLE = "ContainerLaunch.title";
        String LAUNCH_EXITED_TITLE = "ContainerLaunchExited.title";
        ArrayList<String> env = new ArrayList<String>();
        env.addAll(this.toList(origEnv));
        env.addAll(this.toList(envMap));
        ArrayList<String> volumes = new ArrayList<String>();
        if (additionalDirs != null) {
            for (String dir : additionalDirs) {
                volumes.add(String.valueOf(dir) + ":" + dir + ":Z");
            }
        }
        if (workingDir != null) {
            volumes.add(String.valueOf(workingDir) + ":" + workingDir + ":Z");
        }
        if (commandDir != null) {
            volumes.add(String.valueOf(commandDir) + ":" + commandDir + ":Z");
        }
        List<String> cmdList = this.getCmdList(command);
        HashSet<String> exposedPorts = new HashSet<String>();
        HashMap<String, List<IDockerPortBinding>> portBindingsMap = new HashMap<String, List<IDockerPortBinding>>();
        if (ports != null) {
            for (String port : ports) {
                if ((port = port.trim()).length() <= 0) continue;
                String[] segments = port.split(":");
                if (segments.length == 1) {
                    exposedPorts.add(segments[0]);
                    portBindingsMap.put(segments[0], Arrays.asList(new DockerPortBinding("", "")));
                    continue;
                }
                if (segments.length == 2) {
                    exposedPorts.add(segments[1]);
                    portBindingsMap.put(segments[1], Arrays.asList(new DockerPortBinding("", segments[0])));
                    continue;
                }
                if (segments.length != 3) continue;
                exposedPorts.add(segments[1]);
                if (segments[1].isEmpty()) {
                    portBindingsMap.put(segments[2], Arrays.asList(new DockerPortBinding("", segments[0])));
                    continue;
                }
                portBindingsMap.put(segments[2], Arrays.asList(new DockerPortBinding(segments[0], segments[1])));
            }
        }
        DockerContainerConfig.Builder builder = new DockerContainerConfig.Builder().openStdin(Boolean.valueOf(stdinSupport)).env(env).cmd(cmdList).image(image).workingDir(workingDir);
        if (exposedPorts.size() > 0) {
            builder = builder.exposedPorts(exposedPorts);
        }
        if (labels != null) {
            builder = builder.labels(labels);
        }
        DockerContainerConfig config = builder.build();
        DockerHostConfig.Builder hostBuilder = new DockerHostConfig.Builder().binds(volumes).privileged(Boolean.valueOf(privilegedMode));
        if (portBindingsMap.size() > 0) {
            hostBuilder = hostBuilder.portBindings(portBindingsMap);
        }
        IDockerHostConfig hostConfig = hostBuilder.build();
        if (!DockerConnectionManager.getInstance().hasConnections()) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)DVMessages.getString(ERROR_NO_CONNECTIONS)));
            return;
        }
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionUri);
        if (connection == null) {
            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getString(ERROR_LAUNCHING_CONTAINER), (String)DVMessages.getFormattedString(ERROR_NO_CONNECTION_WITH_URI, connectionUri)));
            return;
        }
        String imageName = image;
        boolean keepContainer = keep;
        String consoleId = id;
        IContainerLaunchListener containerListener = listener;
        Thread t = new Thread(() -> {
            String containerId = null;
            try {
                containerId = ((DockerConnection)connection).createContainer((IDockerContainerConfig)config, hostConfig, null);
                OutputStream stream = null;
                RunConsole oldConsole = this.getConsole();
                RunConsole rc = RunConsole.findConsole(containerId, consoleId);
                this.setConsole(rc);
                rc.clearConsole();
                if (oldConsole != null) {
                    RunConsole.removeConsole(oldConsole);
                }
                Display.getDefault().syncExec(() -> rc.setTitle(Messages.getFormattedString("ContainerLaunch.title", new String[]{(String)cmdList.get(0), imageName})));
                rc.attachToConsole(connection, containerId);
                if (rc != null) {
                    stream = rc.getOutputStream();
                    if (containerListener != null) {
                        ((ConsoleOutputStream)stream).addConsoleListener(containerListener);
                    }
                }
                String loggingId = String.valueOf(containerId) + "." + consoleId;
                ((DockerConnection)connection).startContainer(containerId, loggingId, stream);
                if (rc != null) {
                    rc.showConsole();
                }
                if (containerListener != null) {
                    IDockerContainerInfo info = ((DockerConnection)connection).getContainerInfo(containerId);
                    containerListener.containerInfo(info);
                }
                IDockerContainerExit status = ((DockerConnection)connection).waitForContainer(containerId);
                Display.getDefault().syncExec(() -> {
                    rc.setTitle(Messages.getFormattedString("ContainerLaunchExited.title", new String[]{status.statusCode().toString(), (String)cmdList.get(0), imageName}));
                    rc.showConsole();
                });
                if (containerListener != null) {
                    containerListener.done();
                }
                if (!keepContainer) {
                    ((DockerConnection)connection).stopLoggingThread(loggingId);
                    while (((DockerConnection)connection).loggingStatus(loggingId) == EnumDockerLoggingStatus.LOGGING_ACTIVE) {
                        Thread.sleep(1000L);
                    }
                    RunConsole rc2 = RunConsole.findConsole(((DockerConnection)connection).getContainer(containerId));
                    if (rc2 != null) {
                        RunConsole.removeConsole(rc2);
                    }
                    ((DockerConnection)connection).removeContainer(containerId);
                }
            }
            catch (DockerException e2) {
                if (!keepContainer && containerId != null) {
                    try {
                        ((DockerConnection)connection).removeContainer(containerId);
                    }
                    catch (InterruptedException | DockerException throwable) {
                        // empty catch block
                    }
                }
                Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(ERROR_CREATING_CONTAINER, imageName), (String)e2.getMessage()));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ((DockerConnection)connection).getContainers(true);
        });
        t.start();
    }

    public void cleanup(String connectionUri, IDockerContainerInfo info) {
        if (!DockerConnectionManager.getInstance().hasConnections()) {
            return;
        }
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByUri(connectionUri);
        if (connection == null) {
            return;
        }
        try {
            connection.killContainer(info.id());
        }
        catch (InterruptedException | DockerException throwable) {
            // empty catch block
        }
    }

    private RunConsole getConsole() {
        return console;
    }

    private void setConsole(RunConsole cons) {
        console = cons;
    }

    private List<String> getCmdList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        int length = s.length();
        boolean insideQuote1 = false;
        boolean insideQuote2 = false;
        boolean escaped = false;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (escaped) {
                buffer.append(c);
                escaped = false;
            }
            switch (c) {
                case '\'': {
                    if (!insideQuote2) {
                        insideQuote1 ^= true;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case '\"': {
                    if (!insideQuote1) {
                        insideQuote2 ^= true;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case '\\': {
                    escaped = true;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (insideQuote1 || insideQuote2) {
                        buffer.append(c);
                        break;
                    }
                    String item = buffer.toString();
                    buffer.setLength(0);
                    if (item.length() <= 0) break;
                    list.add(item);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        String item = buffer.toString();
        if (item.length() > 0) {
            list.add(item);
        }
        return list;
    }

    private List<String> toList(Map<String, String> variables) {
        ArrayList<String> result = new ArrayList<String>();
        if (variables != null) {
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String envEntry = String.valueOf(key) + "=" + value;
                result.add(envEntry);
            }
        }
        return result;
    }
}

