/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.jobs.BuildDockerImageJob;
import org.eclipse.linuxtools.internal.docker.ui.launch.BuildDockerImageUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BuildDockerImageLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private static final String MISSING_CONNECTION_ERROR_MSG = "ImageBuildShortcutMissingConnection.msg";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String sourcePathLocation = configuration.getAttribute("sourcePathLocation", null);
        boolean sourcePathWorkspaceRelativeLocation = configuration.getAttribute("sourcePathWorkspaceRelativeLocation", false);
        IPath sourcePath = BuildDockerImageUtils.getPath(sourcePathLocation, sourcePathWorkspaceRelativeLocation);
        String connectionName = configuration.getAttribute("dockerConnection", null);
        String repoName = configuration.getAttribute("repoName", null);
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByName(connectionName);
        HashMap<String, Object> buildOptions = new HashMap<String, Object>();
        buildOptions.put("quietBuild", configuration.getAttribute("quietBuild", false));
        buildOptions.put("noCache", configuration.getAttribute("noCache", false));
        buildOptions.put("rm", configuration.getAttribute("rm", true));
        buildOptions.put("forcerm", configuration.getAttribute("forcerm", false));
        try {
            if (connection != null && sourcePath != null) {
                BuildDockerImageJob buildImageJob = new BuildDockerImageJob(connection, sourcePath, repoName, buildOptions);
                buildImageJob.schedule();
            } else {
                ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)"run");
                Display.getDefault().syncExec(() -> {
                    int n = DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)launchGroup.getIdentifier(), null);
                });
            }
        }
        catch (DockerException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.ui", e.getMessage(), (Throwable)e));
        }
    }
}

