/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DockerImageHierarchyView
extends CommonNavigator
implements ITabbedPropertySheetPageContributor {
    public static final String VIEW_ID = "org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView";
    private Control hierarchyPane;
    private Control explanationsPane;
    private PageBook pageBook;
    private IDockerImageHierarchyNode selectedImageHierarchy = null;
    private Control currentPane;
    private IDockerConnection connection;

    protected Object getInitialInput() {
        return this.selectedImageHierarchy;
    }

    public void show(IDockerImageHierarchyNode selectedImageHierarchy) {
        this.selectedImageHierarchy = selectedImageHierarchy;
        this.getCommonViewer().setInput((Object)new DockerImageHiearchy(this.selectedImageHierarchy.getRoot()));
        this.getCommonViewer().expandAll();
        this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)selectedImageHierarchy));
        this.showHierarchyOrExplanations();
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.pageBook = new PageBook(parent, 0);
        this.hierarchyPane = this.createHierarchyPane(this.pageBook, toolkit);
        this.explanationsPane = this.createExplanationPane(this.pageBook, toolkit);
        this.showHierarchyOrExplanations();
    }

    private Control createExplanationPane(PageBook pageBook, FormToolkit toolkit) {
        Form form = toolkit.createForm((Composite)pageBook);
        Composite container = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        Label label = new Label(container, 64);
        label.setText(DVMessages.getString("DockerHierarchyViewNoImageSelected.msg"));
        GridDataFactory.fillDefaults().align(16384, 4).grab(true, false).applyTo((Control)label);
        return form;
    }

    private Control createHierarchyPane(PageBook pageBook, FormToolkit toolkit) {
        Form form = toolkit.createForm((Composite)pageBook);
        Composite container = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        super.createPartControl(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.getCommonViewer().getControl());
        return form;
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        CommonViewer viewer = super.createCommonViewer(parent);
        this.setLinkingEnabled(false);
        return viewer;
    }

    public String getContributorId() {
        return "org.eclipse.linuxtools.docker.ui.propertiesViewContributor";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IPropertySheetPage.class.isAssignableFrom(adapter)) {
            return (T)new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        }
        return (T)super.getAdapter(adapter);
    }

    public void dispose() {
    }

    public void showHierarchyOrExplanations() {
        if (this.selectedImageHierarchy == null) {
            this.currentPane = this.explanationsPane;
            this.pageBook.showPage(this.explanationsPane);
        } else {
            this.currentPane = this.hierarchyPane;
            this.pageBook.showPage(this.hierarchyPane);
        }
    }

    public boolean isShowingConnectionsPane() {
        return this.currentPane == this.hierarchyPane;
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IDockerConnection connection) {
        this.connection = connection;
    }

    static class DockerImageHiearchy {
        private final IDockerImageHierarchyNode root;

        public DockerImageHiearchy(IDockerImageHierarchyNode root) {
            this.root = root;
        }

        public IDockerImageHierarchyNode getRoot() {
            return this.root;
        }
    }
}

