/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.docker.ui.wizards.ImageSearch;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageNameValidator;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePullPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePullPushPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePullPushPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImagePullPage
extends ImagePullPushPage<ImagePullPageModel> {
    private final IDockerConnection connection;

    public ImagePullPage(IDockerConnection connection) {
        super("ImagePullPage", WizardMessages.getString("ImagePull.label"), new ImagePullPageModel());
        this.setMessage(WizardMessages.getString("ImagePull.desc"));
        this.connection = connection;
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public String getSelectedImageName() {
        return ((ImagePullPageModel)this.getModel()).getSelectedImageName();
    }

    public IRegistry getSelectedRegistryAccount() {
        return ((ImagePullPageModel)this.getModel()).getSelectedRegistry();
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)container);
        super.createRegistrySelectionControls(container);
        this.createImageNameSelectionControls(container);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        this.setControl((Control)container);
    }

    void createImageNameSelectionControls(Composite parent) {
        Label imageNameLabel = new Label(parent, 0);
        imageNameLabel.setText(WizardMessages.getString("ImagePullPushPage.name.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageNameLabel);
        Text imageNameText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)imageNameText);
        imageNameText.setToolTipText(WizardMessages.getString("ImagePull.name.tooltip"));
        Button searchButton = new Button(parent, 0);
        searchButton.setText(WizardMessages.getString("ImagePull.search.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)searchButton);
        searchButton.addSelectionListener(this.onSearchImage());
        IObservableValue imgeNameObservable = BeanProperties.value(ImagePullPushPageModel.class, (String)"selectedImageName").observe(this.getModel());
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)imageNameText), imgeNameObservable, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new ImageNameValidator()), null);
    }

    private SelectionListener onSearchImage() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSearch imageSearchWizard = new ImageSearch(ImagePullPage.this.connection, ((ImagePullPageModel)ImagePullPage.this.getModel()).getSelectedImageName(), ((ImagePullPageModel)ImagePullPage.this.getModel()).getSelectedRegistry());
                boolean completed = CommandUtils.openWizard((IWizard)imageSearchWizard, ImagePullPage.this.getShell());
                if (completed) {
                    ((ImagePullPageModel)ImagePullPage.this.getModel()).setSelectedImageName(imageSearchWizard.getSelectedImage());
                }
            }
        };
    }
}

