/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerMachine;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.NewDockerConnectionPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewDockerConnectionPage
extends WizardPage {
    private static final String DOCKER_MACHINE_PREFERENCE_PAGE_ID = "org.eclipse.linuxtools.docker.ui.preferences.DockerMachinePreferencePage";
    private final DataBindingContext dbc;
    private final NewDockerConnectionPageModel model;

    public NewDockerConnectionPage() {
        super("DockerConnectionPage", WizardMessages.getString("DockerConnectionPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("DockerConnectionPage.msg"));
        this.model = new NewDockerConnectionPageModel();
        this.dbc = new DataBindingContext();
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollTop = new ScrolledComposite(parent, 768);
        scrollTop.setExpandVertical(true);
        scrollTop.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrollTop, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        this.createConnectionSettingsContainer(container);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        Clipboard clip = new Clipboard(Display.getCurrent());
        String content = (String)clip.getContents((Transfer)TextTransfer.getInstance(), 2);
        if (content != null && content.contains("DOCKER_HOST")) {
            this.retrieveConnectionSettings(content);
        } else {
            content = (String)clip.getContents((Transfer)TextTransfer.getInstance(), 1);
            if (content != null && content.contains("DOCKER_HOST")) {
                this.retrieveConnectionSettings(content);
            } else {
                this.retrieveDefaultConnectionSettings();
            }
        }
        scrollTop.setContent((Control)container);
        Point point = container.computeSize(-1, -1);
        scrollTop.setSize(point);
        scrollTop.setMinSize(point);
        this.setControl((Control)container);
    }

    public void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.dispose();
    }

    private void createConnectionSettingsContainer(Composite parent) {
        int COLUMNS = 3;
        int INDENT = 20;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).spacing(10, 2).applyTo(container);
        Label connectionNameLabel = new Label(container, 0);
        connectionNameLabel.setText(WizardMessages.getString("DockerConnectionPage.nameLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)connectionNameLabel);
        Text connectionNameText = new Text(container, 2048);
        connectionNameText.setToolTipText(WizardMessages.getString("DockerConnectionPage.nameTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)connectionNameText);
        Button searchButton = new Button(container, 0);
        searchButton.setText(WizardMessages.getString("DockerConnectionPage.searchButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).align(1, 0x1000000).grab(false, false).applyTo((Control)searchButton);
        searchButton.addSelectionListener(this.onSearchButtonSelection());
        Button customConnectionSettingsButton = new Button(container, 32);
        customConnectionSettingsButton.setText(WizardMessages.getString("DockerConnectionPage.customLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(0, 10).span(3, 1).applyTo((Control)customConnectionSettingsButton);
        Group customSettingsGroup = new Group(container, 2048);
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).grab(true, false).applyTo((Control)customSettingsGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).spacing(10, 2).applyTo((Composite)customSettingsGroup);
        Button unixSocketBindingModeButton = new Button((Composite)customSettingsGroup, 16);
        unixSocketBindingModeButton.setText(WizardMessages.getString("DockerConnectionPage.unixSocket"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)unixSocketBindingModeButton);
        Label unixSocketPathLabel = new Label((Composite)customSettingsGroup, 0);
        unixSocketPathLabel.setText(WizardMessages.getString("DockerConnectionPage.location"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).applyTo((Control)unixSocketPathLabel);
        Text unixSocketPathText = new Text((Composite)customSettingsGroup, 2048);
        unixSocketPathText.setToolTipText(WizardMessages.getString("DockerConnectionPage.unixPathTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)unixSocketPathText);
        Button unixSocketPathBrowseButton = new Button((Composite)customSettingsGroup, 524288);
        unixSocketPathBrowseButton.setText(WizardMessages.getString("DockerConnectionPage.browseButton"));
        unixSocketPathBrowseButton.addSelectionListener(this.onBrowseUnixSocketPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)unixSocketPathBrowseButton);
        Button tcpConnectionBindingModeButton = new Button((Composite)customSettingsGroup, 16);
        tcpConnectionBindingModeButton.setText(WizardMessages.getString("DockerConnectionPage.tcpConnection"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)tcpConnectionBindingModeButton);
        Label tcpHostLabel = new Label((Composite)customSettingsGroup, 0);
        tcpHostLabel.setText(WizardMessages.getString("DockerConnectionPage.hostLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).applyTo((Control)tcpHostLabel);
        Text tcpHostText = new Text((Composite)customSettingsGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)tcpHostText);
        Button tcpAuthButton = new Button((Composite)customSettingsGroup, 32);
        tcpAuthButton.setText(WizardMessages.getString("DockerConnectionPage.tcpAuthButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).span(3, 1).applyTo((Control)tcpAuthButton);
        Label tcpCertPathLabel = new Label((Composite)customSettingsGroup, 0);
        tcpCertPathLabel.setText(WizardMessages.getString("DockerConnectionPage.tcpPathLabel"));
        tcpCertPathLabel.setToolTipText(WizardMessages.getString("DockerConnectionPage.tcpPathTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, 0).applyTo((Control)tcpCertPathLabel);
        Text tcpCertPathText = new Text((Composite)customSettingsGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)tcpCertPathText);
        Button tcpCertPathBrowseButton = new Button((Composite)customSettingsGroup, 524288);
        tcpCertPathBrowseButton.setText(WizardMessages.getString("DockerConnectionPage.browseButton"));
        tcpCertPathBrowseButton.addSelectionListener(this.onBrowseTcpCertPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)tcpCertPathBrowseButton);
        Button testConnectionButton = new Button(container, 0);
        testConnectionButton.setText(WizardMessages.getString("DockerConnectionPage.testConnection"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).align(0x1000008, 0x1000000).applyTo((Control)testConnectionButton);
        testConnectionButton.addSelectionListener(this.onTestConnectionButtonSelection());
        IObservableValue connectionNameModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"connectionName").observe((Object)this.model);
        IObservableValue unixSocketBindingModeModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"unixSocketBindingMode").observe((Object)this.model);
        IObservableValue unixSocketPathModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"unixSocketPath").observe((Object)this.model);
        IObservableValue customConnectionSettingsModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"customSettings").observe((Object)this.model);
        IObservableValue tcpConnectionBindingModeModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"tcpConnectionBindingMode").observe((Object)this.model);
        IObservableValue tcpCertPathModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"tcpCertPath").observe((Object)this.model);
        IObservableValue tcpTlsVerifyModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"tcpTLSVerify").observe((Object)this.model);
        IObservableValue tcpHostModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"tcpHost").observe((Object)this.model);
        Control[] bindingModeSelectionControls = new Control[]{unixSocketBindingModeButton, tcpConnectionBindingModeButton};
        Control[] unixSocketControls = new Control[]{unixSocketPathText, unixSocketPathLabel, unixSocketPathBrowseButton};
        Control[] tcpConnectionControls = new Control[]{tcpHostText, tcpHostLabel, tcpAuthButton};
        Control[] tcpAuthControls = new Control[]{tcpCertPathText, tcpCertPathLabel, tcpCertPathBrowseButton};
        customConnectionSettingsModelObservable.addValueChangeListener(this.onCustomConnectionSettingsSelection(bindingModeSelectionControls, unixSocketControls, tcpAuthControls, tcpConnectionControls));
        unixSocketBindingModeModelObservable.addChangeListener(this.onUnixSocketBindingSelection(unixSocketControls));
        tcpConnectionBindingModeModelObservable.addChangeListener(this.onTcpConnectionBindingSelection(tcpConnectionControls, tcpAuthControls));
        tcpTlsVerifyModelObservable.addValueChangeListener(this.onTcpAuthSelection(tcpAuthControls));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)connectionNameText), connectionNameModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)customConnectionSettingsButton), customConnectionSettingsModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)unixSocketBindingModeButton), unixSocketBindingModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)unixSocketPathText), unixSocketPathModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)tcpConnectionBindingModeButton), tcpConnectionBindingModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)tcpHostText), tcpHostModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)tcpAuthButton), tcpTlsVerifyModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)tcpCertPathText), tcpCertPathModelObservable);
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new UnixSocketValidator((IObservableValue<String>)connectionNameModelObservable, (IObservableValue<Boolean>)unixSocketBindingModeModelObservable, (IObservableValue<String>)unixSocketPathModelObservable));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new TcpHostValidator((IObservableValue<String>)connectionNameModelObservable, (IObservableValue<Boolean>)tcpConnectionBindingModeModelObservable, (IObservableValue<String>)tcpHostModelObservable));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new TcpCertificatesValidator((IObservableValue<Boolean>)tcpConnectionBindingModeModelObservable, (IObservableValue<Boolean>)tcpTlsVerifyModelObservable, (IObservableValue<String>)tcpCertPathModelObservable));
        connectionNameText.setFocus();
        this.updateWidgetsState(bindingModeSelectionControls, unixSocketControls, tcpConnectionControls, tcpAuthControls);
    }

    private SelectionListener onBrowseUnixSocketPath() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(NewDockerConnectionPage.this.getShell());
                String selectedPath = fileDialog.open();
                if (selectedPath != null) {
                    NewDockerConnectionPage.this.model.setUnixSocketPath("unix://" + selectedPath);
                }
            }
        };
    }

    private SelectionListener onBrowseTcpCertPath() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(NewDockerConnectionPage.this.getShell());
                directoryDialog.setFilterPath(NewDockerConnectionPage.this.model.getTcpCertPath());
                String selectedPath = directoryDialog.open();
                if (selectedPath != null) {
                    NewDockerConnectionPage.this.model.setTcpCertPath(selectedPath);
                }
            }
        };
    }

    private void retrieveDefaultConnectionSettings() {
        try {
            this.getWizard().getContainer().run(true, true, monitor -> {
                monitor.beginTask(WizardMessages.getString("DockerConnectionPage.retrieveTask"), 1);
                DockerConnectionManager dockerConnectionManager = DockerConnectionManager.getInstance();
                IDockerConnectionSettings defaultConnectionSettings = dockerConnectionManager.findDefaultConnectionSettings();
                if (defaultConnectionSettings != null) {
                    this.model.setCustomSettings(!defaultConnectionSettings.isSettingsResolved());
                    this.model.setConnectionName(dockerConnectionManager.resolveConnectionName(defaultConnectionSettings));
                    switch (defaultConnectionSettings.getType()) {
                        case TCP_CONNECTION: {
                            TCPConnectionSettings tcpConnectionSettings = (TCPConnectionSettings)defaultConnectionSettings;
                            this.model.setTcpConnectionBindingMode(true);
                            this.model.setTcpCertPath(tcpConnectionSettings.getPathToCertificates());
                            this.model.setTcpTLSVerify(tcpConnectionSettings.isTlsVerify());
                            this.model.setTcpHost(tcpConnectionSettings.getHost());
                            break;
                        }
                        case UNIX_SOCKET_CONNECTION: {
                            this.model.setUnixSocketBindingMode(true);
                            UnixSocketConnectionSettings unixSocketConnectionSettings = (UnixSocketConnectionSettings)defaultConnectionSettings;
                            this.model.setUnixSocketPath(unixSocketConnectionSettings.getPath());
                        }
                    }
                } else {
                    this.model.setCustomSettings(true);
                    this.model.setUnixSocketBindingMode(true);
                }
                monitor.done();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    private void retrieveConnectionSettings(String content) {
        String EQUAL = "=";
        StringTokenizer tok = new StringTokenizer(content);
        while (tok.hasMoreTokens()) {
            String[] tokens;
            String line = tok.nextToken();
            if (line.startsWith("DOCKER_HOST")) {
                tokens = line.split("=");
                if (tokens.length != 2) continue;
                String host = tokens[1];
                if (host.startsWith("unix")) {
                    this.model.setUnixSocketBindingMode(true);
                    this.model.setUnixSocketPath(host);
                } else {
                    this.model.setTcpConnectionBindingMode(true);
                    this.model.setTcpHost(host);
                }
                this.model.setCustomSettings(true);
                continue;
            }
            if (line.startsWith("DOCKER_CERT_PATH")) {
                tokens = line.split("=");
                if (tokens.length != 2) continue;
                this.model.setTcpCertPath(tokens[1]);
                continue;
            }
            if (!line.startsWith("DOCKER_TLS_VERIFY") || (tokens = line.split("=")).length != 2) continue;
            this.model.setTcpTLSVerify("1".equals(tokens[1]));
        }
    }

    private void updateWidgetsState(Control[] bindingModeSelectionControls, Control[] unixSocketControls, Control[] tcpConnectionControls, Control[] tcpAuthControls) {
        this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isTcpConnectionBindingMode() && this.model.isTcpTLSVerify(), tcpAuthControls);
        this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isTcpConnectionBindingMode(), tcpConnectionControls);
        this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isUnixSocketBindingMode(), unixSocketControls);
        this.setWidgetsEnabled(this.model.isCustomSettings(), bindingModeSelectionControls);
    }

    private IValueChangeListener onCustomConnectionSettingsSelection(Control[] bindingModeSelectionControls, Control[] unixSocketControls, Control[] tcpAuthControls, Control[] tcpConnectionControls) {
        return event -> this.updateWidgetsState(bindingModeSelectionControls, unixSocketControls, tcpConnectionControls, tcpAuthControls);
    }

    private IChangeListener onUnixSocketBindingSelection(Control[] unixSocketControls) {
        return event -> this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isUnixSocketBindingMode(), unixSocketControls);
    }

    private IChangeListener onTcpConnectionBindingSelection(Control[] tcpConnectionControls, Control[] tcpAuthControls) {
        return event -> {
            this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isTcpConnectionBindingMode() && this.model.isTcpTLSVerify(), tcpAuthControls);
            this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isTcpConnectionBindingMode(), tcpConnectionControls);
        };
    }

    private IValueChangeListener onTcpAuthSelection(Control[] tcpAuthControls) {
        return event -> this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isTcpConnectionBindingMode() && this.model.isTcpTLSVerify(), tcpAuthControls);
    }

    private void setWidgetsEnabled(boolean enabled, Control ... controls) {
        Control control;
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
        if (enabled) {
            controlArray = controls;
            n = controls.length;
            n2 = 0;
            while (n2 < n) {
                control = controlArray[n2];
                if (control instanceof Text) {
                    control.setFocus();
                    break;
                }
                ++n2;
            }
        }
    }

    private SelectionListener onTestConnectionButtonSelection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewDockerConnectionPage.this.getWizard().getContainer().run(true, false, monitor -> {
                        monitor.beginTask(WizardMessages.getString("DockerConnectionPage.pingTask"), -1);
                        try {
                            DockerConnection dockerConnection = NewDockerConnectionPage.this.getDockerConnection();
                            dockerConnection.open(false);
                            dockerConnection.ping();
                            dockerConnection.close();
                            this.displaySuccessDialog();
                        }
                        catch (DockerException e1) {
                            if (e1.getCause() != null) {
                                Activator.log(e1);
                            }
                            this.displayErrorDialog();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException o_O) {
                    Activator.log(o_O);
                }
            }

            private void displaySuccessDialog() {
                this.displayDialog(WizardMessages.getString("DockerConnectionPage.success"), WizardMessages.getString("DockerConnectionPage.pingSuccess"), 2, new String[]{WizardMessages.getString("DockerConnectionPage.ok")});
            }

            private void displayErrorDialog() {
                this.displayDialog(WizardMessages.getString("DockerConnectionPage.failure"), WizardMessages.getString("DockerConnectionPage.pingFailure"), 1, new String[]{WizardMessages.getString("DockerConnectionPage.ok")});
            }

            private void displayDialog(String dialogTitle, String dialogMessage, int icon, String[] buttonLabels) {
                Display.getDefault().syncExec(() -> {
                    int n2 = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dialogTitle, null, dialogMessage, icon, buttonLabels, 0).open();
                });
            }
        };
    }

    private SelectionListener onSearchButtonSelection() {
        return new SelectionAdapter(){

            private String getVMDriverInstallDir() {
                return Activator.getDefault().getPreferenceStore().getString("vmDriverInstallDir");
            }

            private String getDockerMachineInstallDir() {
                return Activator.getDefault().getPreferenceStore().getString("dockerMachineInstallDir");
            }

            public void widgetSelected(SelectionEvent e) {
                block16: {
                    String vmDriverInstallDir;
                    String dockerMachineInstallDir;
                    Map<String, Boolean> allMachineStates;
                    List<String> activeMachineNames;
                    if (!DockerMachine.checkPathToDockerMachine((String)this.getDockerMachineInstallDir()) || this.getVMDriverInstallDir().equals("")) {
                        boolean confirm = MessageDialog.openConfirm((Shell)NewDockerConnectionPage.this.getShell(), (String)WizardMessages.getString("DockerMachineSupport.title"), (String)WizardMessages.getString("DockerMachineSupport.message"));
                        if (confirm) {
                            PreferencesUtil.createPreferenceDialogOn((Shell)NewDockerConnectionPage.this.getShell(), (String)NewDockerConnectionPage.DOCKER_MACHINE_PREFERENCE_PAGE_ID, (String[])new String[]{NewDockerConnectionPage.DOCKER_MACHINE_PREFERENCE_PAGE_ID}, null).open();
                            if (this.getDockerMachineInstallDir().equals("") || this.getVMDriverInstallDir().equals("")) {
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                    if ((activeMachineNames = (allMachineStates = this.retrieveDockerMachineNames(dockerMachineInstallDir = this.getDockerMachineInstallDir(), vmDriverInstallDir = this.getVMDriverInstallDir())).entrySet().stream().filter(machineEntry -> (Boolean)machineEntry.getValue()).map(machineEntry -> (String)machineEntry.getKey()).collect(Collectors.toList())).size() > 0) {
                        ListDialog connPrompt = new ListDialog(NewDockerConnectionPage.this.getShell());
                        connPrompt.setContentProvider((IStructuredContentProvider)new ConnectionSelectionContentProvider());
                        connPrompt.setLabelProvider((ILabelProvider)new ConnectionSelectionLabelProvider());
                        connPrompt.setTitle(WizardMessages.getString("DockerConnectionPage.searchDialog.title"));
                        connPrompt.setMessage(WizardMessages.getString("DockerConnectionPage.searchDialog.message"));
                        connPrompt.setInput((Object)activeMachineNames.toArray(new String[0]));
                        if (connPrompt.open() == 0 && connPrompt.getResult().length > 0) {
                            String name = (String)connPrompt.getResult()[0];
                            NewDockerConnectionPage.this.model.setBindingMode(EnumDockerConnectionSettings.TCP_CONNECTION);
                            NewDockerConnectionPage.this.model.setConnectionName(name);
                            NewDockerConnectionPage.this.model.setUnixSocketPath(null);
                            try {
                                String host = DockerMachine.getHost((String)name, (String)dockerMachineInstallDir, (String)vmDriverInstallDir);
                                NewDockerConnectionPage.this.model.setTcpHost(host);
                            }
                            catch (DockerException e1) {
                                Activator.log(e1);
                            }
                            try {
                                String certPath = DockerMachine.getCertPath((String)name, (String)dockerMachineInstallDir, (String)vmDriverInstallDir);
                                if (certPath != null) {
                                    NewDockerConnectionPage.this.model.setTcpTLSVerify(true);
                                    NewDockerConnectionPage.this.model.setTcpCertPath(certPath);
                                    break block16;
                                }
                                NewDockerConnectionPage.this.model.setTcpTLSVerify(false);
                                NewDockerConnectionPage.this.model.setTcpCertPath(null);
                            }
                            catch (DockerException e1) {
                                Activator.log(e1);
                            }
                        }
                    } else if (allMachineStates.size() == 1) {
                        MessageDialog.openInformation((Shell)NewDockerConnectionPage.this.getShell(), (String)WizardMessages.getString("DockerConnectionPage.searchDialog.discovery.title"), (String)WizardMessages.getFormattedString("DockerConnectionPage.searchDialog.discovery.innactive.single", allMachineStates.entrySet().iterator().next().getKey()));
                    } else if (allMachineStates.size() > 1) {
                        String allMachineNames = allMachineStates.entrySet().stream().map(machineEntry -> (String)machineEntry.getKey()).collect(Collectors.joining(", "));
                        MessageDialog.openInformation((Shell)NewDockerConnectionPage.this.getShell(), (String)WizardMessages.getString("DockerConnectionPage.searchDialog.discovery.title"), (String)WizardMessages.getFormattedString("DockerConnectionPage.searchDialog.discovery.innactive.multiple", allMachineNames));
                    } else {
                        MessageDialog.openInformation((Shell)NewDockerConnectionPage.this.getShell(), (String)WizardMessages.getString("DockerConnectionPage.searchDialog.discovery.title"), (String)WizardMessages.getString("DockerConnectionPage.searchDialog.discovery.empty"));
                    }
                }
            }

            private Map<String, Boolean> retrieveDockerMachineNames(String dockerMachineInstallDir, String vmDriverInstallDir) {
                try {
                    String[] dmNames = DockerMachine.getNames((String)dockerMachineInstallDir);
                    return Stream.of(dmNames).collect(Collectors.toMap(name -> name, name -> {
                        try {
                            if (DockerMachine.getHost((String)name, (String)dockerMachineInstallDir, (String)vmDriverInstallDir) != null) {
                                return true;
                            }
                            return false;
                        }
                        catch (DockerException e) {
                            Activator.log(e);
                            return false;
                        }
                    }));
                }
                catch (DockerException e) {
                    Activator.log(e);
                    return Collections.emptyMap();
                }
            }
        };
    }

    protected DockerConnection getDockerConnection() {
        if (this.model.getBindingMode() == EnumDockerConnectionSettings.UNIX_SOCKET) {
            return new DockerConnection.Builder().name(this.model.getConnectionName()).unixSocketConnection(new UnixSocketConnectionSettings(this.model.getUnixSocketPath()));
        }
        return new DockerConnection.Builder().name(this.model.getConnectionName()).tcpConnection(new TCPConnectionSettings(this.model.getTcpHost(), this.model.getTcpCertPath()));
    }

    private static abstract class ConnectionNameValidator
    extends MultiValidator {
        private final IObservableValue<String> connectionNameModelObservable;

        ConnectionNameValidator(IObservableValue<String> connectionNameModelObservable) {
            this.connectionNameModelObservable = connectionNameModelObservable;
        }

        public IObservableValue<String> getConnectionNameModelObservable() {
            return this.connectionNameModelObservable;
        }

        public IObservableList<IObservableValue<String>> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.connectionNameModelObservable);
            return targets;
        }

        protected IStatus validate() {
            String connectionName = (String)this.connectionNameModelObservable.getValue();
            if (connectionName == null || connectionName.isEmpty()) {
                return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.missingConnectionName.msg"));
            }
            if (DockerConnectionManager.getInstance().findConnection(connectionName) != null) {
                return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.duplicateConnectionName.msg"));
            }
            return ValidationStatus.ok();
        }
    }

    private class ConnectionSelectionContentProvider
    implements IStructuredContentProvider {
        private ConnectionSelectionContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (String[])inputElement;
        }
    }

    private class ConnectionSelectionLabelProvider
    implements ILabelProvider {
        private Image CONNECTION_IMAGE = SWTImagesFactory.DESC_REPOSITORY_MIDDLE.createImage();

        private ConnectionSelectionLabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            this.CONNECTION_IMAGE.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Image getImage(Object element) {
            return this.CONNECTION_IMAGE;
        }
    }

    private static class TcpCertificatesValidator
    extends MultiValidator {
        private final IObservableValue<Boolean> tcpConnectionBindingModeModelObservable;
        private final IObservableValue<Boolean> tcpTlsVerifyModelObservable;
        private final IObservableValue<String> tcpCertPathModelObservable;

        public TcpCertificatesValidator(IObservableValue<Boolean> tcpConnectionBindingModeModelObservable, IObservableValue<Boolean> tcpTlsVerifyModelObservable, IObservableValue<String> tcpCertPathModelObservable) {
            this.tcpConnectionBindingModeModelObservable = tcpConnectionBindingModeModelObservable;
            this.tcpTlsVerifyModelObservable = tcpTlsVerifyModelObservable;
            this.tcpCertPathModelObservable = tcpCertPathModelObservable;
        }

        public IObservableList<IObservableValue<String>> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.tcpCertPathModelObservable);
            return targets;
        }

        protected IStatus validate() {
            Boolean tcpConnectionBindingMode = (Boolean)this.tcpConnectionBindingModeModelObservable.getValue();
            Boolean tcpTlsVerify = (Boolean)this.tcpTlsVerifyModelObservable.getValue();
            String tcpCertPath = (String)this.tcpCertPathModelObservable.getValue();
            if (tcpConnectionBindingMode.booleanValue() && tcpTlsVerify.booleanValue()) {
                if (tcpCertPath == null || tcpCertPath.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.missingTcpCertPath.msg"));
                }
                File tcpCert = new File(tcpCertPath);
                if (!tcpCert.exists()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpCertPath.msg"));
                }
                if (!tcpCert.canRead() || !tcpCert.canRead()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.unreadableTcpCertPath.msg"));
                }
            }
            return ValidationStatus.ok();
        }
    }

    private static class TcpHostValidator
    extends ConnectionNameValidator {
        private final IObservableValue<Boolean> tcpConnectionBindingModeModelObservable;
        private final IObservableValue<String> tcpHostModelObservable;

        public TcpHostValidator(IObservableValue<String> connectionNameModelObservable, IObservableValue<Boolean> tcpConnectionBindingModeModelObservable, IObservableValue<String> tcpHostModelObservable) {
            super(connectionNameModelObservable);
            this.tcpConnectionBindingModeModelObservable = tcpConnectionBindingModeModelObservable;
            this.tcpHostModelObservable = tcpHostModelObservable;
        }

        @Override
        public IObservableList<IObservableValue<String>> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.getConnectionNameModelObservable());
            targets.add(this.tcpHostModelObservable);
            return targets;
        }

        @Override
        protected IStatus validate() {
            Boolean tcpConnectionBindingMode = (Boolean)this.tcpConnectionBindingModeModelObservable.getValue();
            String tcpHost = (String)this.tcpHostModelObservable.getValue();
            IStatus connectionNameStatus = super.validate();
            if (!connectionNameStatus.isOK()) {
                return connectionNameStatus;
            }
            if (tcpConnectionBindingMode.booleanValue()) {
                if (tcpHost == null || tcpHost.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.missingTcpConnectionURI.msg"));
                }
                try {
                    URI uri = new URI(tcpHost);
                    String scheme = uri.getScheme() != null ? uri.getScheme().toLowerCase() : null;
                    String host = uri.getHost();
                    int port = uri.getPort();
                    if (!(scheme == null || scheme.equals("tcp") || scheme.equals("http") || scheme.equals("https"))) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpConnectionScheme.msg"));
                    }
                    if (host == null) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpConnectionHost.msg"));
                    }
                    if (port == -1) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpConnectionPort.msg"));
                    }
                    boolean duplicateConnection = DockerConnectionManager.getInstance().getAllConnections().stream().filter(c -> c.getSettings().getType() == IDockerConnectionSettings.BindingType.TCP_CONNECTION).map(c -> (TCPConnectionSettings)c.getSettings()).anyMatch(s -> s.getHost().equals(tcpHost));
                    if (duplicateConnection) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.duplicateTcpConnectionHost.msg"));
                    }
                }
                catch (URISyntaxException e) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpConnectionURI.msg"));
                }
            }
            return ValidationStatus.ok();
        }
    }

    private static class UnixSocketValidator
    extends ConnectionNameValidator {
        private final IObservableValue<Boolean> unixSocketBindingModeModelObservable;
        private final IObservableValue<String> unixSocketPathModelObservable;

        public UnixSocketValidator(IObservableValue<String> connectionNameModelObservable, IObservableValue<Boolean> unixSocketBindingModeModelObservable, IObservableValue<String> unixSocketPathModelObservable) {
            super(connectionNameModelObservable);
            this.unixSocketBindingModeModelObservable = unixSocketBindingModeModelObservable;
            this.unixSocketPathModelObservable = unixSocketPathModelObservable;
        }

        @Override
        public IObservableList<IObservableValue<String>> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.getConnectionNameModelObservable());
            targets.add(this.unixSocketPathModelObservable);
            return targets;
        }

        @Override
        protected IStatus validate() {
            IStatus connectionNameStatus = super.validate();
            Boolean unixSocketBindingMode = (Boolean)this.unixSocketBindingModeModelObservable.getValue();
            String unixSocketPath = (String)this.unixSocketPathModelObservable.getValue();
            if (!connectionNameStatus.isOK()) {
                return connectionNameStatus;
            }
            if (unixSocketBindingMode.booleanValue()) {
                if (unixSocketPath == null || unixSocketPath.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.missingUnixSocket.msg"));
                }
                try {
                    URI unixSocketURI = new URI(unixSocketPath);
                    if (unixSocketURI.getScheme() != null && !unixSocketURI.getScheme().equals("unix")) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidUnixSocketScheme.msg"));
                    }
                    if (unixSocketURI.getPath() == null) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                    }
                    File unixSocket = new File(unixSocketURI.getPath());
                    if (!unixSocket.exists()) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                    }
                    if (!unixSocket.canRead() || !unixSocket.canWrite()) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.unreadableUnixSocket.msg"));
                    }
                    boolean duplicateConnection = DockerConnectionManager.getInstance().getAllConnections().stream().filter(c -> c.getSettings().getType() == IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION).map(c -> (UnixSocketConnectionSettings)c.getSettings()).anyMatch(s -> s.getPath().equals(unixSocketPath));
                    if (duplicateConnection) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.duplicateUnixSocketPath.msg"));
                    }
                }
                catch (URISyntaxException e) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                }
            }
            return ValidationStatus.ok();
        }
    }
}

