/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.wizards;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.vagrant.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.AddBoxPageModel;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.WizardMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AddBoxPage
extends WizardPage {
    private final AddBoxPageModel model;
    private final DataBindingContext dbc;

    public AddBoxPage() {
        super("ImagePullPage", WizardMessages.getString("ImagePull.label"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImagePull.desc"));
        this.model = new AddBoxPageModel();
        this.dbc = new DataBindingContext();
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public String getBoxName() {
        return this.model.getBoxName();
    }

    public String getBoxLoc() {
        return this.model.getBoxLoc();
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollTop = new ScrolledComposite(parent, 768);
        scrollTop.setExpandVertical(true);
        scrollTop.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrollTop, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        Label boxNameLabel = new Label(container, 0);
        boxNameLabel.setText(WizardMessages.getString("ImagePull.name.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)boxNameLabel);
        Text boxNameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)boxNameText);
        boxNameText.setToolTipText(WizardMessages.getString("ImagePull.name.tooltip"));
        IObservableValue boxNameObservable = BeanProperties.value(AddBoxPageModel.class, (String)"boxName").observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)boxNameText), boxNameObservable, new UpdateValueStrategy(), null);
        Label boxLocLabel = new Label(container, 0);
        boxLocLabel.setText(WizardMessages.getString("ImagePull.loc.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)boxLocLabel);
        Text boxLocText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)boxLocText);
        boxLocText.setToolTipText(WizardMessages.getString("ImagePull.loc.tooltip"));
        IObservableValue imageNameObservable = BeanProperties.value(AddBoxPageModel.class, (String)"boxLoc").observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)boxLocText), imageNameObservable, new UpdateValueStrategy(), null);
        Button searchButton = new Button(container, 0);
        searchButton.setText(WizardMessages.getString("ImagePull.search.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)searchButton);
        searchButton.addSelectionListener(this.onSearchImage());
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new CreateBoxValidationStatusProvider((IObservableValue<String>)boxNameObservable, (IObservableValue<String>)imageNameObservable));
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        scrollTop.setContent((Control)container);
        Point point = container.computeSize(-1, -1);
        scrollTop.setSize(point);
        scrollTop.setMinSize(point);
        this.setControl((Control)container);
    }

    private SelectionListener onSearchImage() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(AddBoxPage.this.getShell());
                String location = fd.open();
                if (location != null && !location.isEmpty()) {
                    AddBoxPage.this.model.setBoxLoc(location);
                }
            }
        };
    }

    private class CreateBoxValidationStatusProvider
    extends MultiValidator {
        private IObservableValue<String> boxNameOb;
        private IObservableValue<String> boxLocOb;

        public CreateBoxValidationStatusProvider(IObservableValue<String> boxNameOb, IObservableValue<String> boxLocOb) {
            this.boxNameOb = boxNameOb;
            this.boxLocOb = boxLocOb;
        }

        public IObservableList<String> getTargets() {
            return new WritableList();
        }

        protected IStatus validate() {
            String boxName = (String)this.boxNameOb.getValue();
            String boxLoc = (String)this.boxLocOb.getValue();
            if (boxName == null || boxName.isEmpty()) {
                return ValidationStatus.error((String)WizardMessages.getString("AddBoxPage.emptyBoxName"));
            }
            if (boxLoc == null || boxLoc.isEmpty()) {
                return ValidationStatus.error((String)WizardMessages.getString("AddBoxPage.emptyBoxLoc"));
            }
            return ValidationStatus.ok();
        }
    }
}

