/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.SimpleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscovery;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscoveryProposal;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.PackagingTypeMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.wizards.IMavenDiscoveryUI;
import org.eclipse.m2e.internal.discovery.InstallCatalogItemMavenDiscoveryProposal;
import org.eclipse.m2e.internal.discovery.MavenDiscovery;
import org.eclipse.m2e.internal.discovery.operation.MavenDiscoveryInstallOperation;
import org.eclipse.m2e.internal.discovery.wizards.MavenDiscoveryUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDiscoveryService
implements IMavenDiscoveryUI,
IMavenDiscovery,
ServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(MavenDiscoveryService.class);
    private List<CatalogItemCacheEntry> items;
    private final Object itemsLock = new Object();

    public MavenDiscoveryService() {
        this(true);
    }

    public MavenDiscoveryService(boolean factory) {
    }

    public Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> discover(final MavenProject mavenProject, final List<MojoExecution> mojoExecutions, final List<IMavenDiscoveryProposal> preselected, IProgressMonitor monitor) throws CoreException {
        this.initializeCatalog(monitor);
        if (this.items == null) {
            return Collections.emptyMap();
        }
        return (Map)MavenPlugin.getMaven().execute((ICallable)new ICallable<Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>>>(){

            public Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return MavenDiscoveryService.this.discover0(mavenProject, mojoExecutions, preselected, monitor);
            }
        }, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCatalog(IProgressMonitor monitor) {
        Object object = this.itemsLock;
        synchronized (object) {
            if (this.items == null) {
                this.items = new ArrayList<CatalogItemCacheEntry>();
                Catalog catalog = MavenDiscovery.getCatalog();
                IStatus status = catalog.performDiscovery(monitor);
                if (!status.isOK()) {
                    log.error(status.toString());
                    return;
                }
                IProvisioningAgent p2agent = ProvisioningUI.getDefaultUI().getSession().getProvisioningAgent();
                IProfileRegistry profRegistry = (IProfileRegistry)p2agent.getService(IProfileRegistry.SERVICE_NAME);
                IProfile profile = profRegistry.getProfile("_SELF_");
                for (CatalogItem item : catalog.getItems()) {
                    LifecycleMappingMetadataSource metadataSource = MavenDiscovery.getLifecycleMappingMetadataSource(item);
                    ArrayList<String> projectConfigurators = new ArrayList<String>();
                    ArrayList<String> mappingStrategies = new ArrayList<String>();
                    MavenDiscovery.getProvidedProjectConfigurators(item, projectConfigurators, mappingStrategies);
                    if (metadataSource == null || this.itemInstalled(profile, item, monitor)) continue;
                    this.addCatalogItem(item, metadataSource, projectConfigurators, mappingStrategies);
                }
                catalog.dispose();
            }
        }
    }

    Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> discover0(MavenProject mavenProject, List<MojoExecution> mojoExecutions, List<IMavenDiscoveryProposal> preselected, IProgressMonitor monitor) throws CoreException {
        LinkedHashMap<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> proposals = new LinkedHashMap<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>>();
        Collection<CatalogItem> selectedItems = this.toCatalogItems(preselected);
        List<LifecycleMappingMetadataSource> selectedSources = this.toMetadataSources(preselected);
        Map metadataSourcesMap = LifecycleMappingFactory.getProjectMetadataSourcesMap((MavenProject)mavenProject, null, mojoExecutions, (boolean)false, (IProgressMonitor)monitor);
        for (CatalogItemCacheEntry itemEntry : this.items) {
            CatalogItem item = itemEntry.getItem();
            LifecycleMappingMetadataSource src = itemEntry.getMetadataSource();
            boolean preselectItem = false;
            for (CatalogItem selectedItem : selectedItems) {
                if (!selectedItem.getSiteUrl().equals(item.getSiteUrl()) || !selectedItem.getInstallableUnits().equals(item.getInstallableUnits())) continue;
                preselectItem = true;
                break;
            }
            if (src == null) continue;
            log.debug("Considering catalog item '{}' for project {}", (Object)item.getName(), (Object)mavenProject.getName());
            src.setSource((Object)item);
            LifecycleMappingResult mappingResult = new LifecycleMappingResult();
            ArrayList<LifecycleMappingMetadataSource> sources = new ArrayList<LifecycleMappingMetadataSource>(selectedSources);
            if (!preselectItem) {
                sources.add(src);
            }
            metadataSourcesMap.put("bundleMetadataSources", Collections.singletonList(new SimpleMappingMetadataSource(sources)));
            List metadataSources = LifecycleMappingFactory.asList((Map)metadataSourcesMap);
            LifecycleMappingFactory.calculateEffectiveLifecycleMappingMetadata((LifecycleMappingResult)mappingResult, (List)metadataSources, (MavenProject)mavenProject, mojoExecutions, (boolean)false, (IProgressMonitor)monitor);
            LifecycleMappingMetadata lifecycleMappingMetadata = mappingResult.getLifecycleMappingMetadata();
            if (lifecycleMappingMetadata != null) {
                IMavenDiscoveryProposal proposal = this.getProposal(lifecycleMappingMetadata.getSource());
                if (proposal != null) {
                    this.put(proposals, (ILifecycleMappingRequirement)new PackagingTypeMappingConfiguration.PackagingTypeMappingRequirement(mavenProject.getPackaging()), proposal);
                } else if (!LifecycleMappingFactory.getLifecycleMappingExtensions().containsKey(lifecycleMappingMetadata.getLifecycleMappingId()) && itemEntry.getMappingStrategies().contains(lifecycleMappingMetadata.getLifecycleMappingId())) {
                    this.put(proposals, (ILifecycleMappingRequirement)new PackagingTypeMappingConfiguration.LifecycleStrategyMappingRequirement(lifecycleMappingMetadata.getPackagingType(), lifecycleMappingMetadata.getLifecycleMappingId()), new InstallCatalogItemMavenDiscoveryProposal(item));
                }
            }
            for (Map.Entry entry : mappingResult.getMojoExecutionMapping().entrySet()) {
                if (entry.getValue() == null) continue;
                for (IPluginExecutionMetadata executionMapping : (List)entry.getValue()) {
                    log.debug("mapping proposal {} => {}", (Object)((MojoExecutionKey)entry.getKey()).toString(), (Object)executionMapping.getAction().toString());
                    IMavenDiscoveryProposal proposal = this.getProposal(((PluginExecutionMetadata)executionMapping).getSource());
                    if (proposal != null) {
                        this.put(proposals, (ILifecycleMappingRequirement)new MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement((MojoExecutionKey)entry.getKey()), proposal);
                        continue;
                    }
                    if (executionMapping.getAction() != PluginExecutionAction.configurator) continue;
                    String configuratorId = LifecycleMappingFactory.getProjectConfiguratorId((IPluginExecutionMetadata)executionMapping);
                    if (LifecycleMappingFactory.getProjectConfiguratorExtensions().containsKey(configuratorId) || !itemEntry.getProjectConfigurators().contains(configuratorId)) continue;
                    this.put(proposals, (ILifecycleMappingRequirement)new MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement((MojoExecutionKey)entry.getKey(), configuratorId), new InstallCatalogItemMavenDiscoveryProposal(item));
                }
            }
        }
        return proposals;
    }

    public boolean itemInstalled(IProfile profile, CatalogItem item, IProgressMonitor monitor) {
        if (profile == null) {
            return false;
        }
        ArrayList<IQuery> queries = new ArrayList<IQuery>();
        for (String iuId : item.getInstallableUnits()) {
            queries.add(QueryUtil.createIUQuery((String)iuId));
        }
        IQueryResult result = profile.query(QueryUtil.createCompoundQuery(queries, (boolean)true), monitor);
        return !result.isEmpty();
    }

    public void addCatalogItem(CatalogItem item, LifecycleMappingMetadataSource metadataSource, List<String> projectConfigurators, List<String> mappingStrategies) {
        if (this.items == null) {
            this.items = new ArrayList<CatalogItemCacheEntry>();
        }
        this.items.add(new CatalogItemCacheEntry(item, metadataSource, projectConfigurators, mappingStrategies));
    }

    private IMavenDiscoveryProposal getProposal(LifecycleMappingMetadataSource src) {
        if (src == null) {
            return null;
        }
        if (src.getSource() instanceof CatalogItem) {
            return new InstallCatalogItemMavenDiscoveryProposal((CatalogItem)src.getSource());
        }
        return null;
    }

    private List<LifecycleMappingMetadataSource> toMetadataSources(List<IMavenDiscoveryProposal> proposals) {
        ArrayList<LifecycleMappingMetadataSource> sources = new ArrayList<LifecycleMappingMetadataSource>();
        for (IMavenDiscoveryProposal proposal : proposals) {
            if (!(proposal instanceof InstallCatalogItemMavenDiscoveryProposal)) continue;
            CatalogItem catalogItem = ((InstallCatalogItemMavenDiscoveryProposal)proposal).getCatalogItem();
            LifecycleMappingMetadataSource source = MavenDiscovery.getLifecycleMappingMetadataSource(catalogItem);
            source.setSource((Object)catalogItem);
            sources.add(source);
        }
        return sources;
    }

    private void put(Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> allproposals, ILifecycleMappingRequirement requirement, IMavenDiscoveryProposal proposal) {
        List<IMavenDiscoveryProposal> proposals = allproposals.get(requirement);
        if (proposals == null) {
            proposals = new ArrayList<IMavenDiscoveryProposal>();
            allproposals.put(requirement, proposals);
        }
        if (!proposals.contains(proposal)) {
            proposals.add(proposal);
        }
    }

    public boolean implement(List<IMavenDiscoveryProposal> proposals, IRunnableWithProgress postInstallHook, IRunnableContext context, Collection<String> projectsToConfigure) {
        try {
            MavenDiscoveryInstallOperation runner = new MavenDiscoveryInstallOperation(this.toCatalogItems(proposals), postInstallHook, true, false, projectsToConfigure);
            context.run(true, true, (IRunnableWithProgress)runner);
            int openInstallWizard = MavenDiscoveryUi.openInstallWizard(runner.getOperation(), true, context);
            return openInstallWizard == 0;
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.m2e.discovery", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private Collection<CatalogItem> toCatalogItems(List<IMavenDiscoveryProposal> proposals) {
        if (proposals == null) {
            return Collections.emptyList();
        }
        HashSet<CatalogItem> items = new HashSet<CatalogItem>(proposals.size());
        for (IMavenDiscoveryProposal proposal : proposals) {
            if (!(proposal instanceof InstallCatalogItemMavenDiscoveryProposal)) continue;
            items.add(((InstallCatalogItemMavenDiscoveryProposal)proposal).getCatalogItem());
        }
        return items;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new MavenDiscoveryService(false);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public Map<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> discover(Collection<ILifecycleMappingRequirement> requirements, List<IMavenDiscoveryProposal> preselected, IProgressMonitor monitor) throws CoreException {
        if (requirements == null || requirements.isEmpty()) {
            return Collections.emptyMap();
        }
        this.initializeCatalog(monitor);
        if (this.items == null) {
            return Collections.emptyMap();
        }
        Collection<CatalogItem> selectedItems = this.toCatalogItems(preselected);
        LinkedHashMap<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>> allproposals = new LinkedHashMap<ILifecycleMappingRequirement, List<IMavenDiscoveryProposal>>(requirements.size());
        for (CatalogItemCacheEntry itemEntry : this.items) {
            if (monitor.isCanceled()) break;
            CatalogItem item = itemEntry.getItem();
            if (selectedItems.contains(item)) continue;
            LifecycleMappingMetadataSource src = itemEntry.getMetadataSource();
            log.debug("Considering catalog item '{}'", (Object)item.getName());
            for (ILifecycleMappingRequirement requirement : requirements) {
                boolean matchFound = false;
                if (requirement instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement) {
                    MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement meReq = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)requirement;
                    MojoExecutionKey mek = meReq.getExecution();
                    if (MavenDiscoveryService.matchesFilter(src, mek, meReq.getPackaging())) {
                        matchFound = true;
                    }
                } else if (requirement instanceof PackagingTypeMappingConfiguration.PackagingTypeMappingRequirement) {
                    String packaging = ((PackagingTypeMappingConfiguration.PackagingTypeMappingRequirement)requirement).getPackaging();
                    if (MavenDiscoveryService.hasPackaging(src, packaging)) {
                        matchFound = true;
                    }
                } else if (requirement instanceof PackagingTypeMappingConfiguration.LifecycleStrategyMappingRequirement) {
                    String mappingId = ((PackagingTypeMappingConfiguration.LifecycleStrategyMappingRequirement)requirement).getLifecycleMappingId();
                    if (itemEntry.getMappingStrategies().contains(mappingId)) {
                        matchFound = true;
                    }
                } else if (requirement instanceof MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement) {
                    String configuratorId = ((MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement)requirement).getProjectConfiguratorId();
                    if (itemEntry.getProjectConfigurators().contains(configuratorId)) {
                        matchFound = true;
                    }
                }
                if (!matchFound) continue;
                InstallCatalogItemMavenDiscoveryProposal proposal = new InstallCatalogItemMavenDiscoveryProposal(item);
                this.put(allproposals, requirement, proposal);
            }
        }
        return allproposals;
    }

    private static boolean matchesFilter(LifecycleMappingMetadataSource src, MojoExecutionKey mojoExecution, String type) {
        for (PluginExecutionMetadata p : src.getPluginExecutions()) {
            if (!p.getFilter().match(mojoExecution)) continue;
            return true;
        }
        for (LifecycleMappingMetadata lm : src.getLifecycleMappings()) {
            if ((type != null || lm.getPackagingType() != null) && (type == null || !type.equals(lm.getPackagingType()))) continue;
            for (PluginExecutionMetadata p : lm.getPluginExecutions()) {
                if (!p.getFilter().match(mojoExecution)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasPackaging(LifecycleMappingMetadataSource lifecycleMappingMetadataSource, String packagingType) {
        for (LifecycleMappingMetadata lifecycleMappingMetadata : lifecycleMappingMetadataSource.getLifecycleMappings()) {
            if (!packagingType.equals(lifecycleMappingMetadata.getPackagingType())) continue;
            return true;
        }
        return false;
    }

    public static class CatalogItemCacheEntry {
        private final CatalogItem item;
        private final LifecycleMappingMetadataSource metadataSource;
        private final List<String> projectConfigurators;
        private final List<String> mappingStrategies;

        public CatalogItemCacheEntry(CatalogItem item, LifecycleMappingMetadataSource metadataSource, List<String> projectConfigurators, List<String> mappingStrategies) {
            this.item = item;
            this.metadataSource = metadataSource;
            this.projectConfigurators = projectConfigurators;
            this.mappingStrategies = mappingStrategies;
        }

        public CatalogItem getItem() {
            return this.item;
        }

        public LifecycleMappingMetadataSource getMetadataSource() {
            return this.metadataSource;
        }

        public List<String> getProjectConfigurators() {
            return this.projectConfigurators;
        }

        public List<String> getMappingStrategies() {
            return this.mappingStrategies;
        }
    }
}

