/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.internal.reviews.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.review.IReviewRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.ui.ProgressDialog;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;

public class AddCommentDialog
extends ProgressDialog {
    private RichTextEditor commentEditor;
    private final ILocation location;
    private final ReviewBehavior reviewBehavior;
    protected final ITask task;
    protected FormToolkit toolkit;
    private final IReviewItem item;
    private CommonTextSupport textSupport;

    public AddCommentDialog(Shell parentShell, ReviewBehavior reviewBehavior, IReviewItem item, ILocation location) {
        super(parentShell);
        this.reviewBehavior = reviewBehavior;
        this.item = item;
        this.location = location;
        this.task = reviewBehavior.getTask();
    }

    public boolean close() {
        boolean shouldClose;
        if (this.getReturnCode() == 0 && !(shouldClose = this.performOperation(this.getComment()))) {
            return false;
        }
        if (this.textSupport != null) {
            this.textSupport.dispose();
        }
        return super.close();
    }

    public ILocation getLocation() {
        return this.location;
    }

    public ITask getTask() {
        return this.task;
    }

    private IComment getComment() {
        IComment comment = this.item.createComment(this.getLocation(), this.commentEditor.getText());
        return comment;
    }

    private boolean performOperation(final IComment comment) {
        final AtomicReference result = new AtomicReference();
        try {
            this.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    result.set(AddCommentDialog.this.reviewBehavior.addComment(AddCommentDialog.this.item, comment, monitor));
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Unexpected error during execution of operation", (Throwable)e), 3);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (((IStatus)result.get()).getSeverity() == 8) {
            return false;
        }
        if (((IStatus)result.get()).isOK()) {
            this.item.getComments().add(comment);
            IFileItem file = null;
            if (this.item instanceof IFileItem) {
                file = (IFileItem)this.item;
            } else if (this.item instanceof IFileVersion) {
                file = ((IFileVersion)this.item).getFile();
            }
            if (file != null && file.getReview() != null) {
                TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(this.reviewBehavior.getTask().getConnectorKind(), this.reviewBehavior.getTask().getRepositoryUrl());
                ReviewsConnector connector = (ReviewsConnector)TasksUiPlugin.getConnector((String)this.reviewBehavior.getTask().getConnectorKind());
                IReviewRemoteFactoryProvider factoryProvider = (IReviewRemoteFactoryProvider)connector.getReviewClient(taskRepository).getFactoryProvider();
                RemoteEmfConsumer consumer = factoryProvider.getReviewItemSetContentFactory().getConsumerForLocalKey((EObject)file.getSet(), (Object)file.getSet().getId());
                consumer.updateObservers();
                consumer.release();
            }
            return true;
        }
        StatusManager.getManager().handle((IStatus)result.get(), 3);
        return false;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(TasksUiPlugin.getDefault().getFormColors(parent.getDisplay()));
        return super.createDialogArea(parent);
    }

    @Override
    protected Control createPageControls(Composite parent) {
        this.getShell().setText(Messages.Reviews_AddCommentDialog_Title);
        this.setTitle(Messages.Reviews_AddCommentDialog_Title);
        this.setMessage(NLS.bind((String)Messages.Reviews_AddCommentDialog_Message, (Object)new Path(this.item.getName()).lastSegment(), (Object)this.location.getIndex()));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.commentEditor = this.createRichTextEditor(composite, "");
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.commentEditor.getControl());
        return composite;
    }

    protected RichTextEditor createRichTextEditor(Composite composite, String value) {
        int style = 8390722;
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)repository);
        final RichTextEditor editor = new RichTextEditor(repository, style, null, extension, this.task);
        editor.setText(value);
        editor.setSpellCheckingEnabled(true);
        editor.createControl(composite, this.toolkit);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService != null) {
            this.textSupport = new CommonTextSupport(handlerService);
            this.textSupport.install((TextViewer)editor.getViewer(), true);
        }
        editor.getViewer().getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                editor.getViewer().getTextWidget().setSelection(0);
            }
        });
        return editor;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }
}

