/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.core;

import java.util.List;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.AsciiDocContentState;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.AsciiDocPreProcessor;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.CodeBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.CommentBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.HorizontalRuleBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.PreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.PropertiesLineBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.TitleLineBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.UnderlinedHeadingBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.phrase.BackslashEscapePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.AnchorLinkMacroReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.AnchorLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.EmailLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.ExplicitLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.ImplicitFormattedLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.ImplicitLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.InlineCommentReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.InlineImageReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.PreserverHtmlEntityToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.XrefMacroReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.XrefReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.util.ReadAheadDispatcher;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternLineBreakReplacementToken;

public class AsciiDocLanguage
extends AbstractMarkupLanguage {
    public AsciiDocLanguage() {
        this.setName("AsciiDoc");
    }

    protected ContentState createState() {
        return new AsciiDocContentState();
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new PreserverHtmlEntityToken());
        tokenSyntax.add((PatternBasedElement)new PatternLineBreakReplacementToken("(\\s\\+)\\s*"));
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        if (this.isEnableMacros()) {
            markupContent = this.preprocessContent(markupContent);
        }
        super.processContent(parser, markupContent, asDocument);
    }

    protected String preprocessContent(String markupContent) {
        return new AsciiDocPreProcessor().process(markupContent);
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.add((PatternBasedElement)new InlineCommentReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new EmailLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ExplicitLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ImplicitFormattedLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ImplicitLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new AnchorLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new AnchorLinkMacroReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new XrefReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new XrefMacroReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("+"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("*"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("_"));
        phraseModifierSyntax.add((PatternBasedElement)new InlineImageReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("`", DocumentBuilder.SpanType.CODE));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("+", DocumentBuilder.SpanType.CODE));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("*", DocumentBuilder.SpanType.STRONG));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS));
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        ListBlock listBlock = new ListBlock();
        blocks.add(listBlock);
        paragraphBreakingBlocks.add(listBlock);
        TitleLineBlock titleLineBlock = new TitleLineBlock();
        PropertiesLineBlock propertiesLineBlock = new PropertiesLineBlock();
        PreformattedBlock preformattedBlock = new PreformattedBlock();
        CommentBlock commentBlock = new CommentBlock();
        HeadingBlock headingBlock = new HeadingBlock();
        CodeBlock codeBlock = new CodeBlock();
        HorizontalRuleBlock hrBlock = new HorizontalRuleBlock();
        blocks.add(titleLineBlock);
        blocks.add(propertiesLineBlock);
        blocks.add(preformattedBlock);
        blocks.add(headingBlock);
        blocks.add(codeBlock);
        blocks.add(commentBlock);
        blocks.add(hrBlock);
        paragraphBreakingBlocks.add(codeBlock);
        paragraphBreakingBlocks.add(commentBlock);
        paragraphBreakingBlocks.add(preformattedBlock);
    }

    protected Block createParagraphBlock() {
        ParagraphBlock paragraphBlock = new ParagraphBlock();
        UnderlinedHeadingBlock headingBlock = new UnderlinedHeadingBlock();
        ReadAheadDispatcher readAheadBlock = new ReadAheadDispatcher(headingBlock, paragraphBlock);
        return readAheadBlock;
    }
}

