/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.DefaultSplittingStrategy;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplitOutlineItem;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingHtmlDocumentBuilder;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingOutlineParser;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingStrategy;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SplittingHtmlDocumentBuilderTest {
    @Rule
    public final TemporaryFolder temporaryFolderRule = new TemporaryFolder();
    private final SplittingHtmlDocumentBuilder builder = new SplittingHtmlDocumentBuilder();
    private HtmlDocumentBuilder rootBuilder;
    private File outputFile;

    @Before
    public void before() throws IOException {
        this.outputFile = this.temporaryFolderRule.newFile("index.html");
    }

    @Test
    public void embeddedTableOfContents() throws IOException {
        Assert.assertFalse((boolean)this.builder.isEmbeddedTableOfContents());
        this.generateContents("h1. First\n\nh2. First.1\n\nh1. Second\n\nh2. Second.1\n\ntext", true);
        this.assertFileContents("embeddedTableOfContents_First.html.txt", this.outputFile);
        this.assertFileContents("embeddedTableOfContents_Second.html.txt", new File(this.outputFile.getParentFile(), "Second.html"));
    }

    @Test
    public void headingLinks() throws IOException {
        this.generateContents("{toc}\n\nh1. First\n\nh2. First.1\n\nh1. Second\n\n\"link to first\":#First and \"link to first.1\":#First.1\n\nh2. Second.1\n\ntext", false);
        this.assertFileContents("headingLinks_First.html.txt", this.outputFile);
        this.assertFileContents("headingLinks_Second.html.txt", new File(this.outputFile.getParentFile(), "Second.html"));
    }

    private void generateContents(String markup, boolean embeddedTableOfContents) throws IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), StandardCharsets.UTF_8);){
            this.rootBuilder = new HtmlDocumentBuilder((Writer)out, true);
            SplittingOutlineParser outlineParser = new SplittingOutlineParser();
            outlineParser.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
            outlineParser.setSplittingStrategy((SplittingStrategy)new DefaultSplittingStrategy());
            SplitOutlineItem outline = outlineParser.parse(markup);
            outline.setSplitTarget(this.outputFile.getName());
            this.builder.setEmbeddedTableOfContents(embeddedTableOfContents);
            this.builder.setRootBuilder(this.rootBuilder);
            this.builder.setRootFile(this.outputFile);
            this.builder.setFormatting(true);
            this.builder.setOutline(outline);
            MarkupParser parser = new MarkupParser((MarkupLanguage)new TextileLanguage());
            parser.setBuilder((DocumentBuilder)this.builder);
            parser.parse(markup);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void assertFileContents(String resource, File outputFile) throws IOException {
        String resourcePath = "resources/SplittingHtmlDocumentBuilderTest_" + resource;
        String resourceContents = Resources.toString((URL)SplittingHtmlDocumentBuilderTest.class.getResource(resourcePath), (Charset)StandardCharsets.UTF_8);
        String actualContents = Resources.toString((URL)outputFile.toURI().toURL(), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)MessageFormat.format("Resource {0} differs", resourcePath), (Object)resourceContents, (Object)actualContents);
    }
}

