/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

public class SelectRowCommandHandler
implements ILayerCommandHandler<SelectRowsCommand> {
    private final SelectionLayer selectionLayer;

    public SelectRowCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectRowsCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.selectRows(command.getColumnPosition(), command.getRowPositions(), command.isWithShiftMask(), command.isWithControlMask(), command.getRowPositionToMoveIntoViewport());
            return true;
        }
        return false;
    }

    protected void selectRows(int columnPosition, Collection<Integer> rowPositions, boolean withShiftMask, boolean withControlMask, int rowPositionToMoveIntoViewport) {
        HashSet<Range> changedRowRanges = new HashSet<Range>();
        for (int rowPosition : rowPositions) {
            changedRowRanges.addAll(this.internalSelectRow(columnPosition, rowPosition, withShiftMask, withControlMask));
        }
        HashSet<Integer> changedRows = new HashSet<Integer>();
        for (Range range : changedRowRanges) {
            int i = range.start;
            while (i < range.end) {
                changedRows.add(i);
                ++i;
            }
        }
        this.selectionLayer.fireLayerEvent(new RowSelectionEvent(this.selectionLayer, changedRows, rowPositionToMoveIntoViewport, withShiftMask, withControlMask));
    }

    private Set<Range> internalSelectRow(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        HashSet<Range> changedRowRanges = new HashSet<Range>();
        if (SelectionUtils.noShiftOrControl(withShiftMask, withControlMask)) {
            changedRowRanges.addAll(this.selectionLayer.getSelectedRowPositions());
            this.selectionLayer.clear(false);
            this.selectionLayer.selectCell(0, rowPosition, withShiftMask, withControlMask);
            this.selectionLayer.selectRegion(0, rowPosition, Integer.MAX_VALUE, 1);
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
            changedRowRanges.add(new Range(rowPosition, rowPosition + 1));
        } else if (SelectionUtils.bothShiftAndControl(withShiftMask, withControlMask)) {
            changedRowRanges.add(this.selectRowWithShiftKey(columnPosition, rowPosition));
        } else if (SelectionUtils.isShiftOnly(withShiftMask, withControlMask)) {
            changedRowRanges.add(this.selectRowWithShiftKey(columnPosition, rowPosition));
        } else if (SelectionUtils.isControlOnly(withShiftMask, withControlMask)) {
            changedRowRanges.add(this.selectRowWithCtrlKey(columnPosition, rowPosition));
        }
        this.selectionLayer.setLastSelectedCell(columnPosition, rowPosition);
        return changedRowRanges;
    }

    private Range selectRowWithCtrlKey(int columnPosition, int rowPosition) {
        Rectangle selectedRowRectangle = new Rectangle(0, rowPosition, Integer.MAX_VALUE, 1);
        if (this.selectionLayer.isRowPositionFullySelected(rowPosition)) {
            this.selectionLayer.clearSelection(selectedRowRectangle);
            this.selectionLayer.setLastSelectedRegion(null);
            int[] selectedRows = this.selectionLayer.getFullySelectedRowPositions();
            if (selectedRows.length > 0 && this.selectionLayer.getSelectionAnchor().rowPosition == -1) {
                int toPos = selectedRows[0];
                int i = 0;
                while (i < selectedRows.length) {
                    if (selectedRows[i] >= rowPosition) break;
                    toPos = selectedRows[i];
                    ++i;
                }
                this.selectionLayer.moveSelectionAnchor(columnPosition, toPos);
            }
        } else {
            if (this.selectionLayer.getLastSelectedRegion() != null) {
                this.selectionLayer.selectRegion(this.selectionLayer.getLastSelectedRegion().x, this.selectionLayer.getLastSelectedRegion().y, this.selectionLayer.getLastSelectedRegion().width, this.selectionLayer.getLastSelectedRegion().height);
            }
            this.selectionLayer.selectRegion(0, rowPosition, Integer.MAX_VALUE, 1);
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        }
        return new Range(rowPosition, rowPosition + 1);
    }

    private Range selectRowWithShiftKey(int columnPosition, int rowPosition) {
        int numOfRowsToIncludeInRegion = 1;
        int startRowPosition = rowPosition;
        Rectangle lastSelectedRegion = this.selectionLayer.getLastSelectedRegion();
        if (lastSelectedRegion != null) {
            this.selectionLayer.getSelectionModel().clearSelection(lastSelectedRegion);
        } else {
            this.selectionLayer.getSelectionModel().clearSelection();
        }
        if (!this.selectionLayer.getSelectionModel().isMultipleSelectionAllowed()) {
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        }
        if (this.selectionLayer.getLastSelectedRegion() != null) {
            numOfRowsToIncludeInRegion = Math.abs(this.selectionLayer.getSelectionAnchor().rowPosition - rowPosition) + 1;
            startRowPosition = startRowPosition < this.selectionLayer.getSelectionAnchor().rowPosition ? rowPosition : this.selectionLayer.getSelectionAnchor().rowPosition;
        }
        this.selectionLayer.selectRegion(0, startRowPosition, Integer.MAX_VALUE, numOfRowsToIncludeInRegion);
        return new Range(startRowPosition, startRowPosition + numOfRowsToIncludeInRegion);
    }

    @Override
    public Class<SelectRowsCommand> getCommandClass() {
        return SelectRowsCommand.class;
    }
}

