/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.rolefile;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.OTRefactoringMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEditGroup;

public class MoveToRoleFileRefactoring
extends Refactoring {
    private ICompilationUnit fTeamCUnit;
    private CompilationUnit fRootRole;
    private IType fTeamType;
    private IType fRoleType;

    public MoveToRoleFileRefactoring() {
    }

    public MoveToRoleFileRefactoring(IType roleType) {
        this.fRoleType = roleType;
    }

    public String getName() {
        return OTRefactoringMessages.MoveToRoleFileRefactoring_moveToRoleFile_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(OTRefactoringMessages.MoveToRoleFileRefactoring_preconditions_progress, 1);
            if (this.fRoleType == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.MoveToRoleFileRefactoring_noRole_error));
            } else if (!this.fRoleType.exists()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.MoveToRoleFileRefactoring_inexistentRole_error, (Object[])new Object[]{this.fRoleType.getElementName()})));
            } else if (this.fRoleType.isBinary()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.MoveToRoleFileRefactoring_binaryRole_error, (Object[])new Object[]{this.fRoleType.getElementName()})));
            } else if (this.fRoleType.isReadOnly()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.MoveToRoleFileRefactoring_readOnlyRole_error, (Object[])new Object[]{this.fRoleType.getElementName()})));
            } else if (!this.fRoleType.getCompilationUnit().isStructureKnown()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.MoveToRoleFileRefactoring_compileErrors_error, (Object[])new Object[]{this.fRoleType.getCompilationUnit().getElementName()})));
            } else if (!OTModelManager.isRole((IType)this.fRoleType)) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.MoveToRoleFileRefactoring_notInsideRole_error, (Object[])new Object[]{this.fRoleType.getElementName()})));
            } else if (((IRoleType)OTModelManager.getOTElement((IType)this.fRoleType)).isRoleFile()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.MoveToRoleFileRefactoring_insideRoleFile_error, (Object[])new Object[]{this.fRoleType.getElementName()})));
            } else {
                status.merge(this.initialize(monitor));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus initialize(IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        this.fTeamType = (IType)this.fRoleType.getParent();
        this.fTeamCUnit = this.fTeamType.getCompilationUnit();
        if (this.fTeamType != null && !(this.fTeamType.getParent() instanceof ICompilationUnit)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.MoveToRoleFileRefactoring_teamNotToplevel_error, (Object[])new Object[]{this.fTeamType.getElementName()})));
        }
        if (this.fRootRole == null) {
            this.fRootRole = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fTeamCUnit, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 99));
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(OTRefactoringMessages.MoveToRoleFileRefactoring_creatingChange_progress, 5);
        CompositeChange change = new CompositeChange(OTRefactoringMessages.MoveToRoleFileRefactoring_change_name);
        TextEditGroup editGroup = new TextEditGroup(OTRefactoringMessages.MoveToRoleFileRefactoring_change_name);
        ICompilationUnit newCuWC = null;
        try {
            IPackageFragment enclosingPackage = this.fRoleType.getPackageFragment();
            IPackageFragmentRoot root = (IPackageFragmentRoot)enclosingPackage.getAncestor(3);
            String enclPackName = enclosingPackage.getElementName();
            IPackageFragment teamPackage = root.getPackageFragment(enclPackName.length() == 0 ? this.fTeamType.getElementName() : String.valueOf(enclPackName) + '.' + this.fTeamType.getElementName());
            CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(this.fTeamCUnit);
            CompilationUnit teamCU = cuRewrite.getRoot();
            TypeDeclaration teamNode = (TypeDeclaration)this.findDeclaration(teamCU, (ISourceReference)this.fTeamType);
            ASTNode roleNode = this.findDeclaration(teamCU, (ISourceReference)this.fRoleType);
            if (!teamPackage.getResource().exists()) {
                change.add((Change)new CreatePackageChange(teamPackage));
            }
            newCuWC = teamPackage.getCompilationUnit(String.valueOf(this.fRoleType.getElementName()) + ".java").getWorkingCopy((IProgressMonitor)new SubProgressMonitor(pm, 2));
            String oldSource = this.fTeamCUnit.getSource();
            ISourceRange sourceRange = this.fRoleType.getSourceRange();
            StringBuilder newRoleSource = new StringBuilder();
            IJavaProject javaProject = this.fRoleType.getJavaProject();
            if (StubUtility.doAddComments((IJavaProject)javaProject)) {
                newRoleSource.append(CodeGeneration.getFileComment((ICompilationUnit)newCuWC, (String)StubUtility.getLineDelimiterUsed((IJavaProject)javaProject)));
            }
            newRoleSource.append("\nteam package " + teamPackage.getElementName() + ";\n\n");
            newRoleSource.append(this.getAlignedSourceBlock(javaProject, oldSource.substring(sourceRange.getOffset(), sourceRange.getOffset() + sourceRange.getLength())));
            change.add((Change)new CreateCompilationUnitChange(newCuWC, newRoleSource.toString(), null));
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ListRewrite teamMembersRewrite = rewrite.getListRewrite((ASTNode)teamNode, teamNode.getBodyDeclarationsProperty());
            teamMembersRewrite.remove(roleNode, editGroup);
            Javadoc teamDoc = teamNode.getJavadoc();
            AST ast = teamCU.getAST();
            TextElement roleName = ast.newTextElement();
            roleName.setText(this.fRoleType.getElementName());
            TagElement roleTag = ast.newTagElement();
            roleTag.setTagName("@role");
            roleTag.fragments().add(roleName);
            if (teamDoc == null) {
                teamDoc = ast.newJavadoc();
                teamDoc.tags().add(roleTag);
                rewrite.set((ASTNode)teamNode, (StructuralPropertyDescriptor)teamNode.getJavadocProperty(), (Object)teamDoc, editGroup);
            } else {
                ListRewrite tags = rewrite.getListRewrite((ASTNode)teamDoc, Javadoc.TAGS_PROPERTY);
                tags.insertLast((ASTNode)roleTag, editGroup);
            }
            change.add((Change)cuRewrite.createChange(true, (IProgressMonitor)new SubProgressMonitor(pm, 2)));
        }
        finally {
            if (newCuWC != null) {
                newCuWC.discardWorkingCopy();
            }
        }
        pm.done();
        return change;
    }

    private ASTNode findDeclaration(CompilationUnit unit, ISourceReference source) throws JavaModelException {
        ISourceRange range = source.getSourceRange();
        NodeFinder finder = new NodeFinder((ASTNode)unit, range.getOffset(), range.getLength());
        return finder.getCoveredNode();
    }

    private String getAlignedSourceBlock(IJavaProject javaProject, String block) {
        Assert.isNotNull((Object)block);
        String[] lines = Strings.convertIntoLines((String)block);
        Strings.trimIndentation((String[])lines, (IJavaProject)javaProject, (boolean)false);
        return Strings.concatenate((String[])lines, (String)StubUtility.getLineDelimiterUsed((IJavaProject)javaProject));
    }
}

