/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class CreateCallAllBindingsCallInOrgMethod
extends AbstractTransformableClassNode {
    private Method orgMethod;
    private int boundMethodId;

    public CreateCallAllBindingsCallInOrgMethod(Method orgMethod, int boundMethodId) {
        this.orgMethod = orgMethod;
        this.boundMethodId = boundMethodId;
    }

    @Override
    public boolean transform() {
        MethodNode method = this.getMethod(this.orgMethod);
        if ((method.access & 0x400) != 0) {
            return false;
        }
        InsnList newInstructions = new InsnList();
        LabelNode start = new LabelNode();
        newInstructions.add((AbstractInsnNode)start);
        Type[] args = Type.getArgumentTypes((String)method.desc);
        if (this.orgMethod.getName().equals("<init>")) {
            int last = method.instructions.size();
            LabelNode callAll = new LabelNode();
            boolean hasGenerated = true;
            int i = 0;
            while (i < last) {
                AbstractInsnNode returnCandidate = method.instructions.get(i);
                if (returnCandidate.getOpcode() == 177) {
                    method.instructions.set(returnCandidate, (AbstractInsnNode)callAll);
                    this.generateInvocation(method, args, (AbstractInsnNode)callAll, newInstructions);
                    hasGenerated = true;
                }
                ++i;
            }
            if (!hasGenerated) {
                throw new IllegalStateException("Insertion point for weaving into ctor not found!!!");
            }
        } else {
            method.instructions.clear();
            this.generateInvocation(method, args, null, newInstructions);
        }
        this.addCatchSneakyException(method, start);
        int localSlots = 0;
        int maxArgSize = 1;
        Type[] typeArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            int size = type.getSize();
            localSlots += size;
            if (size == 2) {
                maxArgSize = 2;
            }
            ++n2;
        }
        method.maxStack = args.length > 0 ? 5 + maxArgSize : 3;
        method.maxLocals = localSlots + 1;
        return true;
    }

    private void generateInvocation(MethodNode method, Type[] args, AbstractInsnNode insertBefore, InsnList newInstructions) {
        newInstructions.add((AbstractInsnNode)new IntInsnNode(25, 0));
        newInstructions.add(this.createLoadIntConstant(this.boundMethodId));
        if (method.name.equals("<init>")) {
            newInstructions.add(this.createLoadIntConstant(-1));
            newInstructions.add(this.createLoadIntConstant(Integer.MAX_VALUE));
            newInstructions.add((AbstractInsnNode)new InsnNode(130));
            newInstructions.add((AbstractInsnNode)new InsnNode(128));
        }
        newInstructions.add(this.getBoxingInstructions(args, false));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, this.name, ConstantMembers.callAllBindingsClient.getName(), ConstantMembers.callAllBindingsClient.getSignature(), false));
        Type returnType = Type.getReturnType((String)method.desc);
        newInstructions.add(this.getUnboxingInstructionsForReturnValue(returnType));
        if (insertBefore != null) {
            method.instructions.insertBefore(insertBefore, newInstructions);
            method.instructions.remove(insertBefore);
        } else {
            method.instructions.add(newInstructions);
        }
    }

    void addCatchSneakyException(MethodNode method, LabelNode start) {
        method.tryCatchBlocks.add(this.getCatchBlock(method.instructions, start, this.orgMethod));
    }

    TryCatchBlockNode getCatchBlock(InsnList instructions, LabelNode start, Method method) {
        LabelNode end = new LabelNode();
        instructions.add((AbstractInsnNode)end);
        LabelNode catchSneaky = new LabelNode();
        instructions.add((AbstractInsnNode)catchSneaky);
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, ClassNames.SNEAKY_EXCEPTION_SLASH, "rethrow", "()V", false));
        Type returnType = Type.getReturnType((String)method.getSignature());
        instructions.add(this.getReturnInsn(returnType));
        return new TryCatchBlockNode(start, end, catchSneaky, ClassNames.SNEAKY_EXCEPTION_SLASH);
    }

    protected InsnList getReturnInsn(Type returnType) {
        InsnList instructions = new InsnList();
        switch (returnType.getSort()) {
            case 0: {
                instructions.add((AbstractInsnNode)new InsnNode(177));
                break;
            }
            case 9: 
            case 10: {
                instructions.add((AbstractInsnNode)new InsnNode(1));
                instructions.add((AbstractInsnNode)new InsnNode(176));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                instructions.add((AbstractInsnNode)new InsnNode(3));
                instructions.add((AbstractInsnNode)new InsnNode(172));
                break;
            }
            case 8: {
                instructions.add((AbstractInsnNode)new InsnNode(14));
                instructions.add((AbstractInsnNode)new InsnNode(175));
                break;
            }
            case 6: {
                instructions.add((AbstractInsnNode)new InsnNode(11));
                instructions.add((AbstractInsnNode)new InsnNode(174));
            }
        }
        return instructions;
    }
}

