/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WeavableRegionReader {
    private static final String WEAVABLE_FILE = System.getProperty("ot.weavable");
    private static final String COMMENT_MARKER = "#";
    private static List<String> weavablePrefixes = null;

    public static boolean isWeavable(String className) {
        WeavableRegionReader.ensureInitialized();
        if (weavablePrefixes.isEmpty()) {
            return true;
        }
        for (String prefix : weavablePrefixes) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static synchronized void ensureInitialized() {
        if (weavablePrefixes == null) {
            weavablePrefixes = WeavableRegionReader.readWeavablePrefixes();
        }
    }

    private static List<String> readWeavablePrefixes() {
        ArrayList<String> result;
        block14: {
            if (WEAVABLE_FILE == null) {
                return Collections.emptyList();
            }
            result = new ArrayList<String>();
            BufferedReader in = null;
            try {
                try {
                    FileInputStream fstream = new FileInputStream(WEAVABLE_FILE);
                    in = new BufferedReader(new InputStreamReader(fstream));
                    while (in.ready()) {
                        String nextLine = in.readLine();
                        String nextTeam = nextLine.trim();
                        if (nextTeam.startsWith(COMMENT_MARKER) || nextTeam.equals("")) continue;
                        result.add(nextTeam.trim());
                    }
                }
                catch (Exception e) {
                    System.err.println("File input error: weavable file '" + WEAVABLE_FILE + "' can not be found!");
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }
}

