/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.AbstractGenModelHelper;
import org.eclipse.ocl.examples.codegen.generator.CodeGenOptions;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.CG2JavaVisitor;
import org.eclipse.ocl.examples.codegen.java.Id2JavaExpressionVisitor;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.types.EObjectDescriptor;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.xtext.util.Strings;

public class JavaStream {
    protected @NonNull JavaCodeGenerator codeGenerator;
    protected @NonNull CG2JavaVisitor<@NonNull ?> cg2java;
    protected @NonNull CodeGenAnalyzer analyzer;
    protected final @NonNull Id2JavaExpressionVisitor id2JavaExpressionVisitor;
    protected final boolean useNullAnnotations;
    protected final boolean suppressNullWarnings;
    private @NonNull StringBuilder s = new StringBuilder();
    private @NonNull Stack<String> indentationStack = new Stack();
    private @NonNull String defaultIndentationString = "    ";

    public static @NonNull String convertToJavaIdentifier(@NonNull String theString) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        boolean isStart = true;
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (isStart ? Character.isJavaIdentifierStart(aChar) : Character.isJavaIdentifierPart(aChar)) {
                outBuffer.append(aChar);
                isStart = false;
            } else {
                outBuffer.append("_");
                outBuffer.append((int)aChar);
                isStart = true;
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PrettyPrintOptions.Global createOptions(@NonNull Visitable element) {
        ResourceSet asResourceSet;
        Resource asResource;
        Namespace scope = null;
        if (element instanceof EObject) {
            Object eObject = (EObject)element;
            while (eObject != null) {
                if (eObject instanceof Model) break;
                if (eObject instanceof Type) {
                    scope = (Namespace)eObject;
                    break;
                }
                if (eObject instanceof Package) {
                    scope = (Namespace)eObject;
                    break;
                }
                eObject = eObject instanceof ExpressionInOCL && ((ExpressionInOCL)eObject).getOwnedContext() != null ? ((ExpressionInOCL)eObject).getOwnedContext().getType() : eObject.eContainer();
            }
        }
        PrettyPrintOptions.Global createOptions = PrettyPrinter.createOptions(scope);
        createOptions.setLinelength(80);
        if (element instanceof EObject && (asResource = EcoreUtil.getRootContainer((EObject)((EObject)element)).eResource()) != null && (asResourceSet = asResource.getResourceSet()) != null) {
            PivotMetamodelManager metamodelManager = PivotMetamodelManager.getAdapter((ResourceSet)asResourceSet);
            createOptions.setEnvironmentFactory((EnvironmentFactory)metamodelManager.getEnvironmentFactory());
        }
        return createOptions;
    }

    public JavaStream(@NonNull JavaCodeGenerator codeGenerator, @NonNull CG2JavaVisitor<@NonNull ?> cg2java) {
        this.codeGenerator = codeGenerator;
        this.cg2java = cg2java;
        this.analyzer = codeGenerator.getAnalyzer();
        this.id2JavaExpressionVisitor = cg2java.createId2JavaExpressionVisitor(this);
        CodeGenOptions options = codeGenerator.getOptions();
        this.useNullAnnotations = options.useNullAnnotations();
        this.suppressNullWarnings = this.useNullAnnotations && options.suppressNonNullWarningsForEMFCollections();
    }

    public void append(@Nullable String string) {
        if (string != null) {
            if (this.indentationStack.isEmpty()) {
                this.s.append(string);
            } else {
                int sLength = this.s.length();
                boolean atStartOfLine = sLength == 0 || this.s.charAt(sLength - 1) == '\n';
                int i = 0;
                while (i < string.length()) {
                    char c = string.charAt(i);
                    if (c != '\r') {
                        if (atStartOfLine) {
                            atStartOfLine = false;
                            this.s.append(this.indentationStack.peek());
                        }
                        this.s.append(c);
                        atStartOfLine = c == '\n';
                    }
                    ++i;
                }
            }
        }
    }

    public boolean appendAssignment(@NonNull CGValuedElement toVariable, @NonNull CGValuedElement cgExpression) {
        CGInvalid cgInvalidValue = cgExpression.getInvalidValue();
        if (cgInvalidValue != null) {
            this.append("throw ");
            this.appendValueName(cgInvalidValue);
            this.append(";\n");
            return false;
        }
        TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(toVariable);
        if (!this.appendLocalStatements(cgExpression)) {
            return false;
        }
        this.appendValueName(toVariable);
        this.append(" = ");
        this.appendReferenceTo(typeDescriptor, cgExpression);
        this.append(";\n");
        return true;
    }

    public void appendAtomicReferenceTo(@NonNull java.lang.Class<?> requiredClass, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendAtomicReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            java.lang.Class<?> actualClass = actualTypeDescriptor.getJavaClass();
            if (cgValue.getNamedValue().isCaught() || !requiredClass.isAssignableFrom(actualClass)) {
                this.append("((");
                this.appendClassReference(requiredClass.getName());
                this.append(")");
                this.appendValueName(cgValue);
                this.append(")");
            } else {
                this.appendValueName(cgValue);
            }
        }
    }

    public void appendAtomicReferenceTo(@NonNull TypeDescriptor requiredTypeDescriptor, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendAtomicReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (cgValue.getNamedValue().isCaught() || !requiredTypeDescriptor.isAssignableFrom(actualTypeDescriptor)) {
                this.append("(");
                requiredTypeDescriptor.appendCast(this, null, null);
                this.appendValueName(cgValue);
                this.append(")");
            } else {
                this.appendValueName(cgValue);
            }
        }
    }

    public void appendAtomicReferenceTo(@Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendAtomicReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (cgValue.getNamedValue().isCaught()) {
                this.append("(");
                actualTypeDescriptor.appendCast(this, null, null);
                this.appendValueName(cgValue);
                this.append(")");
            } else {
                this.appendValueName(cgValue);
            }
        }
    }

    public void appendBooleanString(boolean isTrue) {
        this.append(isTrue ? "true" : "false");
    }

    public void appendBooleanValueName(@NonNull CGValuedElement cgValue, boolean isTrue) {
        @NonNull TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
        if (cgValue.isCaught() || cgValue.getNamedValue().isCaught() || typeDescriptor.getJavaClass() == Object.class) {
            this.appendValueName(cgValue);
            this.append(" == ");
            this.append(isTrue ? "Boolean.TRUE" : "Boolean.FALSE");
        } else {
            if (!isTrue) {
                this.append("!");
            }
            this.appendValueName(cgValue);
        }
    }

    public void appendClassCast(@Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendClassCast>>");
        } else {
            @NonNull TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            typeDescriptor.appendCast(this, null, null);
        }
    }

    public void appendClassCast(@Nullable CGValuedElement cgValue, @Nullable java.lang.Class<?> actualJavaClass) {
        if (cgValue == null) {
            this.append("<<null-appendClassCast>>");
        } else {
            @NonNull TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            java.lang.Class<?> requiredJavaClass = typeDescriptor.getJavaClass();
            if (actualJavaClass == null || !requiredJavaClass.isAssignableFrom(actualJavaClass)) {
                typeDescriptor.appendCast(this, actualJavaClass, null);
            }
        }
    }

    public void appendClassCast(@NonNull CGValuedElement cgValue, @Nullable java.lang.Class<?> actualJavaClass, @NonNull SubStream subStream) {
        @NonNull TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
        java.lang.Class<?> requiredJavaClass = typeDescriptor.getJavaClass();
        if (actualJavaClass == null || !requiredJavaClass.isAssignableFrom(actualJavaClass)) {
            typeDescriptor.appendCast(this, actualJavaClass, subStream);
        } else {
            subStream.append();
        }
    }

    public void appendClassHeader(@Nullable CGPackage cgPackage) {
        this.appendCopyrightHeader();
        if (cgPackage != null) {
            this.append("package ");
            this.appendClassHeaderInternal(cgPackage);
            this.append(";\n");
        }
        this.append("\n");
        this.append("<%**imports**%>\n");
    }

    private void appendClassHeaderInternal(@NonNull CGPackage cgPackage) {
        CGPackage cgParentPackage = cgPackage.getContainingPackage();
        if (cgParentPackage != null) {
            this.appendClassHeaderInternal(cgParentPackage);
            this.append(".");
        }
        this.append(String.valueOf(cgPackage.getName()));
    }

    public void appendClassReference(@Nullable Boolean isRequired, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null->>");
        } else if (cgValue.getNamedValue().isCaught()) {
            if (isRequired != null) {
                this.appendIsRequired(isRequired);
                this.append(" ");
            }
            this.appendClassReference(Object.class);
        } else {
            TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (cgValue instanceof CGParameter && cgValue.eContainer() instanceof CGOperation && typeDescriptor instanceof EObjectDescriptor) {
                java.lang.Class<?> originalJavaClass = ((EObjectDescriptor)typeDescriptor).getOriginalJavaClass();
                this.appendClassReference(isRequired, originalJavaClass);
            } else {
                typeDescriptor.append(this, isRequired);
            }
        }
    }

    public void appendClassReference(@Nullable java.lang.Class<?> javaClass) {
        this.appendClassReference((Boolean)null, javaClass);
    }

    public void appendClassReference(@Nullable Boolean isRequired, @Nullable java.lang.Class<?> javaClass) {
        if (javaClass != null) {
            this.appendClassReference(isRequired, javaClass.getName());
            TypeVariable<java.lang.Class<?>>[] typeParameters = javaClass.getTypeParameters();
            if (typeParameters.length > 0) {
                this.append("<");
                int i = 0;
                while (i < typeParameters.length) {
                    if (i != 0) {
                        this.append(",");
                    }
                    this.append("?");
                    ++i;
                }
                this.append(">");
            }
        } else {
            if (isRequired != null) {
                this.appendIsRequired(isRequired);
                this.append(" ");
            }
            this.appendClassReference(Object.class);
        }
    }

    public void appendClassReference(@NonNull TypeDescriptor typeDescriptor) {
        this.appendClassReference(null, typeDescriptor);
    }

    public void appendClassReference(@Nullable Boolean isRequired, @NonNull TypeDescriptor typeDescriptor) {
        typeDescriptor.append(this, isRequired);
    }

    public void appendClassReference(@Nullable java.lang.Class<?> javaClass, java.lang.Class<?> ... typeParameters) {
        if (javaClass != null) {
            this.appendClassReference(javaClass.getName());
            this.appendTypeParameters(false, typeParameters);
        } else {
            this.appendClassReference(Object.class);
        }
    }

    public void appendClassReference(@Nullable java.lang.Class<?> javaClass, boolean useExtends, java.lang.Class<?> ... typeParameters) {
        if (javaClass != null) {
            this.appendClassReference(javaClass.getName());
            this.appendTypeParameters(useExtends, typeParameters);
        } else {
            this.appendClassReference(Object.class);
        }
    }

    public void appendClassReference(@Nullable java.lang.Class<?> javaClass, boolean useExtends, String ... typeParameters) {
        if (javaClass != null) {
            this.appendClassReference(javaClass.getName());
            this.appendTypeParameters(useExtends, typeParameters);
        } else {
            this.appendClassReference(Object.class);
        }
    }

    @Deprecated
    public void appendClassReference(java.lang.Class<?> javaClass, boolean useExtends, TypeDescriptor ... typeDescriptors) {
        this.appendClassReference(null, javaClass, useExtends, typeDescriptors);
    }

    public void appendClassReference(Boolean isRequired, java.lang.Class<?> javaClass, boolean useExtends, TypeDescriptor ... typeDescriptors) {
        if (javaClass != null) {
            this.appendClassReference(isRequired, javaClass.getName());
            if (typeDescriptors.length > 0) {
                this.append("<");
                int i = 0;
                while (i < typeDescriptors.length) {
                    if (i != 0) {
                        this.append(",");
                    }
                    if (useExtends) {
                        this.append("? extends ");
                    }
                    TypeDescriptor typeDescriptor = typeDescriptors[i];
                    typeDescriptor.append(this, null);
                    ++i;
                }
                this.append(">");
            }
        } else {
            this.appendClassReference(Object.class);
        }
    }

    public void appendClassReference(@Nullable String className) {
        this.appendClassReference(null, className);
    }

    public void appendClassReference(@Nullable Boolean isRequired, @Nullable String className) {
        if (className != null) {
            StringBuilder s = new StringBuilder();
            int dollar = className.indexOf("$");
            if (dollar > 0) {
                @NonNull String importClassName = className.substring(0, dollar);
                s.append(ImportUtils.getAffixedName(importClassName));
                this.cg2java.addImport(importClassName);
                s.append(className.substring(dollar).replace('$', '.'));
            } else if (className.contains(".")) {
                s.append(ImportUtils.getAffixedName(className));
                this.cg2java.addImport(className);
            } else {
                s.append(className);
            }
            String resolvedClassName = s.toString();
            if (isRequired == null || !this.useNullAnnotations) {
                this.append(resolvedClassName);
            } else {
                String annotation = "@" + (isRequired != false ? NonNull.class : Nullable.class).getName() + " ";
                int index = resolvedClassName.lastIndexOf(".");
                if (index < 0) {
                    this.append(String.valueOf(annotation) + resolvedClassName);
                } else {
                    this.append(String.valueOf(resolvedClassName.substring(0, index + 1)) + annotation + resolvedClassName.substring(index + 1));
                }
            }
        }
    }

    public void appendClassReference(@NonNull CGClass cgClass) {
        CGPackage cgPackage = cgClass.getContainingPackage();
        String packageName = cgPackage.getName();
        if (packageName != null) {
            this.appendClassReference(String.valueOf(packageName) + "." + cgClass.getName());
            List<CGClass> cgTemplateParameters = cgClass.getTemplateParameters();
            if (cgTemplateParameters.size() > 0) {
                this.append("<");
                boolean isFirst = true;
                for (CGClass cgTemplateParameter : cgTemplateParameters) {
                    if (!isFirst) {
                        this.append(", ");
                    }
                    if (cgTemplateParameter != null) {
                        this.appendClassReference(cgTemplateParameter);
                    } else {
                        this.append("?");
                    }
                    isFirst = false;
                }
                this.append(">");
            }
        } else {
            this.append(cgClass.getName());
        }
    }

    public void appendCommentWithOCL(@Nullable String title, @Nullable Element element) {
        this.append("/**\n");
        this.pushIndentation(" * ");
        if (title != null) {
            this.append(String.valueOf(title) + "\n");
        }
        if (element != null) {
            PrettyPrintOptions.Global createOptions = JavaStream.createOptions((Visitable)element);
            this.append(String.valueOf(PrettyPrinter.print((Element)element, (PrettyPrintOptions)createOptions).replace("*/", "* /")) + "\n");
        }
        this.popIndentation();
        this.append(" */\n");
    }

    public void appendCopyrightHeader() {
        this.append("/*******************************************************************************\n");
        this.pushIndentation(" *");
        this.append(" \u00abcodeGenHelper.getCopyright(' * ')\u00bb\n");
        this.append("\n");
        this.append(" This code is 100% auto-generated\n");
        this.append(" using: " + this.getCodeGenerator().getClass().getName() + "\n");
        this.append("\n");
        this.append(" Do not edit it.\n");
        this.append("*******************************************************************************/\n");
        this.popIndentation();
        this.append("\n");
    }

    public void appendDeclaration(@NonNull CGValuedElement cgElement) {
        boolean isGlobal = cgElement.isGlobal();
        if (isGlobal) {
            this.append("public static ");
        }
        if (!cgElement.isSettable()) {
            this.append("final ");
        }
        this.appendTypeDeclaration(cgElement);
        this.append(" ");
        String valueName = this.cg2java.getValueName(cgElement);
        this.append(valueName);
    }

    public void appendEcoreValue(@NonNull String returnClassName, @NonNull CGValuedElement cgValue) {
        TypeDescriptor javaTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
        java.lang.Class<?> javaClass = javaTypeDescriptor.hasJavaClass();
        if (cgValue.getNamedValue() instanceof CGParameter) {
            this.appendValueName(cgValue);
        } else if (javaClass == null) {
            this.append("(");
            this.appendClassReference(returnClassName);
            this.append(")");
            this.appendValueName(cgValue);
        } else if (!returnClassName.equals(javaClass.getName())) {
            if (javaClass == Boolean.class) {
                this.appendValueName(cgValue);
            } else if (javaClass == Number.class) {
                if ("java.math.BigDecimal".equals(returnClassName)) {
                    this.appendClassReference(ValueUtil.class);
                    this.append(".bigDecimalValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else if ("java.math.BigInteger".equals(returnClassName)) {
                    this.appendClassReference(ValueUtil.class);
                    this.append(".bigIntegerValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else if ("char".equals(returnClassName)) {
                    this.append("(char)");
                    this.appendAtomicReferenceTo(cgValue);
                    this.append(".intValue()");
                } else if ("java.lang.Character".equals(returnClassName)) {
                    this.appendClassReference(Character.class);
                    this.append(".valueOf((char)");
                    this.appendAtomicReferenceTo(cgValue);
                    this.append(".intValue())");
                } else if ("java.lang.Double".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".doubleValue()");
                } else if ("java.lang.Float".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".floatValue()");
                } else if ("java.lang.Integer".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".intValue()");
                } else if ("java.lang.Long".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".longValue()");
                } else if ("java.lang.Short".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".shortValue()");
                } else if ("double".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".doubleValue()");
                } else if ("float".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".floatValue()");
                } else if ("int".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".intValue()");
                } else if ("long".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".longValue()");
                } else if ("short".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".shortValue()");
                } else {
                    this.appendValueName(cgValue);
                }
            } else if (javaClass == Object.class) {
                if ("java.math.BigDecimal".equals(returnClassName)) {
                    this.appendClassReference(ValueUtil.class);
                    this.append(".bigDecimalValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else if ("java.math.BigInteger".equals(returnClassName)) {
                    this.appendClassReference(ValueUtil.class);
                    this.append(".bigIntegerValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else if ("char".equals(returnClassName) || "java.lang.Character".equals(returnClassName)) {
                    this.appendClassReference(ValueUtil.class);
                    this.append(".characterValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else if ("java.lang.Double".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".doubleValue()");
                } else if ("java.lang.Float".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".floatValue()");
                } else if ("java.lang.Integer".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".intValue()");
                } else if ("java.lang.Long".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".longValue()");
                } else if ("java.lang.Short".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".shortValue()");
                } else if ("double".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".doubleValue()");
                } else if ("float".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".floatValue()");
                } else if ("int".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".intValue()");
                } else if ("long".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".longValue()");
                } else if ("short".equals(returnClassName)) {
                    this.appendAtomicReferenceTo(Number.class, cgValue);
                    this.append(".shortValue()");
                } else {
                    this.appendValueName(cgValue);
                }
            } else {
                this.append("(");
                this.appendClassReference(returnClassName);
                this.append(")");
                this.appendValueName(cgValue);
            }
        } else {
            this.appendValueName(cgValue);
        }
    }

    public void appendFalse() {
        this.appendClassReference(ValueUtil.class);
        this.append(".FALSE_VALUE");
    }

    public void appendIdReference(@Nullable ElementId elementId) {
        if (elementId == null) {
            this.append("<<null-appendIdReference>>");
        } else if (CGUtil.isInlinedId(elementId)) {
            elementId.accept((IdVisitor)this.id2JavaExpressionVisitor);
        } else {
            this.appendValueName(this.analyzer.getElementId(elementId));
        }
    }

    public void appendIdReference2(@NonNull ElementId elementId) {
        elementId.accept((IdVisitor)this.id2JavaExpressionVisitor);
    }

    public void appendIsCaught(boolean isNonInvalid, boolean isCaught) {
        this.append("/*");
        this.append(isNonInvalid ? "@NonInvalid" : (isCaught ? "@Caught" : "@Thrown"));
        this.append("*/");
    }

    public void appendIsRequired(boolean isRequired) {
        if (!this.useNullAnnotations) {
            this.append("/*");
            this.append(isRequired ? "@NonNull" : "@Nullable");
            this.append("*/");
        } else {
            this.append("@");
            this.appendClassReference(isRequired ? "org.eclipse.jdt.annotation.NonNull" : "org.eclipse.jdt.annotation.Nullable");
        }
    }

    public boolean appendLocalStatements(@NonNull CGValuedElement cgElement) {
        if (!cgElement.isInlined() && !cgElement.isGlobal()) {
            return cgElement.accept(this.cg2java) == Boolean.TRUE;
        }
        return true;
    }

    public void appendQualifiedLiteralName(@NonNull Operation anOperation) {
        GenPackage genPackage;
        Class type = anOperation.getOwningClass();
        if (type != null && (genPackage = this.codeGenerator.getGenModelHelper().getGenPackage(type)) != null) {
            String qualifiedPackageName = String.valueOf(genPackage.getQualifiedPackageName());
            String tablesClassName = String.valueOf(genPackage.getPrefix()) + "Tables";
            this.appendClassReference(String.valueOf(qualifiedPackageName) + "." + tablesClassName);
            this.append(".Operations._" + type.getName() + "__" + AbstractGenModelHelper.encodeName((NamedElement)anOperation));
        }
    }

    public void appendReferenceTo(@NonNull java.lang.Class<?> requiredClass, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (cgValue.getNamedValue().isCaught() || !actualTypeDescriptor.isAssignableTo(requiredClass)) {
                this.append("(");
                this.appendClassReference(requiredClass.getName());
                this.append(")");
            }
            this.appendValueName(cgValue);
        }
    }

    public void appendReferenceTo(@NonNull TypeDescriptor requiredTypeDescriptor, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendReferenceTo>>");
        } else {
            boolean isCaught;
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (!(cgValue.isNull() || !(isCaught = cgValue.getNamedValue().isCaught()) && requiredTypeDescriptor.isAssignableFrom(actualTypeDescriptor))) {
                requiredTypeDescriptor.appendCast(this, isCaught ? null : actualTypeDescriptor.getJavaClass(), null);
            }
            this.appendValueName(cgValue);
        }
    }

    public void appendReferenceTo(@Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendReferenceTo>>");
        } else {
            if (cgValue.getNamedValue().isCaught()) {
                TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
                this.append("(");
                actualTypeDescriptor.append(this, null);
                this.append(")");
            }
            this.appendValueName(cgValue);
        }
    }

    public void appendString(@NonNull String string) {
        @NonNull String javaString = Strings.convertToJavaString((String)string);
        this.append("\"");
        this.append(javaString);
        this.append("\"");
    }

    public boolean appendThrowBooleanInvalidValueException(String message, String ... arguments) {
        this.appendClassReference(ValueUtil.class);
        this.append(".throwBooleanInvalidValueException(");
        this.appendString((String)ClassUtil.nonNullState((Object)message));
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            this.append(", ");
            this.appendString((String)ClassUtil.nonNullState((Object)argument));
            ++n2;
        }
        this.append(");\n");
        return false;
    }

    public boolean appendThrowInvalidValueException(String message, String ... arguments) {
        this.append("throw new ");
        this.appendClassReference(InvalidValueException.class);
        this.append("(");
        this.appendString((String)ClassUtil.nonNullState((Object)message));
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            this.append(", ");
            this.appendString((String)ClassUtil.nonNullState((Object)argument));
            ++n2;
        }
        this.append(");\n");
        return false;
    }

    public void appendTrue() {
        this.appendClassReference(ValueUtil.class);
        this.append(".TRUE_VALUE");
    }

    public void appendTypeDeclaration(@NonNull CGValuedElement cgElement) {
        boolean isPrimitive = this.isPrimitive(cgElement);
        boolean isRequired = !isPrimitive && !cgElement.isAssertedNonNull() && cgElement.isNonNull() && !(cgElement instanceof CGUnboxExp);
        this.appendIsCaught(cgElement.isNonInvalid(), cgElement.isCaught());
        this.append(" ");
        this.appendClassReference(isPrimitive ? null : Boolean.valueOf(isRequired), cgElement);
    }

    public void appendTypeParameters(boolean useExtends, java.lang.Class<?> ... typeParameters) {
        if (typeParameters.length > 0) {
            this.append("<");
            int i = 0;
            while (i < typeParameters.length) {
                if (i != 0) {
                    this.append(",");
                }
                if (useExtends) {
                    this.append("? extends ");
                }
                this.appendClassReference(typeParameters[i]);
                ++i;
            }
            this.append(">");
        }
    }

    public void appendTypeParameters(boolean useExtends, String ... typeParameters) {
        if (typeParameters.length > 0) {
            this.append("<");
            int i = 0;
            while (i < typeParameters.length) {
                if (i != 0) {
                    this.append(",");
                }
                if (useExtends) {
                    this.append("? extends ");
                }
                this.appendClassReference(typeParameters[i]);
                ++i;
            }
            this.append(">");
        }
    }

    public void appendValueName(@Nullable CGValuedElement cgElement) {
        if (cgElement == null) {
            this.append("<<null-appendValueName>>");
        } else if (cgElement.isInlined()) {
            cgElement.accept(this.cg2java);
        } else {
            if (cgElement.isGlobal()) {
                this.cg2java.appendGlobalPrefix();
            }
            String valueName = this.cg2java.getValueName(cgElement);
            this.append(valueName);
        }
    }

    public @NonNull CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    protected @NonNull String getValueName(@NonNull CGValuedElement cgElement) {
        String name = cgElement.getValueName();
        if (name == null) {
            name = cgElement.getName();
        }
        if (name == null) {
            name = "<null-" + cgElement.eClass().getName() + ">";
        }
        return name;
    }

    @Deprecated
    public boolean is_boolean(@NonNull CGValuedElement cgValue) {
        if (cgValue.getNamedValue().isCaught()) {
            return false;
        }
        TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
        java.lang.Class<?> javaClass = typeDescriptor.getJavaClass();
        return javaClass == Boolean.TYPE || javaClass == Boolean.class && cgValue.isNonNull();
    }

    public boolean isUseNullAnnotations() {
        return this.useNullAnnotations;
    }

    public boolean isPrimitive(@NonNull CGValuedElement cgValue) {
        if (cgValue.getNamedValue().isCaught()) {
            return false;
        }
        TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
        java.lang.Class<?> javaClass = typeDescriptor.getJavaClass();
        if (javaClass == Boolean.TYPE || javaClass == Boolean.class && cgValue.isNonNull()) {
            return true;
        }
        if (javaClass == Byte.TYPE || javaClass == Byte.class && cgValue.isNonNull()) {
            return true;
        }
        if (javaClass == Character.TYPE || javaClass == Character.class && cgValue.isNonNull()) {
            return true;
        }
        if (javaClass == Double.TYPE || javaClass == Double.class && cgValue.isNonNull()) {
            return true;
        }
        if (javaClass == Float.TYPE || javaClass == Float.class && cgValue.isNonNull()) {
            return true;
        }
        if (javaClass == Integer.TYPE || javaClass == Integer.class && cgValue.isNonNull()) {
            return true;
        }
        if (javaClass == Long.TYPE || javaClass == Long.class && cgValue.isNonNull()) {
            return true;
        }
        return javaClass == Short.TYPE || javaClass == Short.class && cgValue.isNonNull();
    }

    public int length() {
        return this.s.length();
    }

    public void popIndentation() {
        this.indentationStack.pop();
    }

    public void pushIndentation(@Nullable String extraIndentation) {
        if (extraIndentation == null) {
            extraIndentation = this.defaultIndentationString;
        }
        if (this.indentationStack.isEmpty()) {
            this.indentationStack.push(extraIndentation);
        } else {
            this.indentationStack.push(String.valueOf(this.indentationStack.peek()) + extraIndentation);
        }
    }

    public void resetStream() {
        this.s.setLength(0);
    }

    public @NonNull String toString() {
        return this.s.toString();
    }

    public static interface SubStream {
        public void append();
    }
}

