/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.core;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.RepositoryType;
import org.eclipse.oomph.p2.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryProviderMap<M extends IRepositoryManager<T>, R extends IRepository<T>, T, P extends RepositoryProvider<M, R, T>> {
    private final Map<URI, P> providers = new HashMap<URI, P>();
    private final M repositoryManager;

    public RepositoryProviderMap(M repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public final M getRepositoryManager() {
        return this.repositoryManager;
    }

    public final P getRepositoryProvider(URI location) {
        RepositoryProvider provider = (RepositoryProvider)this.providers.get(location);
        if (provider == null) {
            provider = this.createProvider(location);
        }
        return (P)provider;
    }

    public final synchronized R getRepository(URI location) {
        P provider = this.getRepositoryProvider(location);
        return ((RepositoryProvider)provider).getRepository();
    }

    public final synchronized R createRepository(URI location, String name, String type, Map<String, String> properties) {
        P provider = this.createProvider(location);
        return ((RepositoryProvider)provider).createRepository(name, type, properties);
    }

    public final P removeAllContent(URI location, IProgressMonitor monitor) {
        P provider = this.getRepositoryProvider(location);
        ((RepositoryProvider)provider).removeAllContent(monitor);
        return provider;
    }

    public final P dispose(URI location) {
        RepositoryProvider provider = (RepositoryProvider)this.providers.remove(location);
        if (provider != null) {
            provider.dispose();
        }
        return (P)provider;
    }

    public final void dispose() {
        for (RepositoryProvider provider : this.providers.values()) {
            provider.dispose();
        }
        this.providers.clear();
    }

    public abstract RepositoryType getRepositoryType();

    protected abstract P createProvider(M var1, URI var2);

    private P createProvider(URI location) {
        this.dispose(location);
        P provider = this.createProvider(this.repositoryManager, location);
        this.providers.put(location, provider);
        return provider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Artifact
    extends RepositoryProviderMap<IArtifactRepositoryManager, IArtifactRepository, IArtifactKey, RepositoryProvider.Artifact> {
        public Artifact(IArtifactRepositoryManager repositoryManager) {
            super(repositoryManager);
        }

        @Override
        public RepositoryType getRepositoryType() {
            return RepositoryType.ARTIFACT;
        }

        @Override
        protected RepositoryProvider.Artifact createProvider(IArtifactRepositoryManager repositoryManager, URI location) {
            return new RepositoryProvider.Artifact(repositoryManager, location);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Metadata
    extends RepositoryProviderMap<IMetadataRepositoryManager, IMetadataRepository, IInstallableUnit, RepositoryProvider.Metadata> {
        public Metadata(IMetadataRepositoryManager repositoryManager) {
            super(repositoryManager);
        }

        @Override
        public RepositoryType getRepositoryType() {
            return RepositoryType.METADATA;
        }

        @Override
        protected RepositoryProvider.Metadata createProvider(IMetadataRepositoryManager repositoryManager, URI location) {
            return new RepositoryProvider.Metadata(repositoryManager, location);
        }
    }
}

