/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.palette.proxies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.papyrus.customization.palette.dialog.PaletteAspectToolEntryProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteContainerProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteEntryProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteLocalDrawerProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteLocalSeparatorProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteLocalStackProxy;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.service.AspectCreationEntry;
import org.eclipse.papyrus.uml.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.uml.diagram.common.service.XMLPaletteDefinitionVisitor;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPaletteDefinitionProxyFactory
implements XMLPaletteDefinitionVisitor,
IPapyrusPaletteConstant {
    protected final Map<String, PaletteEntry> predefinedEntries;
    protected PaletteContainerProxy containerProxy;
    protected final Map<Node, IPaletteEntryProxy> registry;

    public XMLPaletteDefinitionProxyFactory(Map<String, PaletteEntry> predefinedEntries) {
        this.predefinedEntries = predefinedEntries;
        this.registry = new HashMap<Node, IPaletteEntryProxy>();
    }

    protected PaletteContainerProxy getParentProxy(Node node) {
        return (PaletteContainerProxy)this.registry.get(node.getParentNode());
    }

    public void onContent(Node node) {
        this.containerProxy = new PaletteContainerProxy(null);
        this.registry.put(node, this.containerProxy);
    }

    public void onDrawer(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        Node descriptionNode = node.getAttributes().getNamedItem("description");
        PaletteLocalDrawerProxy proxy = new PaletteLocalDrawerProxy(node.getAttributes().getNamedItem("name").getNodeValue(), node.getAttributes().getNamedItem("id").getNodeValue(), node.getAttributes().getNamedItem("iconpath").getNodeValue(), descriptionNode != null ? descriptionNode.getNodeValue() : "");
        this.getParentProxy(node).addChild(proxy);
        this.registry.put(node, proxy);
    }

    public void onSeparator(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteLocalSeparatorProxy proxy = new PaletteLocalSeparatorProxy(id);
        this.getParentProxy(node).addChild(proxy);
        this.registry.put(node, proxy);
    }

    public void onStack(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteLocalStackProxy proxy = new PaletteLocalStackProxy(id);
        this.getParentProxy(node).addChild(proxy);
        this.registry.put(node, proxy);
    }

    public void onToolEntry(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        PaletteEntryProxy proxy = new PaletteEntryProxy(entry);
        this.getParentProxy(node).addChild(proxy);
        this.registry.put(node, proxy);
    }

    public void onAspectToolEntry(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        PaletteEntry entry = this.predefinedEntries.get(id);
        if (entry instanceof AspectCreationEntry) {
            PaletteAspectToolEntryProxy proxy = new PaletteAspectToolEntryProxy((AspectCreationEntry)entry);
            this.getParentProxy(node).addChild(proxy);
            this.registry.put(node, proxy);
        } else {
            Activator.log.error("impossible to log class " + id, null);
        }
    }

    public PaletteContainerProxy getRootProxy() {
        return this.containerProxy;
    }
}

