/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.model.xwt.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.papyrus.customization.properties.model.xwt.Activator;
import org.eclipse.papyrus.customization.properties.model.xwt.format.XMLFormatter;
import org.eclipse.papyrus.customization.properties.model.xwt.modisco.GenericXMLResourceImpl;
import org.eclipse.papyrus.customization.properties.model.xwt.xwtxml.Root;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.ui.CompositeWidget;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesUtil;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;

public class XWTResource
extends ResourceImpl {
    private GenericXMLResourceImpl xmlResource;
    public static final String OPTION_FORMAT = "format";

    public XWTResource(URI uri) {
        super(uri);
        this.xmlResource = new GenericXMLResourceImpl(uri);
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.xmlResource.load(inputStream, options);
        Root root = (Root)this.xmlResource.getContents().get(0);
        try {
            CompositeWidget widget = this.xmlToUISection(root);
            if (widget == null) {
                Activator.log.warn("Cannot load the XWT Widget");
            } else {
                this.getContents().add((Object)widget);
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        if (options == null || options.isEmpty()) {
            HashMap<String, String> optionsMap = new HashMap<String, String>();
            optionsMap.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            super.save(optionsMap);
        } else {
            super.save(options);
        }
        Object formatValue = options.get(OPTION_FORMAT);
        if ((formatValue == null || formatValue == Boolean.TRUE) && this.uri.isPlatform()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.uri.toPlatformString(true)));
            XMLFormatter.format(file);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        try {
            if (this.getContents().isEmpty()) {
                Activator.log.warn("Cannot save an Empty XWT resource : " + this.getURI());
                return;
            }
            Root root = this.uiSectionToXML((CompositeWidget)this.getContents().get(0));
            this.xmlResource.getContents().clear();
            this.xmlResource.getContents().add((Object)root);
            this.xmlResource.save(outputStream, options);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    private Collection<Context> findContexts() {
        HashSet<Context> rootContexts = new HashSet<Context>();
        if (this.resourceSet == null) {
            return Collections.emptyList();
        }
        for (Resource resource : this.resourceSet.getResources()) {
            if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof Context)) continue;
            Context context = (Context)resource.getContents().get(0);
            rootContexts.add(context);
        }
        HashSet<Context> allContexts = new HashSet<Context>();
        for (Context context : rootContexts) {
            allContexts.addAll(PropertiesUtil.getDependencies((Context)context));
        }
        return allContexts;
    }

    private CompositeWidget xmlToUISection(Root genericXMLRoot) {
        URI transformationURI = URI.createPlatformPluginURI((String)"org.eclipse.papyrus.customization.properties.model.xwt/Transformation/XMLToUI.qvto", (boolean)true);
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        LinkedList<Context> contexts = new LinkedList<Context>(this.findContexts());
        ModelExtent inXml = this.getModelExtent(genericXMLRoot);
        ModelExtent inRoot = this.getModelExtent((EObject)ConfigurationManager.getInstance().getPropertiesRoot());
        BasicModelExtent inContexts = new BasicModelExtent(contexts);
        BasicModelExtent outUI = new BasicModelExtent();
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setLog(this.getLogger());
        context.setConfigProperty("keepModeling", (Object)true);
        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, new ModelExtent[]{inXml, inRoot, inContexts, outUI});
        if (result.getSeverity() == 0) {
            List outObjects = outUI.getContents();
            Object objectResult = outObjects.get(0);
            if (!(objectResult instanceof CompositeWidget)) {
                return null;
            }
            return (CompositeWidget)outObjects.get(0);
        }
        IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
        Activator.getDefault().getLog().log(status);
        Activator.log.error(status.getException());
        return null;
    }

    private Log getLogger() {
        return new Log(){

            public void log(int level, String message) {
                Activator.getDefault().getLog().log((IStatus)new Status(level, "org.eclipse.papyrus.customization.properties.model.xwt", message));
            }

            public void log(int level, String message, Object param) {
                this.log(level, message);
            }

            public void log(String message) {
                this.log(1, message);
            }

            public void log(String message, Object param) {
                this.log(message);
            }
        };
    }

    private Root uiSectionToXML(CompositeWidget widget) {
        URI transformationURI = URI.createPlatformPluginURI((String)"org.eclipse.papyrus.customization.properties.model.xwt/Transformation/UIToXML.qvto", (boolean)true);
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        ModelExtent inWidget = this.getModelExtent((EObject)widget);
        BasicModelExtent outXML = new BasicModelExtent();
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        context.setLog(this.getLogger());
        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, new ModelExtent[]{inWidget, outXML});
        if (result.getSeverity() == 0) {
            List outObjects = outXML.getContents();
            return (Root)outObjects.get(0);
        }
        IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
        Activator.getDefault().getLog().log(status);
        return null;
    }

    private ModelExtent getModelExtent(EObject source) {
        if (source == null) {
            return new BasicModelExtent();
        }
        BasicEList objects = new BasicEList();
        objects.add((Object)source);
        BasicModelExtent extent = new BasicModelExtent((List)objects);
        return extent;
    }
}

