/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css3.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ElementSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.FuncTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IdentifierTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.PseudoClassFunction;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.SimpleSelectorForNegation;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.URLType;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.UniversalSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.UrlTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.charset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_property;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.font_face;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.importExpression;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.keyframe_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.keyframes;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.media;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.page;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.simple_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.stylesheet;
import org.eclipse.papyrus.infra.gmfdiag.css3.formatting2.AbstractCSSFormatter;
import org.eclipse.papyrus.infra.gmfdiag.css3.services.CSSGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CSSFormatter
extends AbstractCSSFormatter {
    @Inject
    @Extension
    private CSSGrammarAccess _cSSGrammarAccess;

    protected void _format(stylesheet stylesheet2, @Extension IFormattableDocument document) {
        ITextRegionAccess _textRegionAccess = this.getTextRegionAccess();
        boolean _hasSyntaxError = _textRegionAccess.hasSyntaxError();
        if (_hasSyntaxError) {
            return;
        }
        charset _charset = stylesheet2.getCharset();
        this.format(_charset, document);
        EList<importExpression> _imports = stylesheet2.getImports();
        for (importExpression imports : _imports) {
            this.format(imports, document);
        }
        EList<ruleset> _ruleset = stylesheet2.getRuleset();
        for (ruleset ruleset2 : _ruleset) {
            this.format(ruleset2, document);
        }
        EList<media> _media = stylesheet2.getMedia();
        for (media media2 : _media) {
            this.format(media2, document);
        }
        EList<page> _page = stylesheet2.getPage();
        for (page page2 : _page) {
            this.format(page2, document);
        }
        EList<font_face> _font_face = stylesheet2.getFont_face();
        for (font_face font_face2 : _font_face) {
            this.format(font_face2, document);
        }
        EList<keyframes> _keyframes = stylesheet2.getKeyframes();
        for (keyframes keyframes2 : _keyframes) {
            this.format(keyframes2, document);
        }
    }

    protected void _format(page page2, @Extension IFormattableDocument document) {
        EList<css_declaration> _declarations = page2.getDeclarations();
        for (css_declaration declarations : _declarations) {
            this.format(declarations, document);
        }
    }

    protected void _format(media media2, @Extension IFormattableDocument document) {
        EList<ruleset> _rulesets = media2.getRulesets();
        for (ruleset rulesets : _rulesets) {
            this.format(rulesets, document);
        }
    }

    protected void _format(font_face font_face2, @Extension IFormattableDocument document) {
        EList<css_declaration> _declarations = font_face2.getDeclarations();
        for (css_declaration declarations : _declarations) {
            this.format(declarations, document);
        }
        EList<keyframe_selector> _keyframeselectors = font_face2.getKeyframeselectors();
        for (keyframe_selector keyframeselectors : _keyframeselectors) {
            this.format(keyframeselectors, document);
        }
    }

    protected void _format(keyframe_selector keyframe_selector2, @Extension IFormattableDocument document) {
        EList<css_declaration> _declarations = keyframe_selector2.getDeclarations();
        for (css_declaration declarations : _declarations) {
            this.format(declarations, document);
        }
    }

    protected void _format(ruleset ruleset2, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)ruleset2);
        ISemanticRegion _keyword = _regionFor.keyword("{");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        ISemanticRegion _prepend = document.prepend(_keyword, (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.newLine();
            }
        };
        document.append(_prepend, (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.indent();
            }
        };
        document.interior((EObject)ruleset2, (Procedures.Procedure1)_function_2);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)ruleset2);
        CSSGrammarAccess.RulesetElements _rulesetAccess = this._cSSGrammarAccess.getRulesetAccess();
        Keyword _semicolonKeyword_4_1_0 = _rulesetAccess.getSemicolonKeyword_4_1_0();
        CSSGrammarAccess.RulesetElements _rulesetAccess_1 = this._cSSGrammarAccess.getRulesetAccess();
        Keyword _semicolonKeyword_4_2 = _rulesetAccess_1.getSemicolonKeyword_4_2();
        List _keywords = _regionFor_1.keywords(new Keyword[]{_semicolonKeyword_4_1_0, _semicolonKeyword_4_2});
        for (ISemanticRegion semicolon : _keywords) {
            IHiddenRegion _nextHiddenRegion = semicolon.getNextHiddenRegion();
            Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.setNewLines(1);
                }
            };
            document.set(_nextHiddenRegion, (Procedures.Procedure1)_function_3);
        }
        ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)ruleset2);
        ISemanticRegion _keyword_1 = _regionFor_2.keyword("}");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.newLine();
            }
        };
        document.prepend(_keyword_1, (Procedures.Procedure1)_function_4);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_5 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.setNewLines(2);
            }
        };
        document.append((EObject)ruleset2, (Procedures.Procedure1)_function_5);
        EList<selector> _selectors = ruleset2.getSelectors();
        for (selector selectors : _selectors) {
            this.format(selectors, document);
        }
        EList<css_declaration> _declarations = ruleset2.getDeclarations();
        for (css_declaration declarations : _declarations) {
            this.format(declarations, document);
        }
    }

    protected void _format(selector selector2, @Extension IFormattableDocument document) {
        EList<simple_selector> _simpleselectors = selector2.getSimpleselectors();
        for (simple_selector simpleselectors : _simpleselectors) {
            this.format(simpleselectors, document);
        }
        selector _selector = selector2.getSelector();
        this.format(_selector, document);
    }

    protected void _format(SimpleSelectorForNegation simpleselectorfornegation, @Extension IFormattableDocument document) {
        ElementSelector _element = simpleselectorfornegation.getElement();
        this.format(_element, document);
        UniversalSelector _universal = simpleselectorfornegation.getUniversal();
        this.format(_universal, document);
        EList<CssSelector> _subSelectors = simpleselectorfornegation.getSubSelectors();
        for (CssSelector subSelectors : _subSelectors) {
            this.format(subSelectors, document);
        }
    }

    protected void _format(simple_selector simple_selector2, @Extension IFormattableDocument document) {
        ElementSelector _element = simple_selector2.getElement();
        this.format(_element, document);
        UniversalSelector _universal = simple_selector2.getUniversal();
        this.format(_universal, document);
        EList<CssSelector> _subSelectors = simple_selector2.getSubSelectors();
        for (CssSelector subSelectors : _subSelectors) {
            this.format(subSelectors, document);
        }
    }

    protected void _format(css_declaration css_declaration2, @Extension IFormattableDocument document) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.indent();
            }
        };
        document.prepend((EObject)css_declaration2, (Procedures.Procedure1)_function);
        css_property _property = css_declaration2.getProperty();
        this.format(_property, document);
        EList<CssTok> _valueTokens = css_declaration2.getValueTokens();
        for (CssTok valueTokens : _valueTokens) {
            this.format(valueTokens, document);
        }
    }

    protected void _format(PseudoClassFunction pseudoclassfunction, @Extension IFormattableDocument document) {
        SimpleSelectorForNegation _paramSelector = pseudoclassfunction.getParamSelector();
        this.format(_paramSelector, document);
        EList<CssTok> _params = pseudoclassfunction.getParams();
        for (CssTok params : _params) {
            this.format(params, document);
        }
    }

    protected void _format(UrlTok urltok, @Extension IFormattableDocument document) {
        URLType _url = urltok.getUrl();
        this.format(_url, document);
    }

    protected void _format(FuncTok functok, @Extension IFormattableDocument document) {
        EList<CssTok> _params = functok.getParams();
        for (CssTok params : _params) {
            this.format(params, document);
        }
        IdentifierTok _name = functok.getName();
        this.format(_name, document);
    }

    public void format(Object pseudoclassfunction, IFormattableDocument document) {
        if (pseudoclassfunction instanceof PseudoClassFunction) {
            this._format((PseudoClassFunction)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof XtextResource) {
            this._format((XtextResource)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof FuncTok) {
            this._format((FuncTok)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof UrlTok) {
            this._format((UrlTok)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof font_face) {
            this._format((font_face)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof SimpleSelectorForNegation) {
            this._format((SimpleSelectorForNegation)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof css_declaration) {
            this._format((css_declaration)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof keyframe_selector) {
            this._format((keyframe_selector)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof media) {
            this._format((media)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof page) {
            this._format((page)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof ruleset) {
            this._format((ruleset)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof selector) {
            this._format((selector)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof simple_selector) {
            this._format((simple_selector)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof stylesheet) {
            this._format((stylesheet)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction instanceof EObject) {
            this._format((EObject)pseudoclassfunction, document);
            return;
        }
        if (pseudoclassfunction == null) {
            this._format(null, document);
            return;
        }
        if (pseudoclassfunction != null) {
            this._format(pseudoclassfunction, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pseudoclassfunction, document).toString());
    }
}

