/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.resources.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.modelsetquery.ModelSetQuery;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.ControledResource;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.historyPackage;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.resources.Activator;
import org.eclipse.papyrus.infra.ui.resources.refactoring.Messages;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ModelParticipantHelpers;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameModelChange
extends Change {
    private final Map<URI, URI> uriMap = new HashMap<URI, URI>();
    private final IFile oldFile;
    private final IFile newFile;
    private final Set<IResource> relatedFiles;
    private final Collection<? extends IResource> impacted;
    private TransactionalEditingDomain domain;
    private ModelSet resourceSet;
    private List<IMultiDiagramEditor> openedEditors;
    private boolean isUndoOperation;

    public RenameModelChange(IFile oldFile, IFile newFile, Collection<? extends IResource> impacted) {
        this.oldFile = oldFile;
        this.newFile = newFile;
        this.impacted = impacted;
        IPath newPathWithoutExt = newFile.getFullPath().removeFileExtension();
        this.relatedFiles = ModelParticipantHelpers.getRelatedFiles(oldFile);
        this.relatedFiles.add((IResource)oldFile);
        for (IResource iResource : this.relatedFiles) {
            IPath path = iResource.getFullPath();
            URI oldURI = this.getPlatformURI(path);
            URI newURI = this.getPlatformURI(newPathWithoutExt.addFileExtension(path.getFileExtension()));
            this.uriMap.put(oldURI, newURI);
        }
    }

    public Object getModifiedElement() {
        return this.oldFile;
    }

    public String getName() {
        return NLS.bind((String)Messages.RenameModelChange_Name, (Object)this.oldFile.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.subTask(Messages.RenameModelChange_LoadingEMF);
        pm.subTask(Messages.RenameModelChange_DaveDirtyEditor);
        this.openedEditors = new ArrayList<IMultiDiagramEditor>();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IMultiDiagramEditor[] multiEditors = EditorUtils.getRelatedEditors((IFile)RenameModelChange.this.oldFile);
                if (multiEditors != null && multiEditors.length > 0) {
                    IMultiDiagramEditor[] iMultiDiagramEditorArray = multiEditors;
                    int n = multiEditors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMultiDiagramEditor editor = iMultiDiagramEditorArray[n2];
                        if (editor.isDirty()) {
                            editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                        RenameModelChange.this.openedEditors.add(editor);
                        ++n2;
                    }
                }
            }
        });
        pm.worked(10);
        this.resourceSet = new ModelSet();
        try {
            ModelsReader reader = new ModelsReader();
            reader.readModel(this.resourceSet);
            this.resourceSet.loadModels(this.oldFile);
            for (IResource iResource : this.impacted) {
                if (!(iResource instanceof IFile)) continue;
                IFile file = (IFile)iResource;
                try {
                    this.resourceSet.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        try {
            EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        pm.worked(4);
        this.domain = this.resourceSet.getTransactionalEditingDomain();
        return this.manageResourceSet(pm, this.resourceSet);
    }

    private URI getPlatformURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        String lMsg = NLS.bind((String)Messages.RenameModelChange_Change, (Object)this.oldFile.getName(), (Object)this.newFile.getName());
        boolean bl = this.isUndoOperation = this.oldFile.exists() && !this.newFile.exists();
        if (!this.isUndoOperation) {
            this.newFile.move(this.oldFile.getFullPath(), true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        Set<IResource> revertImpactedFiles = this.getRevertImpactedResources();
        pm.beginTask(lMsg, 30);
        try {
            this.doRun(pm, this.resourceSet, this.domain);
            pm.subTask(Messages.RenameModelChange_savingResource);
            for (Resource res : this.resourceSet.getResources()) {
                if (!res.getURI().isPlatformResource()) continue;
                try {
                    if (!res.isModified()) continue;
                    res.save(ResourceUtils.getSaveOptions());
                }
                catch (Exception e) {
                    Activator.log.error(NLS.bind((String)Messages.RenameModelChange_ErrorLoading, (Object)res.getURI()), (Throwable)e);
                }
            }
            pm.worked(5);
            try {
                SashModel oldSash = SashModelUtils.getSashModel((ModelSet)this.resourceSet);
                URI oldSashURI = oldSash.getResourceURI();
                Resource resource = oldSash.getResource();
                this.resourceSet.loadModels(this.newFile);
                SashModel sashModel = SashModelUtils.getSashModel((ModelSet)this.resourceSet);
                URI stashNewFile = sashModel.getResourceURI();
                resource.setURI(stashNewFile);
                resource.save(ResourceUtils.getSaveOptions());
                if (oldSash != null) {
                    try {
                        this.resourceSet.getURIConverter().delete(oldSashURI, null);
                    }
                    catch (IOException e) {
                        Activator.log.error(Messages.bind((String)Messages.RenameModelChange_ErrorLoading, (Object)oldSashURI), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
            pm.subTask(Messages.RenameModelChange_Unloading);
            this.resourceSet.unload();
            pm.worked(1);
            if (!this.openedEditors.isEmpty()) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        IFile newDiFile = DiModelUtils.getRelatedDiFile((IFile)RenameModelChange.this.newFile);
                        for (IMultiDiagramEditor editor : RenameModelChange.this.openedEditors) {
                            try {
                                ModelSet diRes = (ModelSet)editor.getServicesRegistry().getService(ModelSet.class);
                                if (diRes != null) {
                                    diRes.saveAs(RenameModelChange.this.newFile.getFullPath());
                                }
                                editor.setEditorInput((IEditorInput)new FileEditorInput(newDiFile));
                            }
                            catch (ServiceException e) {
                                Activator.log.error((Throwable)e);
                            }
                            catch (IOException e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    }
                });
            }
            pm.subTask(Messages.RenameModelChange_RemoveOldFile);
            for (IResource iResource : this.relatedFiles) {
                if (!iResource.exists()) continue;
                IPath path = iResource.getFullPath();
                URI oldURI = this.getPlatformURI(path);
                URI newURI = this.uriMap.get(oldURI);
                URIConverter uriConverter = this.resourceSet.getURIConverter();
                if (!uriConverter.exists(newURI, Collections.EMPTY_MAP)) continue;
                iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            pm.worked(4);
            RenameModelChange undoChange = new RenameModelChange(this.newFile, this.oldFile, revertImpactedFiles);
            if (this.isUndoOperation) {
                this.newFile.move(this.oldFile.getFullPath(), true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            RenameModelChange renameModelChange = undoChange;
            return renameModelChange;
        }
        finally {
            pm.done();
        }
    }

    private Set<IResource> getRevertImpactedResources() {
        HashSet<IResource> result = new HashSet<IResource>();
        Set<IResource> relatedFiles = ModelParticipantHelpers.getRelatedFiles(this.oldFile);
        relatedFiles.add((IResource)this.oldFile);
        for (IResource iResource : this.impacted) {
            if (relatedFiles.contains(iResource)) {
                IResource invertedResource = this.invertFileName(iResource);
                result.add(invertedResource);
                continue;
            }
            result.add(iResource);
        }
        return result;
    }

    private IResource invertFileName(IResource initialResource) {
        IPath pathWithoutExtension = this.newFile.getFullPath().removeFileExtension();
        IPath pathWithExtension = pathWithoutExtension.addFileExtension(initialResource.getFileExtension());
        String newName = pathWithExtension.lastSegment();
        IFile newFile = this.oldFile.getParent().getFile((IPath)new Path(newName));
        return newFile;
    }

    private RefactoringStatus manageResourceSet(IProgressMonitor pm, final ModelSet resourceSet) {
        final HashSet readOnlies = new HashSet();
        this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

            protected void doExecute() {
                for (URI uri : RenameModelChange.this.uriMap.keySet()) {
                    Resource r = resourceSet.getResource(uri, false);
                    ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
                    if (adapter == null) {
                        adapter = new ECrossReferenceAdapter();
                        adapter.setTarget((Notifier)resourceSet);
                    }
                    if (r == null) continue;
                    TreeIterator i = EcoreUtil.getAllProperContents((Resource)r, (boolean)false);
                    while (i.hasNext()) {
                        EObject e = (EObject)i.next();
                        Collection references = adapter.getInverseReferences(e);
                        for (EStructuralFeature.Setting s : references) {
                            boolean isWritable;
                            EStructuralFeature eFeature;
                            EObject eObject = s.getEObject();
                            if (eObject.eResource() == null || eObject.eResource().equals(e.eResource()) || (eFeature = s.getEStructuralFeature()).isDerived() || !eObject.eClass().getEAllStructuralFeatures().contains((Object)eFeature) || eObject.eResource() == null || !EMFHelper.isReadOnly((Resource)eObject.eResource(), (EditingDomain)RenameModelChange.this.domain) || !(isWritable = EMFHelper.canMakeWritable((Resource)eObject.eResource(), (EditingDomain)RenameModelChange.this.domain))) continue;
                            readOnlies.add(eObject.eResource());
                        }
                    }
                }
            }
        });
        if (!readOnlies.isEmpty()) {
            ReadOnlyManager readOnlyManager = new ReadOnlyManager((EditingDomain)this.domain);
            ArrayList<URI> uris = new ArrayList<URI>();
            for (Resource r : readOnlies) {
                uris.add(r.getURI());
            }
            readOnlyManager.makeWritable(ReadOnlyAxis.anyAxis(), uris.toArray(new URI[uris.size()]));
        }
        return new RefactoringStatus();
    }

    private void doRun(IProgressMonitor pm, final ModelSet resourceSet, TransactionalEditingDomain domain) {
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            protected void doExecute() {
                modifiedURI = URI.createPlatformResourceURI((String)RenameModelChange.access$0(RenameModelChange.this).getFullPath().removeFileExtension().toString(), (boolean)true);
                controledResourcesAdapter = ModelSetQuery.getExistingTypeCacheAdapter((Notifier)resourceSet);
                if (controledResourcesAdapter != null) {
                    first = null;
                    i = resourceSet.getAllContents();
                    while (i.hasNext()) {
                        n = (Notifier)i.next();
                        if (!(n instanceof EObject)) continue;
                        first = (EObject)n;
                        break;
                    }
                    if (first != null) {
                        block8: {
                            resources = null;
                            try {
                                resources = controledResourcesAdapter.getReachableObjectsOfType(first, (EClassifier)historyPackage.Literals.CONTROLED_RESOURCE);
                                break block8;
                            }
                            catch (RuntimeException e) {
                                resources = new LinkedList<ControledResource>();
                                i = 0;
                                ** while (i < resourceSet.getResources().size())
                            }
lbl-1000:
                            // 1 sources

                            {
                                r = (Resource)resourceSet.getResources().get(i);
                                it = r.getAllContents();
                                while (it.hasNext()) {
                                    tmp = (EObject)it.next();
                                    if (!(tmp instanceof ControledResource)) continue;
                                    controled = (ControledResource)tmp;
                                    resources.add(controled);
                                }
                                ++i;
                                continue;
                            }
                        }
                        for (EObject e : resources) {
                            if (!(e instanceof ControledResource)) continue;
                            controled = (ControledResource)e;
                            baseURI = URI.createURI((String)(String.valueOf(e.eResource().getURI().trimSegments(1).trimFragment().toString()) + "/"));
                            resolvedURI = URI.createURI((String)controled.getResourceURL()).resolve(baseURI);
                            if (!resolvedURI.trimFileExtension().equals(modifiedURI.trimFileExtension())) continue;
                            ext = resolvedURI.fileExtension();
                            newURL = URI.createURI((String)(String.valueOf(resolvedURI.trimSegments(1).toString()) + "/" + RenameModelChange.access$2(RenameModelChange.this).getFullPath().removeFileExtension().lastSegment().toString() + "." + ext));
                            controled.setResourceURL(newURL.deresolve(baseURI).toString());
                        }
                    }
                }
            }
        });
        pm.subTask(Messages.RenameModelChange_ModifyURI);
        for (Resource res : resourceSet.getResources()) {
            URI newURI;
            if (!res.getURI().isPlatformResource() || (newURI = this.uriMap.get(res.getURI())) == null) continue;
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug(NLS.bind((String)Messages.RenameModelChange_6, Arrays.asList(res.getURI(), newURI)));
            }
            res.setURI(newURI);
        }
        pm.worked(5);
    }
}

