/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Spinner;

public class IntegerSpinner
extends AbstractValueEditor
implements KeyListener,
ModifyListener {
    protected Spinner spinner = this.createSpinner();
    protected IConverter targetToModelConverter;
    private Timer timer;
    private TimerTask changeColorTask;

    public IntegerSpinner(Composite parent, int style) {
        super(parent, style);
        this.setWidgetObservable((IObservableValue)new AbstractObservableValue(){

            public Object getValueType() {
                return Integer.class;
            }

            protected Integer doGetValue() {
                return (Integer)IntegerSpinner.this.targetToModelConverter.convert((Object)IntegerSpinner.this.spinner.getText());
            }

            protected void doSetValue(Object value) {
                IntegerSpinner.this.spinner.setSelection(((Integer)value).intValue());
            }
        });
        this.spinner.addKeyListener((KeyListener)this);
        this.spinner.addModifyListener((ModifyListener)this);
        this.setCommitOnFocusLost((Control)this.spinner);
        GridData gridData = this.getDefaultLayoutData();
        this.spinner.setLayoutData((Object)gridData);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        this.targetToModelConverter = StringToNumberConverter.toInteger((boolean)false);
        this.controlDecoration = new ControlDecoration((Control)this.spinner, 16384);
    }

    protected Spinner createSpinner() {
        return new Spinner((Composite)this, factory.getBorderStyle());
    }

    @Override
    public void doBinding() {
        this.spinner.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                IntegerSpinner.this.binding.updateTargetToModel();
            }
        });
        super.doBinding();
    }

    @Override
    public Object getValue() {
        String value = this.spinner.getText();
        return this.targetToModelConverter.convert((Object)value);
    }

    @Override
    public Object getEditableType() {
        return Integer.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.spinner.setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.spinner.isEnabled();
    }

    public void setToolTipText(String text) {
        this.spinner.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    public void setMinimum(int minimum) {
        this.spinner.setMinimum(minimum);
    }

    public void setMaximum(int maximum) {
        this.spinner.setMaximum(maximum);
    }

    public void setIncrement(int increment) {
        this.spinner.setIncrement(increment);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            this.notifyChange();
        }
    }

    protected void notifyChange() {
        this.spinner.notifyListeners(16, new Event());
        this.commit();
    }

    @Override
    public void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                this.controlDecoration.hide();
                break;
            }
            case 2: {
                FieldDecoration warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                this.controlDecoration.setImage(warning.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            case 4: {
                FieldDecoration error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                this.controlDecoration.setImage(error.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            default: {
                this.controlDecoration.hide();
            }
        }
    }

    private void cancelCurrentTask() {
        if (this.changeColorTask != null) {
            this.changeColorTask.cancel();
        }
    }

    @Override
    public void changeColorField() {
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        this.cancelCurrentTask();
        this.changeColorTask = new TimerTask(){

            @Override
            public void run() {
                IntegerSpinner.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).IntegerSpinner.this.spinner.isDisposed()) {
                            (this).IntegerSpinner.this.spinner.setBackground(DEFAULT);
                            (this).IntegerSpinner.this.spinner.update();
                        }
                    }
                });
            }
        };
        if (this.errorBinding) {
            this.spinner.setBackground(ERROR);
            this.spinner.update();
        } else {
            IStatus status = (IStatus)this.binding.getValidationStatus().getValue();
            switch (status.getSeverity()) {
                case 0: 
                case 2: {
                    this.timer.schedule(this.changeColorTask, 600L);
                    this.spinner.setBackground(VALID);
                    this.spinner.update();
                    break;
                }
                case 4: {
                    this.spinner.setBackground(ERROR);
                    this.spinner.update();
                }
            }
        }
    }

    public void dispose() {
        if (this.changeColorTask != null) {
            this.changeColorTask.cancel();
            this.changeColorTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        super.dispose();
    }

    public void modifyText(ModifyEvent e) {
        if (this.modelProperty == null) {
            return;
        }
        if (this.modelProperty.getValue() != null) {
            if (!this.isReadOnly() && !this.modelProperty.getValue().toString().equals(this.spinner.getText())) {
                this.spinner.setBackground(EDIT);
            } else {
                this.spinner.setBackground(DEFAULT);
            }
        } else if (this.spinner.getText().equals("")) {
            this.spinner.setBackground(DEFAULT);
        } else {
            this.spinner.setBackground(EDIT);
        }
    }
}

