/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SlidableRoundedRectangleAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PortPositionEnum;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.RoundedRectangleUtil;

public class PortPositionLocator
implements IBorderItemLocator {
    private static final int DEFAULT_HEIGHT = 20;
    private static final int DEFAULT_WIDTH = 20;
    protected IFigure parentFigure = null;
    private String position = PortPositionEnum.INSIDE.toString();
    protected int borderItemOffset = 10;
    protected Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private IFigure figure;

    public int getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setBorderItemOffset(int borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    public IFigure getParentFigure() {
        return this.parentFigure;
    }

    public PortPositionLocator(IFigure parentFigure, int preferredSide) {
        this.parentFigure = parentFigure;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        return this.getPreferredLocation(proposedLocation);
    }

    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        realLocation.translate(realLocation.width / 2, realLocation.height / 2);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        if (this.parentFigure instanceof SVGNodePlateFigure && ((SVGNodePlateFigure)this.parentFigure).getConnectionAnchor("") instanceof SlidableRoundedRectangleAnchor) {
            this.parentFigure.translateToAbsolute((Translatable)realLocation);
            Point location = realLocation.getLocation();
            this.parentFigure.translateToAbsolute((Translatable)parentRec);
            ConnectionAnchor connectionAnchor = ((SVGNodePlateFigure)this.parentFigure).getConnectionAnchor("");
            Dimension offset = this.getPortOffset(proposedLocation.getSize());
            ((SlidableRoundedRectangleAnchor)connectionAnchor).setOffset(offset);
            Point locationForPort = null;
            Dimension cornerDimension = this.getCornerDimension();
            int currentSideOfParent = RoundedRectangleUtil.getPosition((Rectangle)parentRec, (Dimension)cornerDimension, (Point)location);
            Rectangle shrinkedParent = new Rectangle(parentRec);
            shrinkedParent.shrink(cornerDimension.width / 2, cornerDimension.height / 2);
            switch (currentSideOfParent) {
                case 1: {
                    locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(location.getTranslated(0, -parentRec.height / 2), location);
                    break;
                }
                case 4: {
                    locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(location.getTranslated(0, parentRec.height / 2), location);
                    break;
                }
                case 16: {
                    locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(location.getTranslated(-parentRec.width / 2, 0), location);
                    break;
                }
                case 8: {
                    locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(location.getTranslated(parentRec.width / 2, 0), location);
                    break;
                }
                case 9: {
                    if (!cornerDimension.isEmpty()) {
                        locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(shrinkedParent.getTopLeft(), location);
                        break;
                    }
                    locationForPort = parentRec.getTopLeft().translate(-offset.width, -offset.height);
                    break;
                }
                case 17: {
                    if (!cornerDimension.isEmpty()) {
                        locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(shrinkedParent.getTopRight(), location);
                        break;
                    }
                    locationForPort = parentRec.getTopRight().translate(offset.width, -offset.height);
                    break;
                }
                case 20: {
                    if (!cornerDimension.isEmpty()) {
                        locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(shrinkedParent.getBottomRight(), location);
                        break;
                    }
                    locationForPort = parentRec.getBottomRight().translate(offset.width, offset.height);
                    break;
                }
                case 12: {
                    if (!cornerDimension.isEmpty()) {
                        locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(shrinkedParent.getBottomLeft(), location);
                        break;
                    }
                    locationForPort = parentRec.getBottomLeft().translate(-offset.width, offset.height);
                    break;
                }
                default: {
                    locationForPort = ((SlidableRoundedRectangleAnchor)connectionAnchor).getLocation(parentRec.getCenter(), location);
                }
            }
            ((SlidableRoundedRectangleAnchor)connectionAnchor).setOffset(new Dimension());
            if (locationForPort != null) {
                locationForPort.translate(-realLocation.width / 2, -realLocation.height / 2);
                realLocation.setLocation(locationForPort);
            }
            this.parentFigure.translateToRelative((Translatable)realLocation);
        } else {
            realLocation = this.getPreferedLocationOldWay(proposedLocation);
        }
        return realLocation;
    }

    private Rectangle getPreferedLocationOldWay(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        int xMin = parentRec.x - this.borderItemOffset;
        int xMax = parentRec.x - this.borderItemOffset + parentRec.width;
        int yMin = parentRec.y - this.borderItemOffset;
        int yMax = parentRec.y - this.borderItemOffset + parentRec.height;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        Rectangle maxRect = parentRec.getCopy();
        maxRect.shrink(-this.borderItemOffset, -this.borderItemOffset);
        while (maxRect.contains(realLocation.getLocation())) {
            maxRect.shrink(1, 1);
        }
        int pos = maxRect.getPosition(realLocation.getLocation());
        switch (pos) {
            case 1: {
                realLocation.y = yMin;
                break;
            }
            case 4: {
                realLocation.y = yMax;
                break;
            }
            case 16: {
                realLocation.x = xMax;
                break;
            }
            case 8: {
                realLocation.x = xMin;
                break;
            }
            case 17: {
                realLocation.x = xMax;
                realLocation.y = yMin;
                break;
            }
            case 9: {
                realLocation.x = xMin;
                realLocation.y = yMin;
                break;
            }
            case 20: {
                realLocation.x = xMax;
                realLocation.y = yMax;
                break;
            }
            case 12: {
                realLocation.x = xMin;
                realLocation.y = yMax;
            }
        }
        return realLocation;
    }

    protected Dimension getCornerDimension() {
        Dimension cornerDimension = null;
        IRoundedRectangleFigure roundedFigure = (IRoundedRectangleFigure)FigureUtils.findChildFigureInstance((IFigure)this.parentFigure, IRoundedRectangleFigure.class);
        if (roundedFigure != null) {
            cornerDimension = roundedFigure.getCornerDimensions().getCopy();
        }
        if (cornerDimension.width * 2 > this.parentFigure.getBounds().width) {
            cornerDimension.setWidth(this.parentFigure.getBounds().width / 2);
        }
        if (cornerDimension.height * 2 > this.parentFigure.getBounds().height()) {
            cornerDimension.setHeight(this.parentFigure.getBounds().height / 2);
        }
        return cornerDimension;
    }

    private Dimension getPortOffset(Dimension bounds) {
        Dimension portOffset = new Dimension();
        if (this.figure != null) {
            if (PortPositionEnum.INSIDE.toString().equals(this.position)) {
                portOffset.width = -bounds.width / 2;
                portOffset.height = -bounds.height / 2;
            } else if (PortPositionEnum.OUTSIDE.toString().equals(this.position)) {
                portOffset.width = bounds.width / 2 - 1;
                portOffset.height = bounds.height / 2 - 1;
            }
        }
        return portOffset;
    }

    public void setPortPosition(String position) {
        this.position = position;
    }

    public int getCurrentSideOfParent() {
        int defaultSkink = 10;
        Rectangle basisRectangle = new Rectangle(0, 0, this.parentFigure.getBounds().width, this.parentFigure.getBounds().height);
        int skink_width = this.constraint.width / 2;
        int skink_height = this.constraint.height / 2;
        if (skink_width <= 0) {
            skink_width = defaultSkink;
        }
        if (skink_height <= 0) {
            skink_height = defaultSkink;
        }
        Rectangle internalRectangle = basisRectangle.getShrinked(new Insets(skink_height, skink_width, skink_height, skink_width));
        int position = internalRectangle.getPosition(this.constraint.getTopLeft());
        return position;
    }

    public void setConstraint(Rectangle constraint) {
        if (constraint.getSize().equals(-1, -1)) {
            constraint.setSize(20, 20);
        }
        this.constraint = constraint;
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public void relocate(IFigure target) {
        if (this.figure == null) {
            this.figure = target;
        }
        Rectangle proposedLocation = this.constraint.getCopy();
        proposedLocation.setLocation(this.constraint.getLocation().translate(this.parentFigure.getBounds().getTopLeft()));
        Point validLocation = this.getValidLocation(proposedLocation, target).getLocation();
        Rectangle rect = new Rectangle(validLocation, target.getPreferredSize());
        target.setBounds(rect);
        RoundedRectangleNodePlateFigure nodePlateFigure = (RoundedRectangleNodePlateFigure)FigureUtils.findChildFigureInstance((IFigure)this.figure, RoundedRectangleNodePlateFigure.class);
        if (nodePlateFigure != null) {
            if (this.figure instanceof RoundedRectangleNodePlateFigure) {
                for (Object child : nodePlateFigure.getChildren()) {
                    if (!(child instanceof IFigure)) continue;
                    ((IFigure)child).setBounds(rect);
                }
            }
            nodePlateFigure.invalidate();
        }
    }
}

