/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.css.palette.aspect;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.AddCustomStyleListValueCommand;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringCombo;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.ModelPostAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStylePostAction
extends ModelPostAction {
    private StringCombo editor;
    private Node configurationNode;
    public static final String CLASS_ELEMENT = "cssClass";
    public static final String CLASS_PROPERTY = "class";
    private String value;
    private static final String CSS_CLASS = "cssClass";

    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.editor = new StringCombo(parent, 0);
        this.editor.setContentProvider((IStaticContentProvider)EmptyContentProvider.instance);
        if (this.value != null) {
            this.editor.setValue((Object)this.value);
        }
        this.editor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor widget) {
                CSSStylePostAction.this.value = CSSStylePostAction.this.editor.getValue();
            }
        });
        return this.editor;
    }

    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        this.configurationNode = configurationNode;
        this.value = this.getValue();
    }

    public void save(Node parentNode) {
        Element cssElement = ((Element)parentNode).getOwnerDocument().createElement("cssClass");
        parentNode.appendChild(cssElement);
        cssElement.setAttribute(CLASS_PROPERTY, this.value == null ? "" : this.value);
    }

    private String getValue() {
        if (this.configurationNode == null) {
            return null;
        }
        NodeList cssElements = ((Element)this.configurationNode).getElementsByTagName("cssClass");
        if (cssElements != null) {
            int i = 0;
            while (i < cssElements.getLength()) {
                Node node = cssElements.item(i);
                if (node instanceof Element) {
                    String value = ((Element)node).getAttribute(CLASS_PROPERTY);
                    return value;
                }
                ++i;
            }
        }
        return null;
    }

    public ICommand getPostCommand(final IAdaptable viewAdapter) {
        TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)viewAdapter);
        if (domain != null) {
            AbstractTransactionalCommand transactionalCommand = new AbstractTransactionalCommand(domain, "Change css style", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    String value;
                    View notationView = (View)viewAdapter.getAdapter(View.class);
                    if (notationView != null && (value = CSSStylePostAction.this.getValue()) != null) {
                        AddCustomStyleListValueCommand command = new AddCustomStyleListValueCommand((EditingDomain)this.getEditingDomain(), notationView, "cssClass", NotationPackage.eINSTANCE.getStringListValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getStringListValueStyle_StringListValue(), (Object)value);
                        command.execute();
                        return CommandResult.newOKCommandResult();
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            return transactionalCommand;
        }
        return null;
    }
}

