/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.strategy.paste.ShowConstraintContextLink;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.papyrus.uml.diagram.profile.custom.commands.SetStereotypeVisibleOnMetaclassCommand;
import org.eclipse.papyrus.uml.diagram.profile.custom.helper.MultiAssociationHelper;
import org.eclipse.papyrus.uml.diagram.profile.custom.helper.MultiDependencyHelper;
import org.eclipse.papyrus.uml.diagram.profile.custom.helper.ProfileLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.profile.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class ProfileDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public ProfileDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)ProfileLinkMappingHelper.getInstance());
    }

    protected Set<String> getDroppableElementVisualId() {
        HashSet<String> droppableElementsVisualID = new HashSet<String>();
        droppableElementsVisualID.add("Dependency_Shape");
        droppableElementsVisualID.add("ElementImport_Edge");
        droppableElementsVisualID.add("Extension_Edge");
        droppableElementsVisualID.add("Association_Shape");
        droppableElementsVisualID.add("Comment_Shape");
        droppableElementsVisualID.add("Comment_Shape_CN");
        droppableElementsVisualID.add("Constraint_PackagedElementShape");
        droppableElementsVisualID.add("Constraint_PackagedElementShape_CN");
        droppableElementsVisualID.add("Class_MetaclassShape");
        droppableElementsVisualID.add("Class_MetaclassShape_CN");
        return droppableElementsVisualID;
    }

    public String getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public String getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public IElementType getUMLElementType(String elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    protected Command dropAssociation(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        ArrayList endtypes = new ArrayList(ProfileLinkMappingHelper.getInstance().getSource(semanticLink));
        if (endtypes.size() == 2) {
            Element source = null;
            Element target = null;
            EList memberEnds = ((Association)semanticLink).getMemberEnds();
            if (((Property)memberEnds.get(0)).equals(endtypes.get(0))) {
                source = (Element)endtypes.get(0);
                target = (Element)endtypes.get(1);
            } else {
                source = (Element)endtypes.get(1);
                target = (Element)endtypes.get(0);
            }
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("Drop Association"), source, target, "Association_Edge", dropRequest.getLocation(), semanticLink));
        }
        if (endtypes.size() > 2) {
            MultiAssociationHelper associationHelper = new MultiAssociationHelper(this.getEditingDomain());
            return associationHelper.dropMultiAssociation((Association)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        Collection<?> sources = ProfileLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = ProfileLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sources.size() == 1 && targets.size() == 1) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("Drop Dependency"), source, target, "Dependency_Edge", dropRequest.getLocation(), semanticLink));
        }
        if (sources.size() > 1 || targets.size() > 1) {
            MultiDependencyHelper dependencyHelper = new MultiDependencyHelper(this.getEditingDomain());
            return dependencyHelper.dropMutliDependency((Dependency)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        block37: {
            block35: {
                if (linkVISUALID == null) break block35;
                switch (linkVISUALID) {
                    case "ElementImport_Edge": {
                        return this.dropElementImport(dropRequest, semanticElement, nodeVISUALID);
                    }
                    case "Extension_Edge": {
                        return this.dropExtension(dropRequest, semanticElement, linkVISUALID);
                    }
                }
            }
            if (nodeVISUALID == null) break block37;
            switch (nodeVISUALID) {
                case "Dependency_Shape": {
                    return this.dropDependency(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Association_Shape": {
                    return this.dropAssociation(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Comment_Shape": 
                case "Comment_Shape_CN": {
                    return this.dropComment(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Constraint_PackagedElementShape_CN": 
                case "Constraint_PackagedElementShape": {
                    return this.dropConstraint(dropRequest, (Constraint)semanticElement, nodeVISUALID);
                }
                case "Class_MetaclassShape": 
                case "Class_MetaclassShape_CN": {
                    return this.dropMetaclass(dropRequest, semanticElement, nodeVISUALID);
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropMetaclass(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID) {
        if (Util.isMetaclass((Type)((Type)semanticElement))) {
            CompositeCommand cc = new CompositeCommand("Drop");
            ICommand dropCommand = super.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement);
            cc.compose((IUndoableOperation)dropCommand);
            Object returnedValue = dropCommand.getCommandResult().getReturnValue();
            if (returnedValue instanceof ArrayList) {
                CreateViewRequest.ViewDescriptor desc = (CreateViewRequest.ViewDescriptor)((ArrayList)returnedValue).get(0);
                SetStereotypeVisibleOnMetaclassCommand command = new SetStereotypeVisibleOnMetaclassCommand(this.getEditingDomain(), "Apply Stereotype", null, semanticElement, desc);
                if (command.canExecute()) {
                    cc.compose((IUndoableOperation)command);
                }
            }
            return new ICommandProxy((ICommand)cc);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropComment(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (!(graphicalParentObject instanceof Package)) {
            return UnexecutableCommand.INSTANCE;
        }
        if ("Comment_Shape".equals(nodeVISUALID)) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_Shape, (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge);
        }
        if ("Comment_Shape_CN".equals(nodeVISUALID)) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_Shape_CN, (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConstraint(DropObjectsRequest dropRequest, Constraint constraint, String nodeVISUALID) {
        ICommand dropConstraintCommand = this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)constraint, dropRequest);
        if (constraint.getContext() != null) {
            ShowConstraintContextLink showConstraintContextLink = new ShowConstraintContextLink(this.getEditingDomain(), (GraphicalEditPart)this.getHost(), constraint);
            dropConstraintCommand = dropConstraintCommand.compose((IUndoableOperation)showConstraintContextLink);
        }
        return GMFtoGEFCommandWrapper.wrap((ICommand)dropConstraintCommand);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command dropExtension(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sources = ProfileLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = ProfileLinkMappingHelper.getInstance().getTarget(semanticLink);
        Element source = (Element)sources.toArray()[0];
        Element target = (Element)targets.toArray()[0];
        if (sources.size() != 1 && targets.size() != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)this.dropBinaryLinkExtension(new CompositeCommand("drop Extension"), source, target, "Extension_Edge", dropRequest.getLocation(), semanticLink));
    }

    protected Command dropElementImport(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        if (semanticLink instanceof ElementImport && ((ElementImport)semanticLink).getImportedElement() instanceof Class) {
            SetStereotypeVisibleOnMetaclassCommand stereotypeCommand;
            Class metaclass = (Class)((ElementImport)semanticLink).getImportedElement();
            EObject container = semanticLink.eContainer();
            List containerView = DiagramEditPartsUtil.getEObjectViews((EObject)container);
            CompositeCommand cc = new CompositeCommand("Drop");
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)metaclass);
            CreateViewRequest.ViewDescriptor descriptor = ((View)containerView.get(0)).equals(this.getHost().getModel()) ? new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType("Class_MetaclassShape")).getSemanticHint(), -1, true, this.getDiagramPreferencesHint()) : new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType("Class_MetaclassShape_CN")).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
            CreateCommand createCommand = new CreateCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)createCommand);
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), dropRequest.getLocation());
            cc.compose((IUndoableOperation)setBoundsCommand);
            if (createCommand.canExecute() && (stereotypeCommand = new SetStereotypeVisibleOnMetaclassCommand(this.getEditingDomain(), "Set Stereotype Visible", null, semanticLink, (CreateViewRequest.ViewDescriptor)createCommand.getCommandResult().getReturnValue())).canExecute()) {
                cc.add((IUndoableOperation)stereotypeCommand);
            }
            return new ICommandProxy((ICommand)cc);
        }
        return UnexecutableCommand.INSTANCE;
    }

    CompositeCommand dropBinaryLinkExtension(CompositeCommand cc, Element source, Element target, String linkVISUALID, Point location, Element semanticLink) {
        SetBoundsCommand setBoundsCommand;
        CreateCommand nodeCreationCommand;
        CreateViewRequest.ViewDescriptor descriptor;
        GraphicalEditPart sourceEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
        GraphicalEditPart targetEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)target);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        EList e = source.eAdapters();
        if (sourceEditPart == null) {
            descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)source), Node.class, null, -1, true, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y + 100));
            cc.compose((IUndoableOperation)setBoundsCommand);
            sourceAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)target), Node.class, null, -1, true, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            nodeCreationCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)nodeCreationCommand);
            setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y - 100));
            cc.compose((IUndoableOperation)setBoundsCommand);
            targetAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        cc.compose((IUndoableOperation)aLinkCommand);
        return cc;
    }

    private boolean isEditPartTypeAdapted(java.lang.Class<? extends EditPart> editPartClass, EClass eClass) {
        if (DiagramEditPart.class.isAssignableFrom(editPartClass) || CompartmentEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (GraphicalEditPart.class.isAssignableFrom(editPartClass)) {
            return this.isEditPartTypeSuitableForEClass(editPartClass.asSubclass(GraphicalEditPart.class), eClass);
        }
        return false;
    }

    private Collection<EditPart> getTheFirstLevel(Element semanticLink) {
        EObject linkContainer = semanticLink.eContainer();
        EditPart currentEditPart2 = null;
        ArrayList<EditPart> profileContents = new ArrayList<EditPart>();
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        for (EditPart currentEditPart2 : editPartSet) {
            EObject parent;
            if (currentEditPart2.getParent() == null) continue;
            Object model = currentEditPart2.getParent().getModel();
            if (model instanceof Node && (parent = ((Node)model).getElement()).equals(linkContainer)) {
                profileContents.add(currentEditPart2);
            }
            if (!(model instanceof Diagram) || !(parent = ((Diagram)model).getElement()).equals(linkContainer)) continue;
            profileContents.add(currentEditPart2);
        }
        return profileContents;
    }
}

