/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.FragmentsOrderer;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class FragmentsOrdererHelper {
    private static final List<String> INTERACTION_FRAGMENT_HINTS = new ArrayList<String>();

    static {
        INTERACTION_FRAGMENT_HINTS.add(((IHintedType)UMLElementTypes.ActionExecutionSpecification_Shape).getSemanticHint());
        INTERACTION_FRAGMENT_HINTS.add(((IHintedType)UMLElementTypes.BehaviorExecutionSpecification_Shape).getSemanticHint());
        INTERACTION_FRAGMENT_HINTS.add(((IHintedType)UMLElementTypes.CombinedFragment_Shape).getSemanticHint());
        INTERACTION_FRAGMENT_HINTS.add(((IHintedType)UMLElementTypes.CombinedFragment_CoRegionShape).getSemanticHint());
        INTERACTION_FRAGMENT_HINTS.add(((IHintedType)UMLElementTypes.InteractionUse_Shape).getSemanticHint());
        INTERACTION_FRAGMENT_HINTS.add(((IHintedType)UMLElementTypes.StateInvariant_Shape).getSemanticHint());
    }

    private FragmentsOrdererHelper() {
    }

    private static boolean isCreatingFragments(EditPart parentEditPart, CreateViewAndElementRequest request) {
        if (request == null) {
            return false;
        }
        CreateViewAndElementRequest.ViewAndElementDescriptor desc = request.getViewAndElementDescriptor();
        if (desc == null) {
            return false;
        }
        String semanticHint = desc.getSemanticHint();
        if (semanticHint == null) {
            return false;
        }
        if (INTERACTION_FRAGMENT_HINTS.contains(semanticHint)) {
            return true;
        }
        return parentEditPart instanceof LifelineEditPart && ((IHintedType)UMLElementTypes.Lifeline_Shape).getSemanticHint().equals(semanticHint);
    }

    private static TransactionalEditingDomain getEditingDomain(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart.getAdapter(IGraphicalEditPart.class);
        if (graphicalEditPart != null) {
            return graphicalEditPart.getEditingDomain();
        }
        return null;
    }

    public static Command createOrderingFragmentsCommand(EditPart anyEditPart, final ReconnectRequest request) {
        if (anyEditPart == null || request == null || request.getConnectionEditPart() == null) {
            return null;
        }
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(FragmentsOrdererHelper.getEditingDomain(anyEditPart), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                HashMap<View, Float[]> viewPositions = new HashMap<View, Float[]>();
                ConnectionEditPart conn = request.getConnectionEditPart();
                if (conn != null) {
                    FragmentsOrdererHelper.orderingFragments((EditPart)conn, viewPositions);
                }
                return CommandResult.newOKCommandResult();
            }
        });
    }

    public static Command createOrderingFragmentsCommand(final EditPart anyEditPart, final CreateConnectionViewAndElementRequest request) {
        if (anyEditPart == null || request == null) {
            return null;
        }
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(FragmentsOrdererHelper.getEditingDomain(anyEditPart), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                HashMap<View, Float[]> viewPositions = new HashMap<View, Float[]>();
                CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor desc = request.getConnectionViewAndElementDescriptor();
                if (desc != null) {
                    View view = (View)desc.getAdapter(View.class);
                    if (view instanceof Edge) {
                        Point location = request.getLocation().getCopy();
                        Float[] positions = new Float[2];
                        positions[1] = Float.valueOf(location.y);
                        Object sourceLoc = request.getExtendedData().get("Location of connection source point");
                        if (sourceLoc instanceof Point) {
                            positions[0] = Float.valueOf(((Point)sourceLoc).y);
                        }
                        viewPositions.put(view, positions);
                    }
                    FragmentsOrdererHelper.orderingFragments(DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)anyEditPart), viewPositions);
                }
                return CommandResult.newOKCommandResult();
            }
        });
    }

    public static ICommand createOrderingFragmentsCommand(final EditPart parentEditPart, final CreateViewAndElementRequest request) {
        if (parentEditPart == null || request == null || !FragmentsOrdererHelper.isCreatingFragments(parentEditPart, request)) {
            return null;
        }
        return new AbstractTransactionalCommand(FragmentsOrdererHelper.getEditingDomain(parentEditPart), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view;
                HashMap<View, Float[]> viewPositions = new HashMap<View, Float[]>();
                CreateViewAndElementRequest.ViewAndElementDescriptor desc = request.getViewAndElementDescriptor();
                if (desc != null && (view = (View)desc.getAdapter(View.class)) != null) {
                    Point location = request.getLocation().getCopy();
                    if (parentEditPart instanceof IGraphicalEditPart) {
                        ((IGraphicalEditPart)parentEditPart).getFigure().translateToRelative((Translatable)location);
                        location.y -= ((IGraphicalEditPart)parentEditPart).getFigure().getBounds().y;
                    }
                    viewPositions.put(view, new Float[]{Float.valueOf(location.y)});
                }
                FragmentsOrdererHelper.orderingFragments(parentEditPart, viewPositions);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private static Set<IGraphicalEditPart> getFragmentRootEditPart(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart.getAdapter(IGraphicalEditPart.class);
        if (graphicalEditPart instanceof InteractionEditPart || graphicalEditPart instanceof InteractionOperandEditPart) {
            HashSet<IGraphicalEditPart> rootEditParts = new HashSet<IGraphicalEditPart>();
            rootEditParts.add(graphicalEditPart);
            return rootEditParts;
        }
        if (graphicalEditPart instanceof AbstractMessageEditPart) {
            HashSet<IGraphicalEditPart> rootEditParts = new HashSet<IGraphicalEditPart>();
            EObject element = graphicalEditPart.resolveSemanticElement();
            HashSet<Object> enclosingParents = new HashSet<Object>();
            if (element instanceof Message) {
                MessageEnd sendEvent;
                MessageEnd messageEnd = ((Message)element).getReceiveEvent();
                if (messageEnd instanceof OccurrenceSpecification) {
                    InteractionOperand enclosingOperand;
                    Interaction enclosingInteraction = ((OccurrenceSpecification)messageEnd).getEnclosingInteraction();
                    if (enclosingInteraction != null) {
                        enclosingParents.add(enclosingInteraction);
                    }
                    if ((enclosingOperand = ((OccurrenceSpecification)messageEnd).getEnclosingOperand()) != null) {
                        enclosingParents.add(enclosingOperand);
                    }
                }
                if ((sendEvent = ((Message)element).getSendEvent()) instanceof OccurrenceSpecification) {
                    InteractionOperand enclosingOperand;
                    Interaction enclosingInteraction = ((OccurrenceSpecification)sendEvent).getEnclosingInteraction();
                    if (enclosingInteraction != null) {
                        enclosingParents.add(enclosingInteraction);
                    }
                    if ((enclosingOperand = ((OccurrenceSpecification)sendEvent).getEnclosingOperand()) != null) {
                        enclosingParents.add(enclosingOperand);
                    }
                }
            }
            if (enclosingParents != null) {
                for (EObject eObject : enclosingParents) {
                    List views = DiagramEditPartsUtil.getEObjectViews((EObject)eObject);
                    for (Object object : views) {
                        View view = (View)object;
                        EditPart root = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)editPart);
                        if (!(root instanceof IGraphicalEditPart)) continue;
                        rootEditParts.add((IGraphicalEditPart)root);
                    }
                }
            }
            return rootEditParts;
        }
        return FragmentsOrdererHelper.getFragmentRootEditPart(editPart.getParent());
    }

    public static void orderingFragments(EditPart anyEditPart, Map<View, Float[]> viewPositions) {
        Set<IGraphicalEditPart> fragmentRootEditParts = FragmentsOrdererHelper.getFragmentRootEditPart(anyEditPart);
        if (fragmentRootEditParts == null || fragmentRootEditParts.isEmpty()) {
            return;
        }
        for (IGraphicalEditPart fragmentRootEditPart : fragmentRootEditParts) {
            FragmentsOrderer fragmentsOrderer = new FragmentsOrderer(fragmentRootEditPart);
            if (viewPositions != null) {
                Set<Map.Entry<View, Float[]>> entrySet = viewPositions.entrySet();
                for (Map.Entry<View, Float[]> entry : entrySet) {
                    fragmentsOrderer.addCachePosition(entry.getKey(), entry.getValue());
                }
            }
            fragmentsOrderer.ordering();
        }
    }
}

