/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.listeners;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.RefreshEditPartCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.listeners.AbstractModifcationTriggerListener;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.InternalTransitionEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.TransitionEditPart;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.UMLPackage;

public class InternalStateListener
extends AbstractModifcationTriggerListener {
    private static final String DROP_INTERNAL_TRANSITION_COMMAND_LABEL = "Drop internal transition";

    @Override
    protected boolean isCorrectStructuralfeature(EStructuralFeature eStructuralFeature) {
        return UMLPackage.Literals.TRANSITION__KIND.equals(eStructuralFeature);
    }

    @Override
    protected CompositeCommand getModificationCommand(Notification notif) {
        Object newValue = notif.getNewValue();
        Object notifier = notif.getNotifier();
        if (newValue instanceof TransitionKind && notifier instanceof EObject) {
            CompositeCommand cc = new CompositeCommand("Modification command triggered by modification of the kind of the current selected transition");
            EObject eNotifier = (EObject)notifier;
            boolean becomingInternal = this.isBecomingInternal(notif);
            IGraphicalEditPart availableEditPart = this.getChildByEObject(eNotifier, (IGraphicalEditPart)this.getDiagramEditPart(), becomingInternal);
            if (availableEditPart == null) {
                return null;
            }
            Command deleteCommand = this.getDeleteCommand(becomingInternal, availableEditPart);
            Command creationCommand = this.getCreationCommand(becomingInternal, eNotifier);
            if (deleteCommand != null && deleteCommand.canExecute() && creationCommand != null && creationCommand.canExecute()) {
                cc.compose((IUndoableOperation)new CommandProxy(deleteCommand));
                cc.compose((IUndoableOperation)new CommandProxy(creationCommand));
            }
            return cc;
        }
        return null;
    }

    protected void refreshEditParts(CompositeCommand cc, Set<IGraphicalEditPart> set) {
        for (IGraphicalEditPart part : set) {
            RefreshEditPartCommand refreshEditPart = new RefreshEditPartCommand(part, true);
            if (refreshEditPart == null || !refreshEditPart.canExecute()) continue;
            cc.compose((IUndoableOperation)refreshEditPart);
        }
    }

    protected boolean isBecomingInternal(Notification notif) {
        Object newValue = notif.getNewValue();
        if (newValue instanceof TransitionKind) {
            TransitionKind newKind = (TransitionKind)newValue;
            return TransitionKind.INTERNAL_LITERAL.equals((Object)newKind);
        }
        return false;
    }

    private Command getDeleteCommand(boolean isBecomingInternal, IGraphicalEditPart availableEditPart) {
        if (isBecomingInternal ? !(availableEditPart instanceof TransitionEditPart) : !(availableEditPart instanceof InternalTransitionEditPart)) {
            return null;
        }
        GroupRequest request = new GroupRequest((Object)"delete");
        request.setEditParts((EditPart)availableEditPart);
        return availableEditPart.getCommand((Request)request);
    }

    private Command getCreationCommand(boolean isBecomingInternal, EObject eNotifier) {
        if (eNotifier instanceof Transition) {
            Transition transition = (Transition)eNotifier;
            IGraphicalEditPart dropTarget = null;
            dropTarget = this.getChildByEObject((EObject)transition.getSource(), (IGraphicalEditPart)this.getDiagramEditPart(), isBecomingInternal);
            if (isBecomingInternal) {
                dropTarget = this.getChildByEObject((EObject)transition.getSource(), (IGraphicalEditPart)this.getDiagramEditPart(), false);
            } else {
                dropTarget = this.getChildByEObject((EObject)transition.getContainer(), (IGraphicalEditPart)this.getDiagramEditPart(), false);
                dropTarget = dropTarget.getChildBySemanticHint(String.valueOf("Region_SubvertexCompartment"));
            }
            if (dropTarget != null) {
                DropObjectsRequest request = new DropObjectsRequest();
                request.setLocation(new Point(1, 1));
                request.setObjects(Collections.singletonList(transition));
                Command cmd = dropTarget.getCommand((Request)request);
                if (cmd != null && cmd.canExecute()) {
                    CompositeCommand cc = new CompositeCommand(DROP_INTERNAL_TRANSITION_COMMAND_LABEL);
                    cc.compose((IUndoableOperation)new CommandProxy(cmd));
                    this.refreshEditParts(cc, Collections.singleton(dropTarget));
                    return new ICommandProxy((ICommand)cc);
                }
                return cmd;
            }
        }
        return null;
    }
}

