/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parts;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;

public class SpecificTypeCreationTool
extends AspectUnspecifiedTypeConnectionTool {
    private final Collection<EClass> sourceTypes;
    private final Collection<EClass> targetTypes;

    public SpecificTypeCreationTool(IElementType connectionTypeToCreate, Collection<EClass> sourceTypes, Collection<EClass> targetTypes) {
        super(Collections.singletonList(connectionTypeToCreate));
        this.sourceTypes = sourceTypes;
        this.targetTypes = targetTypes;
    }

    protected Command getCommand() {
        EditPart targetEditPart = this.getTargetEditPart();
        EObject element = null;
        if (targetEditPart != null && targetEditPart.getModel() instanceof View) {
            element = ((View)targetEditPart.getModel()).getElement();
        }
        if (this.isInState(1) && !SpecificTypeCreationTool.isOfType(element, this.sourceTypes)) {
            return null;
        }
        if ((this.isInState(64) || this.isInState(0x40000000)) && !SpecificTypeCreationTool.isOfType(element, this.targetTypes)) {
            return null;
        }
        return super.getCommand();
    }

    private static boolean isOfType(EObject element, Collection<EClass> types) {
        for (EClass eClass : types) {
            if (!eClass.isInstance((Object)element)) continue;
            return true;
        }
        return false;
    }
}

