/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositeforview;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementContentProvider;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.TreeObject;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class ProfileElementWithDisplayContentProvider
extends ProfileElementContentProvider {
    protected EModelElement diagramElement = null;

    public ProfileElementWithDisplayContentProvider(EModelElement _diagramElement) {
        this.diagramElement = _diagramElement;
    }

    public TreeObject[] getChildren(Object parent) {
        TreeObject[] objects = super.getChildren(parent);
        this.updateIsDisplay(objects);
        return objects;
    }

    private void updateIsDisplay(TreeObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof AppliedStereotypeTreeObject) {
                AppliedStereotypeTreeObject currentStTO = (AppliedStereotypeTreeObject)objects[i];
                if (this.isInStereotypeDisplay(currentStTO.getStereotype()).booleanValue()) {
                    currentStTO.setDisplay(true);
                } else {
                    currentStTO.setDisplay(false);
                }
            } else if (objects[i] instanceof AppliedStereotypePropertyTreeObject) {
                AppliedStereotypePropertyTreeObject currentPropertyTO = (AppliedStereotypePropertyTreeObject)objects[i];
                AppliedStereotypeTreeObject currentStereotypeTO = (AppliedStereotypeTreeObject)currentPropertyTO.getParent();
                if (this.isInStereoPropertyDisplay(currentPropertyTO.getProperty(), currentStereotypeTO.getStereotype()).booleanValue()) {
                    currentPropertyTO.setDisplay(true);
                } else {
                    currentPropertyTO.setDisplay(false);
                }
            }
            ++i;
        }
    }

    private Boolean isInStereoPropertyDisplay(Property property, Stereotype owner) {
        if (this.diagramElement == null) {
            return false;
        }
        return false;
    }

    public void setDiagramElement(EModelElement diagramElement) {
        this.diagramElement = diagramElement;
    }

    protected Boolean isInStereotypeDisplay(Stereotype st) {
        if (this.diagramElement == null) {
            return false;
        }
        return false;
    }
}

