/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FieldsDeclaration
extends BodyDeclaration {
    private final ASTNode.NodeList<SingleFieldDeclaration> fields = new ASTNode.NodeList(FIELDS_PROPERTY);
    public static final ChildListPropertyDescriptor FIELDS_PROPERTY = new ChildListPropertyDescriptor(FieldsDeclaration.class, "fields", SingleFieldDeclaration.class, true);
    public static final SimplePropertyDescriptor MODIFIER_PROPERTY = new SimplePropertyDescriptor(FieldsDeclaration.class, "modifier", Integer.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(1);
        properyList.add(FIELDS_PROPERTY);
        properyList.add(MODIFIER_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    @Override
    public final SimplePropertyDescriptor getModifierProperty() {
        return MODIFIER_PROPERTY;
    }

    public FieldsDeclaration(int start, int end, AST ast, int modifier, List variablesAndDefaults) {
        super(start, end, ast, modifier);
        if (variablesAndDefaults == null || variablesAndDefaults.size() == 0) {
            throw new IllegalArgumentException();
        }
        for (Object next : variablesAndDefaults) {
            if (next instanceof SingleFieldDeclaration) {
                this.fields.add((SingleFieldDeclaration)next);
                continue;
            }
            ASTNode[] element = (ASTNode[])next;
            SingleFieldDeclaration field = this.createField(ast, (Variable)element[0], (Expression)element[1]);
            this.fields.add(field);
        }
    }

    public FieldsDeclaration(AST ast) {
        super(ast);
    }

    private SingleFieldDeclaration createField(AST ast, Variable name, Expression value) {
        int start = name.getStart();
        int end = value == null ? name.getEnd() : value.getEnd();
        SingleFieldDeclaration result = new SingleFieldDeclaration(start, end, ast, name, value);
        return result;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.fields) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.fields) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.fields) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FieldsDeclaration");
        this.appendInterval(buffer);
        buffer.append(" modifier='").append(this.getModifierString()).append("'>\n");
        for (SingleFieldDeclaration node : this.fields) {
            buffer.append(tab).append("\t").append("<VariableName>\n");
            node.getName().toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("</VariableName>\n");
            buffer.append(tab).append("\t").append("<InitialValue>\n");
            Expression expr = node.getValue();
            if (expr != null) {
                expr.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append(tab).append("\t").append("</InitialValue>\n");
        }
        buffer.append(tab).append("</FieldsDeclaration>");
    }

    @Override
    public int getType() {
        return 25;
    }

    public List<SingleFieldDeclaration> fields() {
        return this.fields;
    }

    public Expression[] getInitialValues() {
        Expression[] result = new Expression[this.fields.size()];
        int i = 0;
        for (SingleFieldDeclaration field : this.fields) {
            result[i++] = field.getValue();
        }
        return result;
    }

    public Variable[] getVariableNames() {
        Variable[] result = new Variable[this.fields.size()];
        int i = 0;
        for (SingleFieldDeclaration field : this.fields) {
            result[i++] = field.getName();
        }
        return result;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == FIELDS_PROPERTY) {
            return this.fields();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List<SingleFieldDeclaration> fields = ASTNode.copySubtrees(target, this.fields());
        int modifier = this.getModifier();
        return new FieldsDeclaration(this.getStart(), this.getEnd(), target, modifier, fields);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public final IVariableBinding resolveTypeBinding() {
        return this.ast.getBindingResolver().resolveVariable(this);
    }
}

