/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class NamespaceName
extends Identifier {
    protected ASTNode.NodeList<Identifier> segments = new ASTNode.NodeList(ELEMENTS_PROPERTY);
    private boolean global;
    private boolean current;
    public static final ChildListPropertyDescriptor ELEMENTS_PROPERTY = new ChildListPropertyDescriptor(NamespaceName.class, "segments", Identifier.class, false);
    public static final SimplePropertyDescriptor GLOBAL_PROPERTY = new SimplePropertyDescriptor(NamespaceName.class, "global", Boolean.class, true);
    public static final SimplePropertyDescriptor CURRENT_PROPERTY = new SimplePropertyDescriptor(NamespaceName.class, "current", Boolean.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(5);
        properyList.add(NAME_PROPERTY);
        properyList.add(ELEMENTS_PROPERTY);
        properyList.add(GLOBAL_PROPERTY);
        properyList.add(CURRENT_PROPERTY);
        properyList.add(NULLABLE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public NamespaceName(AST ast) {
        super(ast);
    }

    public NamespaceName(int start, int end, AST ast, Identifier[] segments, boolean global, boolean current) {
        super(start, end, ast, NamespaceName.buildName(segments, global, current));
        Identifier[] identifierArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Identifier name = identifierArray[n2];
            this.segments.add(name);
            ++n2;
        }
        this.global = global;
        this.current = current;
    }

    public NamespaceName(int start, int end, AST ast, List<Identifier> segments, boolean global, boolean current) {
        super(start, end, ast, NamespaceName.buildName(segments.toArray(new Identifier[NamespaceName.getSegmentSize(segments)]), global, current));
        Iterator<Identifier> it = segments.iterator();
        while (it.hasNext()) {
            this.segments.add(it.next());
        }
        this.global = global;
        this.current = current;
    }

    private static int getSegmentSize(List<Identifier> segments) {
        if (segments == null) {
            throw new IllegalArgumentException();
        }
        return segments.size();
    }

    protected static String buildName(Identifier[] segments, boolean global, boolean current) {
        if (segments == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder buf = new StringBuilder();
        if (global) {
            buf.append('\\');
        } else if (current) {
            buf.append("namespace\\");
        }
        int i = 0;
        while (i < segments.length) {
            if (i > 0) {
                buf.append('\\');
            }
            buf.append(segments[i].getName());
            ++i;
        }
        return buf.toString();
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.segments) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.segments) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.segments) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<NamespaceName");
        this.appendInterval(buffer);
        buffer.append(" global='").append(this.global).append('\'');
        buffer.append(" current='").append(this.current).append('\'');
        if (this.isNullable()) {
            buffer.append(" nullable='").append(this.isNullable()).append('\'');
        }
        buffer.append(">\n");
        for (ASTNode aSTNode : this.segments) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</NamespaceName>");
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getType() {
        return 65;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.preValueChange(GLOBAL_PROPERTY);
        this.global = global;
        this.postValueChange(GLOBAL_PROPERTY);
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.preValueChange(CURRENT_PROPERTY);
        this.current = current;
        this.postValueChange(CURRENT_PROPERTY);
    }

    public List<Identifier> segments() {
        return this.segments;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    protected ASTNode clone0(AST target) {
        List<Identifier> segments = ASTNode.copySubtrees(target, this.segments());
        boolean global = this.isGlobal();
        boolean current = this.isCurrent();
        return new NamespaceName(this.getStart(), this.getEnd(), target, segments, global, current);
    }

    @Override
    protected List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == GLOBAL_PROPERTY) {
            if (get) {
                return this.isGlobal();
            }
            this.setGlobal(value);
            return false;
        }
        if (property == CURRENT_PROPERTY) {
            if (get) {
                return this.isCurrent();
            }
            this.setCurrent(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ELEMENTS_PROPERTY) {
            return this.segments();
        }
        return super.internalGetChildListProperty(property);
    }
}

