/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class PerFileModelAccessCache
implements IModelAccessCache {
    private ISourceModule sourceModule;
    private Map<IType, ITypeHierarchy> hierarchyCache = Collections.synchronizedMap(new HashMap());
    private Map<String, Collection<IMethod>> globalFunctionsCache;
    private Map<String, Collection<IType>> allTypesCache;
    private Map<String, Collection<IType>> allTraitsCache;
    private Map<String, Collection<IType>> allNamespacesCache;
    private ReferenceTree fileHierarchy;

    public PerFileModelAccessCache(ISourceModule sourceModule) {
        this.sourceModule = sourceModule;
        this.allTraitsCache = Collections.synchronizedMap(new HashMap());
        this.allTypesCache = Collections.synchronizedMap(new HashMap());
        this.allNamespacesCache = Collections.synchronizedMap(new HashMap());
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public ITypeHierarchy getSuperTypeHierarchy(IType type, IProgressMonitor monitor) throws ModelException {
        if (!PHPToolkitUtil.isFromPhpProject(type)) {
            return new TypeHierarchy();
        }
        ITypeHierarchy hierarchy = this.hierarchyCache.get(type);
        if (hierarchy == null) {
            hierarchy = type.newSupertypeHierarchy(monitor);
            this.hierarchyCache.put(type, hierarchy);
        }
        return hierarchy;
    }

    @Override
    public ReferenceTree getFileHierarchy(ISourceModule sourceModule, IProgressMonitor monitor) {
        if (!this.sourceModule.equals(sourceModule)) {
            return FileNetworkUtility.buildReferencedFilesTree(sourceModule, monitor);
        }
        if (this.fileHierarchy == null) {
            this.fileHierarchy = FileNetworkUtility.buildReferencedFilesTree(sourceModule, monitor);
        }
        return this.fileHierarchy;
    }

    @Override
    public <T extends IModelElement> Collection<T> filterModelElements(ISourceModule sourceModule, Collection<T> elements, IProgressMonitor monitor) {
        return PHPModelUtils.fileNetworkFilter(sourceModule, elements, this, monitor);
    }

    @Override
    public <T extends IModelElement> Collection<T> filterSameModelElements(ISourceModule sourceModule, Collection<T> elements, IProgressMonitor monitor) {
        return PHPModelUtils.filterElements(sourceModule, elements, this, monitor);
    }

    @Override
    public Collection<IMethod> getGlobalFunctions(ISourceModule sourceModule, String functionName, IProgressMonitor monitor) {
        Collection<IMethod> functions;
        if (functionName == null) {
            return new ArrayList<IMethod>();
        }
        if (!this.sourceModule.equals(sourceModule)) {
            IScriptProject scriptProject = sourceModule.getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            functions = Arrays.asList(PhpModelAccess.getDefault().findFunctions(functionName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, monitor));
        } else {
            functionName = functionName.toLowerCase();
            if (this.globalFunctionsCache == null) {
                this.globalFunctionsCache = Collections.synchronizedMap(new HashMap());
                if (!this.globalFunctionsCache.containsKey(functionName)) {
                    IScriptProject scriptProject = sourceModule.getScriptProject();
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                    IMethod[] allFunctions = PhpModelAccess.getDefault().findFunctions(functionName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, monitor);
                    ArrayList<IMethod> funcList = new ArrayList<IMethod>(allFunctions.length);
                    IMethod[] iMethodArray = allFunctions;
                    int n = allFunctions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod function = iMethodArray[n2];
                        funcList.add(function);
                        ++n2;
                    }
                    this.globalFunctionsCache.put(functionName, funcList);
                }
            }
            functions = this.globalFunctionsCache.get(functionName);
        }
        return this.filterModelElements(sourceModule, functions, monitor);
    }

    @Override
    public Collection<IType> getTypes(ISourceModule sourceModule, String typeName, String namespaceName, IProgressMonitor monitor) {
        Collection<IType> types;
        if (!this.sourceModule.equals(sourceModule)) {
            IScriptProject scriptProject = sourceModule.getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            types = Arrays.asList(PhpModelAccess.getDefault().findTypes(namespaceName, typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null));
        } else {
            typeName = typeName.toLowerCase();
            StringBuilder key = new StringBuilder();
            if (namespaceName != null && StringUtils.isNotBlank((CharSequence)namespaceName)) {
                String nameSpace = namespaceName;
                if (namespaceName.startsWith("\\") || namespaceName.startsWith("/")) {
                    nameSpace = namespaceName.substring(1);
                }
                if (nameSpace.length() > 0) {
                    key.append(nameSpace.toLowerCase()).append("$");
                }
            }
            key.append(typeName);
            String searchFor = key.toString();
            if (!this.allTypesCache.containsKey(searchFor)) {
                IScriptProject scriptProject = sourceModule.getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                this.allTypesCache.put(searchFor, Arrays.asList(PhpModelAccess.getDefault().findTypes(namespaceName, typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null)));
            }
            types = this.allTypesCache.get(searchFor);
        }
        return this.filterSameModelElements(sourceModule, types, monitor);
    }

    @Override
    public Collection<IType> getNamespaces(ISourceModule sourceModule, String namespaceName, IProgressMonitor monitor) {
        Collection<IType> namespaces;
        if (!this.sourceModule.equals(sourceModule)) {
            IScriptProject scriptProject = sourceModule.getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            namespaces = Arrays.asList(PhpModelAccess.getDefault().findNamespaces(null, namespaceName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null));
        } else {
            String searchFor = namespaceName.toLowerCase();
            if (!this.allNamespacesCache.containsKey(searchFor)) {
                IScriptProject scriptProject = sourceModule.getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                this.allNamespacesCache.put(searchFor, Arrays.asList(PhpModelAccess.getDefault().findNamespaces(null, namespaceName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null)));
            }
            namespaces = this.allNamespacesCache.get(searchFor);
        }
        return namespaces;
    }

    @Override
    public Collection<IType> getTraits(ISourceModule sourceModule, String typeName, String namespaceName, IProgressMonitor monitor) {
        Collection<IType> types;
        if (!this.sourceModule.equals(sourceModule)) {
            IScriptProject scriptProject = sourceModule.getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            types = Arrays.asList(PhpModelAccess.getDefault().findTraits(typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null));
        } else {
            typeName = typeName.toLowerCase();
            StringBuilder key = new StringBuilder();
            if (namespaceName != null && StringUtils.isNotBlank((CharSequence)namespaceName)) {
                String nameSpace = namespaceName;
                if (namespaceName.startsWith("\\") || namespaceName.startsWith("/")) {
                    nameSpace = namespaceName.substring(1);
                }
                if (nameSpace.length() > 0) {
                    key.append(nameSpace.toLowerCase()).append("$");
                }
            }
            key.append(typeName);
            String searchFor = key.toString();
            if (!this.allTraitsCache.containsKey(searchFor)) {
                IScriptProject scriptProject = sourceModule.getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                this.allTraitsCache.put(searchFor, Arrays.asList(PhpModelAccess.getDefault().findTraits(namespaceName, typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null)));
            }
            types = this.allTraitsCache.get(searchFor);
        }
        return this.filterSameModelElements(sourceModule, types, monitor);
    }

    @Override
    public Collection<IType> getClasses(ISourceModule sourceModule, String name, String namespaceName, IProgressMonitor monitor) throws ModelException {
        Collection<IType> allTypes = this.getTypes(sourceModule, name, namespaceName, monitor);
        if (allTypes == null) {
            return null;
        }
        LinkedList<IType> result = new LinkedList<IType>();
        for (IType type : allTypes) {
            if (!PHPFlags.isClass(type.getFlags())) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public Collection<IType> getInterfaces(ISourceModule sourceModule, String name, String namespaceName, IProgressMonitor monitor) throws ModelException {
        Collection<IType> allTypes = this.getTypes(sourceModule, name, namespaceName, monitor);
        if (allTypes == null) {
            return null;
        }
        LinkedList<IType> result = new LinkedList<IType>();
        for (IType type : allTypes) {
            if (!PHPFlags.isInterface((int)type.getFlags())) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public Collection<IType> getClassesOrInterfaces(ISourceModule sourceModule, String name, String namespaceName, IProgressMonitor monitor) throws ModelException {
        return this.getTypes(sourceModule, name, namespaceName, monitor);
    }
}

