/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.organizeIncludes;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.refactoring.core.RefactoringPlugin;
import org.eclipse.php.refactoring.core.organizeIncludes.CodeDataMatch;
import org.eclipse.php.refactoring.core.organizeIncludes.CodeDataSearchEngine;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class OrganizeIncludesProcessorDelegate {
    private IProject project;
    private final IFile file;
    private DOMModelForPHP model;
    IStructuredDocument document;
    Set<String> directIncludes;

    public OrganizeIncludesProcessorDelegate(IFile file) {
        this.file = file;
    }

    public boolean initializeModel() {
        this.project = this.file.getProject();
        try {
            this.project.build(9, null);
        }
        catch (CoreException coreException) {}
        try {
            this.model = (DOMModelForPHP)StructuredModelManager.getModelManager().getModelForRead(this.file);
            this.document = this.model.getStructuredDocument();
            return true;
        }
        catch (IOException e) {
            RefactoringPlugin.logException(e);
        }
        catch (CoreException e) {
            RefactoringPlugin.logException((Exception)((Object)e));
        }
        this.disposeModel();
        return false;
    }

    public Change createChange(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        return null;
    }

    public IFile getFile() {
        return this.file;
    }

    public IStructuredDocument getDocument() {
        return this.document;
    }

    private static boolean isHardMatch(Set<CodeDataMatch> matches) {
        CodeDataMatch match;
        Iterator<CodeDataMatch> iterator = matches.iterator();
        return iterator.hasNext() && !CodeDataSearchEngine.elementIsOptional((match = iterator.next()).getElementType());
    }

    void disposeModel() {
        if (this.model != null) {
            this.model.releaseFromRead();
        }
    }

    public IProject getProject() {
        return this.project;
    }
}

