/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.ui.editor.highlighter.ModelUtils;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.logic.AbstractRename;

public class RenameLocalVariable
extends AbstractRename {
    private static final String RENAME_LOCAL_VARIABLE = PhpRefactoringCoreMessages.getString("RenameLocalVariableName.0");
    private boolean isGlobalScope = false;
    private boolean beforeIfStatement;
    private boolean searchTextual;

    public RenameLocalVariable(IFile file, String oldName, String newName, boolean searchTextual) {
        super(file, oldName, newName, searchTextual);
        this.searchTextual = searchTextual;
    }

    public boolean visit(FunctionDeclaration function) {
        PHPDocBlock doc;
        boolean result = super.visit(function);
        if (this.searchTextual) {
            this.searchTextualOccurrences(function.getProgramRoot());
            return result;
        }
        IMethod method = ModelUtils.getFunctionMethod((FunctionDeclaration)function);
        if (method != null && (doc = ModelUtils.getPHPDoc((IModelElement)method)) != null) {
            PHPDocTag[] tags;
            PHPDocTag[] pHPDocTagArray = tags = doc.getTags();
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                if (tag.isValidMethodDescriptorTag() && tag.getVariableReference().getName().equals("$" + this.oldName)) {
                    this.addChange(tag.getVariableReference().sourceStart() + 1, this.getRenameDescription());
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean visit(Variable variable) {
        if (this.isGlobalVariable(variable)) {
            this.addChange((Identifier)variable.getName());
        }
        return true;
    }

    private boolean isGlobalVariable(Variable variable) {
        Identifier identifier;
        Expression variableName;
        return variable.isDollared() && (variableName = variable.getName()) instanceof Identifier && (identifier = (Identifier)variableName).getName().equals(this.oldName) && !this.isGlobalScope;
    }

    public boolean visit(IfStatement ifStatement) {
        this.beforeIfStatement = this.isGlobalScope;
        return true;
    }

    public void endVisit(IfStatement ifStatement) {
        boolean afterIfStatement = this.isGlobalScope;
        if (this.beforeIfStatement != afterIfStatement) {
            this.isGlobalScope = false;
        }
    }

    public boolean visit(GlobalStatement globalStatement) {
        List variables = globalStatement.variables();
        for (Variable variable : variables) {
            if (!this.isGlobalVariable(variable)) continue;
            this.isGlobalScope = true;
        }
        return true;
    }

    @Override
    public String getRenameDescription() {
        return RENAME_LOCAL_VARIABLE;
    }

    @Override
    protected String getTextualSearchPattern() {
        return "(\\$" + this.oldName + "|'" + this.oldName + "'|\"" + this.oldName + "\")";
    }
}

