/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.rename;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.editor.EditorHighlightingSynchronizer;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.refactoring.core.LinkedNodeFinder;
import org.eclipse.php.refactoring.core.utils.ASTUtils;
import org.eclipse.php.refactoring.ui.rename.Messages;
import org.eclipse.php.refactoring.ui.rename.PHPElementLinkedPosition;
import org.eclipse.php.refactoring.ui.rename.RenameInformationPopup;
import org.eclipse.php.refactoring.ui.rename.RenameSupport;
import org.eclipse.php.refactoring.ui.utils.PHPConventionsUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class RenameLinkedMode {
    private static RenameLinkedMode fgActiveLinkedMode;
    private final PHPStructuredEditor fEditor;
    private RenameInformationPopup fInfoPopup;
    private Point fOriginalSelection;
    private String fOriginalName;
    private PHPElementLinkedPosition fNamePosition;
    private LinkedModeModel fLinkedModeModel;
    private LinkedPositionGroup fLinkedPositionGroup;
    private final FocusEditingSupport fFocusEditingSupport;
    private boolean fShowPreview;
    private ASTNode selectedNode;

    public RenameLinkedMode(IModelElement element, PHPStructuredEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fFocusEditingSupport = new FocusEditingSupport();
    }

    public static RenameLinkedMode getActiveLinkedMode() {
        if (fgActiveLinkedMode != null) {
            StyledText textWidget;
            StructuredTextViewer viewer = RenameLinkedMode.fgActiveLinkedMode.fEditor.getTextViewer();
            if (viewer != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                return fgActiveLinkedMode;
            }
            fgActiveLinkedMode = null;
        }
        return null;
    }

    public void start() {
        if (RenameLinkedMode.getActiveLinkedMode() != null) {
            fgActiveLinkedMode.startFullDialog();
            return;
        }
        StructuredTextViewer viewer = this.fEditor.getTextViewer();
        IDocument document = viewer.getDocument();
        this.fOriginalSelection = viewer.getSelectedRange();
        int offset = this.fOriginalSelection.x;
        IEditorInput input = this.fEditor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            if (input instanceof IURIEditorInput) {
                MessageDialog.openError((Shell)this.fEditor.getEditorSite().getShell(), (String)Messages.RenameLinkedMode_1, (String)Messages.RenameLinkedMode_3);
            } else {
                MessageDialog.openError((Shell)this.fEditor.getEditorSite().getShell(), (String)Messages.RenameLinkedMode_1, (String)Messages.RenameLinkedMode_4);
            }
            return;
        }
        IFile file = ((IFileEditorInput)input).getFile();
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        if (sourceModule == null) {
            MessageDialog.openError((Shell)this.fEditor.getEditorSite().getShell(), (String)Messages.RenameLinkedMode_1, (String)Messages.RenameLinkedMode_2);
            return;
        }
        try {
            NamespaceName namespaceName;
            Program root = ASTUtils.createProgramFromSource((ISourceModule)sourceModule);
            this.fLinkedPositionGroup = new LinkedPositionGroup();
            this.selectedNode = NodeFinder.perform((ASTNode)root, (int)this.fOriginalSelection.x, (int)this.fOriginalSelection.y);
            if (this.selectedNode == null) {
                MessageDialog.openError((Shell)this.fEditor.getEditorSite().getShell(), (String)Messages.RenameLinkedMode_1, (String)Messages.RenameLinkedMode_4);
                return;
            }
            if (this.selectedNode.getParent() instanceof NamespaceName && (namespaceName = (NamespaceName)this.selectedNode.getParent()).segments() != null && namespaceName.segments().size() > 0 && !((Identifier)namespaceName.segments().get(namespaceName.segments().size() - 1)).equals((Object)this.selectedNode)) {
                MessageDialog.openError((Shell)this.fEditor.getEditorSite().getShell(), (String)Messages.RenameLinkedMode_1, (String)Messages.RenameLinkedMode_4);
                return;
            }
            this.fOriginalName = this.getCurrentElementName(this.selectedNode);
            final int pos = this.selectedNode.getStart();
            IOccurrencesFinder.OccurrenceLocation[] sameNodes = LinkedNodeFinder.findByNode((Program)root, (ASTNode)this.selectedNode);
            Arrays.sort(sameNodes, new Comparator<IOccurrencesFinder.OccurrenceLocation>(){

                @Override
                public int compare(IOccurrencesFinder.OccurrenceLocation o1, IOccurrencesFinder.OccurrenceLocation o2) {
                    return this.rank(o1) - this.rank(o2);
                }

                private int rank(IOccurrencesFinder.OccurrenceLocation node) {
                    int relativeRank = node.getOffset() + node.getLength() - pos;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            String name = "";
            int i = 0;
            while (i < sameNodes.length) {
                IOccurrencesFinder.OccurrenceLocation elem = sameNodes[i];
                PHPElementLinkedPosition linkedPosition = null;
                String oriName = document.get(elem.getOffset(), elem.getLength());
                int index = oriName.lastIndexOf(92);
                linkedPosition = index > 0 ? new PHPElementLinkedPosition(document, elem.getOffset() + (index + 1), elem.getLength() - (index + 1), i) : (index == 0 ? new PHPElementLinkedPosition(document, elem.getOffset() + (index + 1), elem.getLength() - (index + 1), i) : new PHPElementLinkedPosition(document, elem.getOffset(), elem.getLength(), i));
                if (i == 0) {
                    this.fNamePosition = linkedPosition;
                    name = this.getName(linkedPosition);
                }
                if (this.isSameString(linkedPosition, name)) {
                    this.fLinkedPositionGroup.addPosition((LinkedPosition)linkedPosition);
                }
                ++i;
            }
            this.fLinkedModeModel = new LinkedModeModel();
            this.fLinkedModeModel.addGroup(this.fLinkedPositionGroup);
            this.fLinkedModeModel.forceInstall();
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(this.fEditor));
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorSynchronizer());
            EditorLinkedModeUI ui = new EditorLinkedModeUI(this.fLinkedModeModel, (ITextViewer)viewer);
            ui.setExitPosition((ITextViewer)viewer, offset, 0, Integer.MAX_VALUE);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(document));
            ((PHPStructuredTextViewer)viewer).setFireSelectionChanged(false);
            ui.enter();
            String selectedText = "";
            selectedText = this.fOriginalSelection.y == 0 ? name : viewer.getTextWidget().getText(this.fOriginalSelection.x, this.fOriginalSelection.x + this.fOriginalSelection.y - 1);
            if (selectedText.startsWith("$")) {
                viewer.setSelectedRange(this.fOriginalSelection.x + 1, this.fOriginalSelection.y - 1);
            } else {
                viewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
            }
            if (viewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
                registry.register((IEditingSupport)this.fFocusEditingSupport);
            }
            this.openSecondaryPopup();
            fgActiveLinkedMode = this;
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.fEditor.getEditorSite().getShell(), (String)Messages.RenameLinkedMode_1, (String)Messages.RenameLinkedMode_4);
        }
    }

    private boolean isSameString(PHPElementLinkedPosition linkedPosition, String name) throws BadLocationException {
        return name.equals(this.getName(linkedPosition));
    }

    private String getName(PHPElementLinkedPosition linkedPosition) throws BadLocationException {
        IDocument document = this.fEditor.getDocument();
        String name = document.get(linkedPosition.offset, linkedPosition.length);
        return name;
    }

    void doRename(boolean showPreview) {
        this.cancel();
        Image image = null;
        Label label = null;
        this.fShowPreview |= showPreview;
        try {
            String newName;
            SourceViewer sourceViewer;
            Control viewerControl;
            StructuredTextViewer viewer = this.fEditor.getTextViewer();
            if (viewer instanceof SourceViewer && (viewerControl = (sourceViewer = (SourceViewer)viewer).getControl()) instanceof Composite) {
                Point size;
                Composite composite = (Composite)viewerControl;
                Display display = composite.getDisplay();
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
                GC gc = new GC((Drawable)composite);
                try {
                    size = composite.getSize();
                    image = new Image(gc.getDevice(), size.x, size.y);
                    gc.copyArea(image, 0, 0);
                }
                finally {
                    gc.dispose();
                    gc = null;
                }
                label = new Label(composite, 0);
                label.setImage(image);
                label.setBounds(0, 0, size.x, size.y);
                label.moveAbove(null);
            }
            if (this.fOriginalName.equals(newName = this.fNamePosition.getContent())) {
                return;
            }
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
            if (renameSupport == null) {
                return;
            }
            try {
                boolean executed;
                Shell shell = this.fEditor.getSite().getShell();
                if (this.fShowPreview) {
                    executed = renameSupport.openDialog(shell);
                } else {
                    renameSupport.perform(shell, (IRunnableContext)this.fEditor.getSite().getWorkbenchWindow());
                    executed = true;
                }
                if (executed) {
                    this.restoreFullSelection();
                }
                IFile file = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
                ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
                Program program = ASTUtils.createProgramFromSource((ISourceModule)sourceModule);
                ScriptModelUtil.reconcile((ISourceModule)sourceModule);
                this.fEditor.reconciled(program, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
        }
        finally {
            if (label != null) {
                label.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    public void cancel() {
        if (this.fLinkedModeModel != null) {
            this.fLinkedModeModel.exit(0);
        }
        this.linkedModeLeft();
    }

    private void restoreFullSelection() {
        if (this.fOriginalSelection.y != 0) {
            int originalOffset = this.fOriginalSelection.x;
            LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
            int i = 0;
            while (i < positions.length) {
                LinkedPosition position = positions[i];
                if (!position.isDeleted() && position.includes(originalOffset)) {
                    this.fEditor.getTextViewer().setSelectedRange(position.offset, position.length);
                    return;
                }
                ++i;
            }
        }
    }

    private RenameSupport undoAndCreateRenameSupport(String newName) throws CoreException {
        StructuredTextViewer viewer = this.fEditor.getTextViewer();
        try {
            try {
                if (!this.fOriginalName.equals(newName)) {
                    this.fEditor.getSite().getWorkbenchWindow().run(false, true, new IRunnableWithProgress((ISourceViewer)viewer){
                        private final /* synthetic */ ISourceViewer val$viewer;
                        {
                            this.val$viewer = iSourceViewer;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IUndoManager undoManager;
                            if (this.val$viewer instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)this.val$viewer).getUndoManager()) != null && undoManager.undoable()) {
                                undoManager.undo();
                            }
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.refactoring.ui", Messages.RenameLinkedMode_0, (Throwable)e));
            }
            catch (InterruptedException interruptedException) {
                IFile file = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
                ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
                try {
                    Program program = ASTUtils.createProgramFromSource((ISourceModule)sourceModule);
                    ScriptModelUtil.reconcile((ISourceModule)sourceModule);
                    this.fEditor.reconciled(program, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            IFile file = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
            ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
            try {
                Program program = ASTUtils.createProgramFromSource((ISourceModule)sourceModule);
                ScriptModelUtil.reconcile((ISourceModule)sourceModule);
                this.fEditor.reconciled(program, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
            throw throwable;
        }
        IFile file = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        try {
            Program program = ASTUtils.createProgramFromSource((ISourceModule)sourceModule);
            ScriptModelUtil.reconcile((ISourceModule)sourceModule);
            this.fEditor.reconciled(program, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {}
        viewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
        int elementType = PhpElementConciliator.concile((ASTNode)this.selectedNode);
        RenameSupport renameSupport = RenameSupport.create(this.selectedNode.getProgramRoot().getSourceModule().getResource(), elementType, this.selectedNode, newName, 1);
        return renameSupport;
    }

    public void startFullDialog() {
        this.cancel();
        try {
            String newName = this.fNamePosition.getContent();
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
            if (renameSupport != null) {
                renameSupport.openDialog(this.fEditor.getSite().getShell());
            }
        }
        catch (CoreException coreException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    private void linkedModeLeft() {
        StructuredTextViewer viewer;
        fgActiveLinkedMode = null;
        if (this.fInfoPopup != null) {
            this.fInfoPopup.close();
        }
        if ((viewer = this.fEditor.getTextViewer()) instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister((IEditingSupport)this.fFocusEditingSupport);
        }
        ((PHPStructuredTextViewer)viewer).setFireSelectionChanged(true);
    }

    private void openSecondaryPopup() {
        this.fInfoPopup = new RenameInformationPopup(this.fEditor, this);
        this.fInfoPopup.open();
    }

    public boolean isCaretInLinkedPosition() {
        return this.getCurrentLinkedPosition() != null;
    }

    public LinkedPosition getCurrentLinkedPosition() {
        Point selection = this.fEditor.getTextViewer().getSelectedRange();
        int start = selection.x;
        int end = start + selection.y;
        LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
        int i = 0;
        while (i < positions.length) {
            LinkedPosition position = positions[i];
            if (position.includes(start) && position.includes(end)) {
                return position;
            }
            ++i;
        }
        return null;
    }

    public boolean isEnabled() {
        String newName;
        block3: {
            try {
                newName = this.fNamePosition.getContent();
                if (!this.fOriginalName.equals(newName)) break block3;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return PHPConventionsUtil.validateIdentifier(newName);
    }

    public boolean isOriginalName() {
        try {
            String newName = this.fNamePosition.getContent();
            return this.fOriginalName.equals(newName);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public String getCurrentElementName(ASTNode identifier) {
        if (identifier instanceof Variable) {
            Identifier id = (Identifier)((Variable)identifier).getName();
            return id.getName();
        }
        if (identifier instanceof Identifier) {
            return ((Identifier)identifier).getName();
        }
        if (identifier.getType() == 51) {
            String stringValue = ((Scalar)identifier).getStringValue();
            if (((Scalar)identifier).getStringValue().charAt(0) == '\"') {
                return stringValue.substring(1, stringValue.length() - 1);
            }
            return stringValue;
        }
        return identifier.toString();
    }

    private class EditorSynchronizer
    implements ILinkedModeListener {
        private EditorSynchronizer() {
        }

        public void left(LinkedModeModel model, int flags) {
            RenameLinkedMode.this.linkedModeLeft();
            if ((flags & 2) != 0) {
                RenameLinkedMode.this.doRename(RenameLinkedMode.this.fShowPreview);
            }
        }

        public void resume(LinkedModeModel model, int flags) {
        }

        public void suspend(LinkedModeModel model) {
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private IDocument fDocument;

        public ExitPolicy(IDocument document) {
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            LinkedPosition position;
            RenameLinkedMode.this.fShowPreview = (event.stateMask & 0x40000) != 0 && (event.character == '\r' || event.character == '\n');
            if (length == 0 && (event.character == '\b' || event.character == '\u007f') && (position = model.findPosition((LinkedPosition)new PHPElementLinkedPosition(this.fDocument, offset, 0, -1))) != null) {
                if (event.character == '\b') {
                    if (offset - 1 < position.getOffset()) {
                        event.doit = false;
                    }
                } else if (offset + 1 > position.getOffset() + position.getLength()) {
                    event.doit = false;
                }
            }
            return null;
        }
    }

    private class FocusEditingSupport
    implements IEditingSupport {
        private FocusEditingSupport() {
        }

        public boolean ownsFocusShell() {
            Shell activeShell;
            if (RenameLinkedMode.this.fInfoPopup == null) {
                return false;
            }
            if (RenameLinkedMode.this.fInfoPopup.ownsFocusShell()) {
                return true;
            }
            Shell editorShell = RenameLinkedMode.this.fEditor.getSite().getShell();
            return editorShell == (activeShell = editorShell.getDisplay().getActiveShell());
        }

        public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
            return false;
        }
    }
}

